/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskCache {
    private static String root;
    private static boolean standardPolicy;
    private static boolean checkExist;
    public static boolean simulateUnwritableDir;

    public static void setRootDirectory(String cacheDir) {
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        root = StringUtil.replace(cacheDir, '\\', "/");
        DiskCache.makeRootDirectory();
    }

    public static void makeRootDirectory() {
        File dir = new File(root);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("DiskCache.setRootDirectory(): could not create root directory <" + root + ">.");
        }
        checkExist = true;
    }

    public static String getRootDirectory() {
        return root;
    }

    public static void setCachePolicy(boolean alwaysInCache) {
        standardPolicy = alwaysInCache;
    }

    public static File getFileStandardPolicy(String fileLocation) {
        return DiskCache.getFile(fileLocation, standardPolicy);
    }

    public static File getFile(String fileLocation, boolean alwaysInCache) {
        if (alwaysInCache) {
            return DiskCache.getCacheFile(fileLocation);
        }
        File f = new File(fileLocation);
        if (f.exists()) {
            return f;
        }
        try {
            if (!simulateUnwritableDir && f.createNewFile()) {
                f.delete();
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DiskCache.getCacheFile(fileLocation);
    }

    public static File getCacheFile(String fileLocation) {
        File f = new File(DiskCache.makeCachePath(fileLocation));
        if (f.exists()) {
            f.setLastModified(System.currentTimeMillis());
        }
        if (!checkExist) {
            File dir = f.getParentFile();
            dir.mkdirs();
            checkExist = true;
        }
        return f;
    }

    private static String makeCachePath(String fileLocation) {
        String cachePath;
        try {
            fileLocation = fileLocation.replace('\\', '/');
            cachePath = URLEncoder.encode(fileLocation, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            cachePath = URLEncoder.encode(fileLocation);
        }
        return root + cachePath;
    }

    public static void showCache(PrintStream pw) {
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(root);
        for (File file : dir.listFiles()) {
            String org = null;
            try {
                org = URLDecoder.decode(file.getName(), "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            pw.println(" " + file.length() + " " + new Date(file.lastModified()) + " " + org);
        }
    }

    public static void cleanCache(Date cutoff, StringBuilder sbuff) {
        if (sbuff != null) {
            sbuff.append("CleanCache files before ").append(cutoff).append("\n");
        }
        File dir = new File(root);
        for (File file : dir.listFiles()) {
            Date lastMod = new Date(file.lastModified());
            if (!lastMod.before(cutoff)) continue;
            file.delete();
            if (sbuff == null) continue;
            sbuff.append(" delete ").append(file).append(" (").append(lastMod).append(")\n");
        }
    }

    public static void cleanCache(long maxBytes, StringBuilder sbuff) {
        DiskCache.cleanCache(maxBytes, new FileAgeComparator(), sbuff);
    }

    public static void cleanCache(long maxBytes, Comparator<File> fileComparator, StringBuilder sbuff) {
        if (sbuff != null) {
            sbuff.append("DiskCache clean maxBytes= " + maxBytes + "on dir " + root + "\n");
        }
        File dir = new File(root);
        File[] files = dir.listFiles();
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, fileComparator);
        long total = 0L;
        long total_delete = 0L;
        for (File file : fileList) {
            if (file.length() + total > maxBytes) {
                total_delete += file.length();
                if (sbuff != null) {
                    sbuff.append(" delete " + file + " (" + file.length() + ")\n");
                }
                file.delete();
                continue;
            }
            total += file.length();
        }
        if (sbuff != null) {
            sbuff.append("Total bytes deleted= " + total_delete + "\n");
            sbuff.append("Total bytes left in cache= " + total + "\n");
        }
    }

    static void make(String filename) throws IOException {
        File want = DiskCache.getCacheFile(filename);
        System.out.println("make=" + want.getPath() + "; exists = " + want.exists());
        if (!want.exists()) {
            want.createNewFile();
        }
        System.out.println(" canRead= " + want.canRead() + " canWrite = " + want.canWrite() + " lastMod = " + new Date(want.lastModified()));
        try {
            String enc = URLEncoder.encode(filename, "UTF8");
            System.out.println(" original=" + URLDecoder.decode(enc, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        DiskCache.setRootDirectory("C:/temp/chill/");
        DiskCache.make("C:/junk.txt");
        DiskCache.make("C:/some/enchanted/evening/joots+3478.txt");
        DiskCache.make("http://www.unidata.ucar.edu/some/enc hanted/eve'ning/nowrite.gibberish");
        DiskCache.showCache(System.out);
        StringBuilder sbuff = new StringBuilder();
        DiskCache.cleanCache(10000000L, sbuff);
        System.out.println(sbuff);
    }

    static {
        String policy;
        root = null;
        standardPolicy = false;
        checkExist = false;
        simulateUnwritableDir = false;
        root = System.getProperty("nj22.cache");
        if (root == null) {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            root = home + "/.unidata/cache/";
        }
        if ((policy = System.getProperty("nj22.cachePolicy")) != null) {
            standardPolicy = policy.equalsIgnoreCase("true");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileAgeComparator
    implements Comparator<File> {
        private FileAgeComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return (int)(f2.lastModified() - f1.lastModified());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSizeComparator
    implements Comparator<File> {
        private FileSizeComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return (int)(f1.length() - f2.length());
        }
    }
}

