/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import visad.CommonUnit;
import visad.CoordinateSystemException;
import visad.PlotText;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;

public class Radar3DCoordinateSystem
extends NavigatedCoordinateSystem {
    public static final double EARTH_RADIUS = 6367681.04774543;
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
    private float centlat;
    private float centlon;
    private float centalt;
    private float radlow;
    private float radres;
    private float azlow;
    private float azres;
    private float elevlow;
    private float elevres;
    private double coscentlat;
    private double lonscale;
    private double latscale;

    public Radar3DCoordinateSystem(float clat, float clon, float calt) throws VisADException {
        this(new RealTupleType(RealType.Latitude, RealType.Longitude, RealType.Altitude), clat, clon, calt, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public Radar3DCoordinateSystem(float clat, float clon, float calt, float radl, float radr, float azl, float azr, float elevl, float elevr) throws VisADException {
        this(new RealTupleType(RealType.Latitude, RealType.Longitude, RealType.Altitude), clat, clon, calt, radl, radr, azl, azr, elevl, elevr);
    }

    public Radar3DCoordinateSystem(RealTupleType reference, float clat, float clon, float radl, float radr, float azl, float azr, float elevl, float elevr) throws VisADException {
        this(reference, clat, clon, 0.0f, radl, radr, azl, azr, elevl, elevr);
    }

    public Radar3DCoordinateSystem(RealTupleType reference, float clat, float clon, float calt, float radl, float radr, float azl, float azr, float elevl, float elevr) throws VisADException {
        super(reference, coordinate_system_units);
        this.centlat = clat;
        this.centlon = clon;
        this.centalt = calt;
        this.radlow = radl;
        this.radres = radr;
        this.azlow = azl;
        this.azres = azr;
        this.elevlow = elevl;
        this.elevres = elevr;
        this.coscentlat = Math.cos(Math.PI / 180 * (double)this.centlat);
        this.lonscale = 111137.0 * this.coscentlat;
        this.latscale = 111137.0;
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = tuples;
        double er = 6367681.04774543 + (double)this.centalt;
        for (int i = 0; i < len; ++i) {
            double rad = (double)this.radlow + (double)this.radres * tuples[0][i];
            if (rad < 0.0) {
                value[0][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[2][i] = Double.NaN;
                continue;
            }
            double az = (double)this.azlow + (double)this.azres * tuples[1][i];
            double cosaz = Math.cos(Math.PI / 180 * az);
            double sinaz = Math.sin(Math.PI / 180 * az);
            double elev = (double)this.elevlow + (double)this.elevres * tuples[2][i];
            double coselev = Math.cos(Math.PI / 180 * elev);
            double sinelev = Math.sin(Math.PI / 180 * elev);
            double rp = Math.sqrt(er * er + rad * rad + 2.0 * sinelev * er * rad);
            value[2][i] = rp - er + (double)this.centalt;
            double angle = Math.asin(coselev * rad / rp);
            double radp = er * angle;
            value[0][i] = (double)this.centlat + cosaz * radp / this.latscale;
            value[1][i] = (double)this.centlon + sinaz * radp / this.lonscale;
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = tuples;
        double er = 6367681.04774543 + (double)this.centalt;
        for (int i = 0; i < len; ++i) {
            double slat = (tuples[0][i] - (double)this.centlat) * this.latscale;
            double slon = (tuples[1][i] - (double)this.centlon) * this.lonscale;
            double radp = Math.sqrt(slat * slat + slon * slon);
            double angle = radp / er;
            double alt_over = tuples[2][i] - (double)this.centalt;
            double rp = er + alt_over;
            double rad = Math.sqrt(er * er + rp * rp - 2.0 * rp * er * Math.cos(angle));
            double elev = 57.29577951308232 * Math.acos(Math.sin(angle) * rp / rad);
            if (alt_over < 0.0) {
                elev = -elev;
            }
            value[0][i] = (rad - (double)this.radlow) / (double)this.radres;
            value[1][i] = (57.29577951308232 * Math.atan2(slon, slat) - (double)this.azlow) / (double)this.azres;
            value[2][i] = (elev - (double)this.elevlow) / (double)this.elevres;
            if (!(value[1][i] < 0.0)) continue;
            double[] dArray = value[1];
            int n = i;
            dArray[n] = dArray[n] + 360.0;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = tuples;
        double er = 6367681.04774543 + (double)this.centalt;
        for (int i = 0; i < len; ++i) {
            double rad = this.radlow + this.radres * tuples[0][i];
            if (rad < 0.0) {
                value[0][i] = Float.NaN;
                value[1][i] = Float.NaN;
                value[2][i] = Float.NaN;
                continue;
            }
            double az = this.azlow + this.azres * tuples[1][i];
            double cosaz = Math.cos(Math.PI / 180 * az);
            double sinaz = Math.sin(Math.PI / 180 * az);
            double elev = this.elevlow + this.elevres * tuples[2][i];
            double coselev = Math.cos(Math.PI / 180 * elev);
            double sinelev = Math.sin(Math.PI / 180 * elev);
            double rp = Math.sqrt(er * er + rad * rad + 2.0 * sinelev * er * rad);
            value[2][i] = (float)(rp - er) + this.centalt;
            double angle = Math.asin(coselev * rad / rp);
            double radp = er * angle;
            value[0][i] = (float)((double)this.centlat + cosaz * radp / this.latscale);
            value[1][i] = (float)((double)this.centlon + sinaz * radp / this.lonscale);
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("Radar3DCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = tuples;
        double er = 6367681.04774543 + (double)this.centalt;
        for (int i = 0; i < len; ++i) {
            double slat = (double)(tuples[0][i] - this.centlat) * this.latscale;
            double slon = (double)(tuples[1][i] - this.centlon) * this.lonscale;
            double radp = Math.sqrt(slat * slat + slon * slon);
            double angle = radp / er;
            double alt_over = tuples[2][i] - this.centalt;
            double rp = er + alt_over;
            double rad = Math.sqrt(er * er + rp * rp - 2.0 * rp * er * Math.cos(angle));
            double elev = 57.29577951308232 * Math.acos(Math.sin(angle) * rp / rad);
            if (alt_over < 0.0) {
                elev = -elev;
            }
            value[0][i] = (float)((rad - (double)this.radlow) / (double)this.radres);
            value[1][i] = (float)((57.29577951308232 * Math.atan2(slon, slat) - (double)this.azlow) / (double)this.azres);
            value[2][i] = (float)((elev - (double)this.elevlow) / (double)this.elevres);
            if (!(value[1][i] < 0.0f)) continue;
            float[] fArray = value[1];
            int n = i;
            fArray[n] = fArray[n] + 360.0f;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof Radar3DCoordinateSystem;
    }

    public float[] getElevationParameters() {
        return new float[]{this.elevlow, this.elevres};
    }

    public float[] getAzimuthParameters() {
        return new float[]{this.azlow, this.azres};
    }

    public float[] getRangeParameters() {
        return new float[]{this.radlow, this.radres};
    }

    public float[] getCenterPoint() {
        return new float[]{this.centlat, this.centlon, this.centalt};
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Radar 3D CoordinateSystem: \n");
        buf.append("  Center point = Lat: ");
        buf.append(PlotText.shortString(this.centlat));
        buf.append(" Lon: ");
        buf.append(PlotText.shortString(this.centlon));
        buf.append(" Alt: ");
        buf.append(PlotText.shortString(this.centalt));
        buf.append("\n");
        buf.append("  Range params = ");
        buf.append(PlotText.shortString(this.radlow));
        buf.append(",");
        buf.append(PlotText.shortString(this.radres));
        buf.append("\n");
        buf.append("  Azimuth params = ");
        buf.append(PlotText.shortString(this.azlow));
        buf.append(",");
        buf.append(PlotText.shortString(this.azres));
        buf.append("\n");
        buf.append("  Elevation params = ");
        buf.append(PlotText.shortString(this.elevlow));
        buf.append(",");
        buf.append(PlotText.shortString(this.elevres));
        return buf.toString();
    }
}

