/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.util.Date;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class DateRange {
    private DateType start;
    private DateType end;
    private TimeDuration duration;
    private TimeDuration resolution;
    private boolean isEmpty;
    private boolean isMoving;
    private boolean useStart;
    private boolean useEnd;
    private boolean useDuration;
    private boolean useResolution;
    private int hashCode = 0;

    public DateRange() throws ParseException {
        this(null, new DateType(false, new Date()), new TimeDuration("1 day"), new TimeDuration("15 min"));
    }

    public DateRange(Date start, Date end) {
        this(new DateType(false, start), new DateType(false, end), null, null);
    }

    public DateRange(Date start, TimeDuration duration) {
        this(new DateType(false, start), null, duration, null);
    }

    public DateRange(DateRange range, String timeUnits) throws Exception {
        this(new DateType(false, range.getStart().getDate()), new DateType(false, range.getEnd().getDate()), null, new TimeDuration(timeUnits));
    }

    public DateRange(DateType start, DateType end, TimeDuration duration, TimeDuration resolution) {
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.resolution = resolution;
        this.useStart = start != null && !start.isBlank();
        this.useEnd = end != null && !end.isBlank();
        this.useDuration = duration != null;
        this.useResolution = resolution != null;
        boolean invalid = true;
        if (this.useStart && this.useEnd) {
            invalid = false;
            this.isMoving = this.start.isPresent() || this.end.isPresent();
            this.useDuration = false;
            this.recalcDuration();
        } else if (this.useStart && this.useDuration) {
            invalid = false;
            this.isMoving = this.start.isPresent();
            this.end = this.start.add(duration);
        } else if (this.useEnd && this.useDuration) {
            invalid = false;
            this.isMoving = this.end.isPresent();
            this.start = this.end.subtract(duration);
        }
        if (invalid) {
            throw new IllegalArgumentException("DateRange must have 2 of start, end, duration");
        }
        this.checkIfEmpty();
        this.hashCode = 0;
    }

    private void checkIfEmpty() {
        this.isEmpty = this.start.isPresent() && this.end.isPresent() ? true : (this.start.isPresent() || this.end.isPresent() ? this.duration.getValue() <= 0.0 : this.end.before(this.start));
        if (this.isEmpty) {
            this.duration.setValueInSeconds(0.0);
        }
    }

    private String chooseResolution(double time) {
        if (time < 180.0) {
            return "secs";
        }
        if ((time /= 60.0) < 180.0) {
            return "minutes";
        }
        if ((time /= 60.0) < 72.0) {
            return "hours";
        }
        if ((time /= 24.0) < 90.0) {
            return "days";
        }
        if ((time /= 30.0) < 36.0) {
            return "months";
        }
        return "years";
    }

    public boolean included(Date d) {
        if (this.isEmpty) {
            return false;
        }
        if (this.getStart().after(d)) {
            return false;
        }
        return !this.getEnd().before(d);
    }

    public boolean contains(Date d) {
        return this.included(d);
    }

    public boolean intersects(Date start_want, Date end_want) {
        if (this.isEmpty) {
            return false;
        }
        if (this.getStart().after(end_want)) {
            return false;
        }
        return !this.getEnd().before(start_want);
    }

    public boolean intersects(DateRange other) {
        return this.intersects(other.getStart().getDate(), other.getEnd().getDate());
    }

    public DateRange intersect(DateRange clip) {
        if (this.isEmpty) {
            return this;
        }
        if (clip.isEmpty) {
            return clip;
        }
        DateType ss = this.getStart();
        DateType s = ss.before(clip.getStart()) ? clip.getStart() : ss;
        DateType ee = this.getEnd();
        DateType e = ee.before(clip.getEnd()) ? ee : clip.getEnd();
        return new DateRange(s, e, null, this.resolution);
    }

    public void extend(DateRange dr) {
        boolean localEmpty = this.isEmpty;
        if (localEmpty || dr.getStart().before(this.getStart())) {
            this.setStart(dr.getStart());
        }
        if (localEmpty || this.getEnd().before(dr.getEnd())) {
            this.setEnd(dr.getEnd());
        }
    }

    public void extend(Date d) {
        if (d.before(this.getStart().getDate())) {
            this.setStart(new DateType(false, d));
        }
        if (this.getEnd().before(d)) {
            this.setEnd(new DateType(false, d));
        }
    }

    public DateType getStart() {
        return this.isMoving && !this.useStart ? this.end.subtract(this.duration) : this.start;
    }

    public void setStart(DateType start) {
        this.start = start;
        this.useStart = true;
        if (this.useEnd) {
            this.isMoving = this.start.isPresent() || this.end.isPresent();
            this.useDuration = false;
            this.recalcDuration();
        } else {
            this.isMoving = this.start.isPresent();
            this.end = this.start.add(this.duration);
        }
        this.checkIfEmpty();
    }

    public DateType getEnd() {
        return this.isMoving && !this.useEnd ? this.start.add(this.duration) : this.end;
    }

    public void setEnd(DateType end) {
        this.end = end;
        this.useEnd = true;
        if (this.useStart) {
            this.isMoving = this.start.isPresent() || this.end.isPresent();
            this.useDuration = false;
            this.recalcDuration();
        } else {
            this.isMoving = this.end.isPresent();
            this.start = this.end.subtract(this.duration);
        }
        this.checkIfEmpty();
    }

    public TimeDuration getDuration() {
        if (this.isMoving && !this.useDuration) {
            this.recalcDuration();
        }
        return this.duration;
    }

    public void setDuration(TimeDuration duration) {
        this.duration = duration;
        this.useDuration = true;
        if (this.useStart) {
            this.isMoving = this.start.isPresent();
            this.end = this.start.add(duration);
            this.useEnd = false;
        } else {
            this.isMoving = this.end.isPresent();
            this.start = this.end.subtract(duration);
        }
        this.checkIfEmpty();
    }

    private void recalcDuration() {
        long min = this.getStart().getDate().getTime();
        long max = this.getEnd().getDate().getTime();
        double secs = 0.001 * (double)(max - min);
        if (secs < 0.0) {
            secs = 0.0;
        }
        if (this.duration == null) {
            try {
                this.duration = new TimeDuration(this.chooseResolution(secs));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (this.resolution == null) {
            this.duration.setValueInSeconds(secs);
        } else {
            double resSecs = this.resolution.getValueInSeconds();
            double closest = Math.round(secs / resSecs);
            secs = closest * resSecs;
            this.duration.setValueInSeconds(secs);
        }
        this.hashCode = 0;
    }

    public TimeDuration getResolution() {
        return this.resolution;
    }

    public void setResolution(TimeDuration resolution) {
        this.resolution = resolution;
        this.useResolution = true;
    }

    public boolean useStart() {
        return this.useStart;
    }

    public boolean useEnd() {
        return this.useEnd;
    }

    public boolean useDuration() {
        return this.useDuration;
    }

    public boolean useResolution() {
        return this.useResolution;
    }

    public boolean isPoint() {
        return !this.isEmpty && this.start.equals(this.end);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String toString() {
        return "start= " + this.start + " end= " + this.end + " duration= " + this.duration + " resolution= " + this.resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateRange)) {
            return false;
        }
        DateRange oo = (DateRange)o;
        if (this.useStart && !this.start.equals(oo.start)) {
            return false;
        }
        if (this.useEnd && !this.end.equals(oo.end)) {
            return false;
        }
        if (this.useDuration && !this.duration.equals(oo.duration)) {
            return false;
        }
        return !this.useResolution || this.resolution.equals(oo.resolution);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.useStart) {
                result = 37 * result + this.start.hashCode();
            }
            if (this.useEnd) {
                result = 37 * result + this.end.hashCode();
            }
            if (this.useDuration) {
                result = 37 * result + this.duration.hashCode();
            }
            if (this.useResolution) {
                result = 37 * result + this.resolution.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

