/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.bounce.text.xml.WrappedXMLView;
import org.bounce.text.xml.XMLContext;
import org.bounce.text.xml.XMLDocument;
import org.bounce.text.xml.XMLStyleConstants;
import org.bounce.text.xml.XMLView;
import org.bounce.text.xml.XMLViewUtilities;

public class XMLEditorKit
extends DefaultEditorKit
implements XMLStyleConstants {
    private static final long serialVersionUID = 6303638967973333256L;
    private XMLContext context = null;
    private ViewFactory factory = new XMLViewFactory();
    private JEditorPane editor = null;
    private boolean lineWrapping = false;
    private boolean wrapStyleWord = false;
    private boolean folding = false;

    public XMLEditorKit() {
        this(false);
    }

    public void install(JEditorPane c) {
        super.install(c);
        this.editor = c;
    }

    public XMLEditorKit(boolean lineWrapping) {
        this.context = new XMLContext();
        this.lineWrapping = lineWrapping;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    public void setLineWrappingEnabled(boolean enabled) {
        this.lineWrapping = enabled;
    }

    public boolean isWrapStyleWord() {
        return this.wrapStyleWord;
    }

    public void setWrapStyleWord(boolean enabled) {
        this.wrapStyleWord = enabled;
    }

    public boolean isFolding() {
        return this.folding;
    }

    public void setFolding(boolean folding) {
        this.folding = folding;
    }

    public String getContentType() {
        return "text/xml";
    }

    public final ViewFactory getViewFactory() {
        return this.factory;
    }

    public void setStyle(String name, Color foreground, int fontStyle) {
        this.context.setStyle(name, foreground, fontStyle);
    }

    public Document createDefaultDocument() {
        return new XMLDocument(this.editor);
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
        if (this.folding && doc.getProperty("folding-marking") == null) {
            this.editor.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
            this.editor.addMouseListener(new FoldingMouseListener());
            doc.putProperty("folding-marking", new TreeMap());
            doc.putProperty("document-source", doc.getText(0, doc.getLength() - 1));
        }
    }

    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        doc.putProperty("loading", Boolean.TRUE);
        super.read(in, doc, pos);
        doc.putProperty("loading", Boolean.FALSE);
        if (this.folding && doc.getProperty("folding-marking") == null) {
            this.editor.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
            this.editor.addMouseListener(new FoldingMouseListener());
            doc.putProperty("folding-marking", new TreeMap());
            doc.putProperty("document-source", doc.getText(0, doc.getLength() - 1));
        }
    }

    class FoldingMouseListener
    extends MouseAdapter {
        FoldingMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point clickPoint = e.getPoint();
            Document document = XMLEditorKit.this.editor.getDocument();
            Map tagsMap = (Map)document.getProperty("folding-marking");
            if (tagsMap != null) {
                Integer key;
                Polygon polygon;
                XMLViewUtilities.TagInfo tagInfo = null;
                Iterator i$ = tagsMap.keySet().iterator();
                while (!(!i$.hasNext() || (polygon = (tagInfo = (XMLViewUtilities.TagInfo)tagsMap.get(key = (Integer)i$.next())).getFirstPolygon()) != null && polygon.contains(clickPoint) || !tagInfo.isFolded() && (polygon = tagInfo.getSecondPolygon()) != null && polygon.contains(clickPoint))) {
                    tagInfo = null;
                }
                if (tagInfo != null) {
                    try {
                        tagInfo.setFolded(!tagInfo.isFolded());
                        StringBuffer originalTextBuffer = new StringBuffer((String)document.getProperty("document-source"));
                        String currentText = document.getText(0, document.getLength());
                        int skipMark = -1;
                        int offset = 0;
                        for (Integer key2 : tagsMap.keySet()) {
                            XMLViewUtilities.TagInfo curTagInfo = (XMLViewUtilities.TagInfo)tagsMap.get(key2);
                            if (skipMark != -1 && skipMark != key2) continue;
                            skipMark = skipMark == -1 && curTagInfo.isFolded() ? curTagInfo.getSecondMark() : -1;
                            if ((curTagInfo.equals(tagInfo) || curTagInfo.isFolded()) && !curTagInfo.isProcessed()) {
                                int lastOriginalMark;
                                int startMark = curTagInfo.getFirstMark();
                                if (curTagInfo.isFolded()) {
                                    lastOriginalMark = originalTextBuffer.indexOf("</" + curTagInfo.getTag() + ">", startMark += offset);
                                    this.removeFragment(originalTextBuffer, startMark, lastOriginalMark + curTagInfo.getTag().length() + 3);
                                    String tempString = "<" + curTagInfo.getTag() + " {...}/>";
                                    int inserted = this.insertFragment(originalTextBuffer, startMark, tempString);
                                    if (curTagInfo.equals(tagInfo)) {
                                        int lastCurrentMark = currentText.indexOf("</" + curTagInfo.getTag() + ">", startMark);
                                        offset += startMark - lastCurrentMark - curTagInfo.getTag().length() - 3;
                                        offset += inserted;
                                    }
                                } else if (curTagInfo.equals(tagInfo)) {
                                    lastOriginalMark = originalTextBuffer.indexOf("</" + curTagInfo.getTag() + ">", startMark += offset);
                                    offset -= curTagInfo.getTag().length() + 9;
                                    offset += lastOriginalMark + curTagInfo.getTag().length() + 3 - startMark;
                                }
                                curTagInfo.setProcessed(true);
                                continue;
                            }
                            curTagInfo.setProcessed(false);
                        }
                        int caretPosition = XMLEditorKit.this.editor.getCaretPosition();
                        XMLEditorKit.this.editor.setText(originalTextBuffer.toString());
                        if (caretPosition < originalTextBuffer.length()) {
                            XMLEditorKit.this.editor.setCaretPosition(caretPosition);
                        }
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
            }
        }

        private int insertFragment(StringBuffer stringBuffer, int offset, String string) {
            stringBuffer.insert(offset, string);
            return string.length();
        }

        private int removeFragment(StringBuffer stringBuffer, int startIndex, int endIndex) {
            stringBuffer.delete(startIndex, endIndex);
            return startIndex - endIndex;
        }
    }

    class XMLViewFactory
    implements ViewFactory {
        XMLViewFactory() {
        }

        public View create(Element elem) {
            if (XMLEditorKit.this.lineWrapping) {
                try {
                    return new WrappedXMLView(XMLEditorKit.this.context, elem, XMLEditorKit.this.wrapStyleWord);
                }
                catch (IOException e) {
                }
            } else {
                try {
                    return new XMLView(XMLEditorKit.this.context, elem);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

