/******************************************************************** 
   Copyright (C) 2000 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <gnome.h>

#include "guiprefs.h"
#include "main.h"
#include "hldat.h"
#include "pixmap.h"

#include "pixmaps/folder_blue.xpm"
#include "pixmaps/folder_green.xpm"
#include "pixmaps/file_normal.xpm"
#include "pixmaps/file_red.xpm"
#include "pixmaps/pubchat.xpm"
#include "pixmaps/announce.xpm"
#include "pixmaps/news.xpm"
#include "pixmaps/users.xpm"
#include "pixmaps/files.xpm"
#include "pixmaps/trackers.xpm"
#include "pixmaps/category.xpm"

typedef struct {
  int num;
  char *name;
  char **data;
  GdkPixmap *image;
  GdkBitmap *mask;
} Image;

struct {
  int id;
  char *name;
  char *gnome_fallback;
} hotline_stock_pixmaps[]={
  {200,HL_STOCK_PIXMAP_USERS,GNOME_STOCK_PIXMAP_NEW},
  {205,HL_STOCK_PIXMAP_REFRESH,GNOME_STOCK_PIXMAP_REFRESH},
  {210,HL_STOCK_PIXMAP_DOWNLOAD,GNOME_STOCK_PIXMAP_DOWN},
  {211,HL_STOCK_PIXMAP_UPLOAD,GNOME_STOCK_PIXMAP_UP},
  {212,HL_STOCK_PIXMAP_DELETE,GNOME_STOCK_PIXMAP_CLOSE},
  {212,HL_STOCK_PIXMAP_TRASH,GNOME_STOCK_PIXMAP_TRASH},
  {215,HL_STOCK_PIXMAP_INFO,GNOME_STOCK_PIXMAP_INDEX},
  {213,HL_STOCK_PIXMAP_CANCEL_ALL,GNOME_STOCK_PIXMAP_STOP},

  {218,HL_STOCK_PIXMAP_NEWS_PARENT,GNOME_STOCK_PIXMAP_BACK},
  {219,HL_STOCK_PIXMAP_NEWS_CHILD,GNOME_STOCK_PIXMAP_FORWARD},
  {220,HL_STOCK_PIXMAP_REPLY,GNOME_STOCK_PIXMAP_MAIL_RPL},
  {222,HL_STOCK_PIXMAP_NEWS_POST,GNOME_STOCK_PIXMAP_MAIL_NEW},
  {224,HL_STOCK_PIXMAP_NEWS_PREV,GNOME_STOCK_PIXMAP_UP},
  {225,HL_STOCK_PIXMAP_NEWS_NEXT,GNOME_STOCK_PIXMAP_DOWN},

  {235,HL_STOCK_PIXMAP_FILES,GNOME_STOCK_PIXMAP_OPEN},
  {238,HL_STOCK_PIXMAP_CHAT,GNOME_STOCK_PIXMAP_MAIL_NEW},
  {238,HL_STOCK_PIXMAP_BROADCAST,GNOME_STOCK_PIXMAP_MAIL_NEW},
  {401,HL_STOCK_PIXMAP_BOOKMARK_FOLDER,GNOME_STOCK_PIXMAP_OPEN},
  {408,HL_STOCK_PIXMAP_NEW_BOOKMARK,GNOME_STOCK_PIXMAP_NEW},
  {277,HL_STOCK_PIXMAP_BOOKMARKS,GNOME_STOCK_PIXMAP_BOOK_OPEN},
  {217,HL_STOCK_PIXMAP_PROP_BOOKMARK,GNOME_STOCK_PIXMAP_BOOK_OPEN},
  {411,HL_STOCK_PIXMAP_CONNECT,GNOME_STOCK_PIXMAP_JUMP_TO},
  {415,HL_STOCK_PIXMAP_PRIVCHAT,GNOME_STOCK_PIXMAP_JUMP_TO},
  {413,HL_STOCK_PIXMAP_NEWS,GNOME_STOCK_PIXMAP_NEW},
  {420,HL_STOCK_PIXMAP_TRACKERS,GNOME_STOCK_PIXMAP_INDEX},
  
  {213,HL_STOCK_PIXMAP_CLOSE_PAGE,GNOME_STOCK_PIXMAP_EXIT},

  {230,HL_STOCK_PIXMAP_FILES_PARENT,GNOME_STOCK_PIXMAP_UNDO},
  {217,HL_STOCK_PIXMAP_FILE_INFO,GNOME_STOCK_PIXMAP_INDEX},
  {401,HL_STOCK_PIXMAP_FOLDER_NEW,GNOME_STOCK_PIXMAP_OPEN},

  {405,HL_STOCK_PIXMAP_AGREEMENT,GNOME_STOCK_PIXMAP_NEW},

  {220,HL_STOCK_PIXMAP_USERS_SENDMESG,GNOME_STOCK_PIXMAP_MAIL},
  {215,HL_STOCK_PIXMAP_USERS_INFO,GNOME_STOCK_PIXMAP_INDEX},
  {412,HL_STOCK_PIXMAP_USERS_KICK,GNOME_STOCK_PIXMAP_STOP},
  /*  {,HL_STOCK_,GNOME_STOCK_}, */
  {0,NULL,NULL}
};

static char *stipple_xpm[]={
  "16 16 2 1",
  "   s None c None",
  " X c #ffffff",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
  " X X X X X X X X",
  "X X X X X X X X ",
};

Image images[]={
  {421,"folder_green",folder_green,NULL,NULL},
  {401,"folder_blue",folder_blue,NULL,NULL},
  {404,"file",file_normal,NULL,NULL},
  {402,"file_red",file_red,NULL,NULL},
  {200,"users",users_xpm,NULL,NULL},
  {236,"news",news_xpm,NULL,NULL},
  {238,"pubchat",pubchat_xpm,NULL,NULL},
  {239,"announce",announce_xpm,NULL,NULL},
  {231,"category",category_xpm,NULL,NULL},
  {235,"files",files_xpm,NULL,NULL},
  {-1,"stipple",stipple_xpm,NULL,NULL},
  {-1,NULL,NULL,NULL,NULL}
};

void pixmap_init(){
  int j,k;
  GnomeStockPixmapEntryImlibScaled *sp;
  GdkImlibImage *image;
  char buf[128],buf2[128];
  static char *prefix[]={"",HL_MENU};

  for(k=0;k<2;k++){
    for(j=0;hotline_stock_pixmaps[j].name!=NULL;j++){
      sprintf(buf,"%s%s",prefix[k],hotline_stock_pixmaps[j].name);
      if(gnome_stock_pixmap_checkfor(buf,NULL))
	continue;
      if(use_hotline_icons==FALSE ||
	 (image=get_image_icon(hotline_stock_pixmaps[j].id,24,24,
			     !gnome_preferences_get_toolbar_labels()))==NULL){
	sprintf(buf2,"%s%s",prefix[k],hotline_stock_pixmaps[j].gnome_fallback);
	gnome_stock_pixmap_register(buf,NULL,gnome_stock_pixmap_checkfor(buf2,NULL));
      } else {
	/* FIXME: leaks? you bet!*/
	sp=malloc(sizeof(GnomeStockPixmapEntryImlibScaled));
	sp->label=strdup(buf);
	sp->width=image->rgb_width;
	sp->height=image->rgb_height;
	sp->rgb_data=image->rgb_data;
	sp->shape=image->shape_color;
	if(k==0){
	  sp->type=GNOME_STOCK_PIXMAP_TYPE_IMLIB;
	} else {
	  sp->type=GNOME_STOCK_PIXMAP_TYPE_IMLIB_SCALED;
	  sp->scaled_width=16;
	  sp->scaled_height=16;
	}
	gnome_stock_pixmap_register(buf,NULL,
				    (GnomeStockPixmapEntry *)sp);
      }
    }
  }
}

void pixmap_get(char *name,GdkPixmap **pix,GdkBitmap **mask){
  Image *i;
  
  for(i=images;i->data!=NULL;i++){
    if(strcmp(name,i->name)==0){
      if(i->image==NULL){
	GdkWindow *w=(GTK_WIDGET(main_app)->window);
	if(i->num!=-1)
	  get_image_of_icon(i->num,&i->image,&i->mask);
	if(i->image==NULL && i->data!=NULL)
	  i->image=gdk_pixmap_create_from_xpm_d(w,&i->mask,NULL,i->data);
	if(i->image!=NULL)
	  gdk_pixmap_ref(i->image);
	if(i->mask!=NULL)
	  gdk_bitmap_ref(i->mask);
      }
      if(pix!=NULL)
	*pix=i->image;
      if(mask!=NULL)
	*mask=i->mask;
      return;
    }
  }
  if(pix!=NULL)
    *pix=NULL;
  if(mask!=NULL)
    *mask=NULL;
}
