#include "CPacket.h"


CRefPtr <const CPacket> CPacket::scanPacket(const unsigned char* buffer)
{
	CPacket* p = new CPacket;
	
	p->packet_id = ((unsigned long)buffer[0]<<24)+((unsigned long)buffer[1]<<16)+((unsigned long)buffer[2]<<8)+(unsigned long)buffer[3];
	p->arrived = ((unsigned long)buffer[4]<<24)+((unsigned long)buffer[5]<<16)+((unsigned long)buffer[6]<<8)+(unsigned long)buffer[7];
	p->len = ((unsigned short int)buffer[8]<<8)+(unsigned short int)buffer[9];
	p->ip_src = ((unsigned long)buffer[10]<<24)+((unsigned long)buffer[11]<<16)+((unsigned long)buffer[12]<<8)+((unsigned long)buffer[13]);
	p->ip_dst = ((unsigned long)buffer[14]<<24)+((unsigned long)buffer[15]<<16)+((unsigned long)buffer[16]<<8)+((unsigned long)buffer[17]);
	
	p->protocol = buffer[18];
	
	p->port_src = ((unsigned short int)buffer[19]<<8)+(unsigned short int)buffer[20];
	p->port_dst = ((unsigned short int)buffer[21]<<8)+buffer[22];
	
	p->tcp_flags = ((unsigned short int)buffer[23]<<8)+(unsigned short int)buffer[24];
	p->icmp_type = buffer[25];
	
	p->hook = buffer[26];
	
	p->mac_addrlen = buffer[27];
	memcpy(p->mac_addr, (char*)buffer+28, 8);
	
	memcpy(p->interface_in, (char*)buffer+36, IFNAMSIZ);
	memcpy(p->interface_out, (char*)buffer+36+IFNAMSIZ, IFNAMSIZ);
	
	if (buffer[36+2*IFNAMSIZ] > 0)
		p->programname = (char*) buffer+36+2*IFNAMSIZ+1;
	else
		//p->programname.clear();
		p->programname = "";

	return p;
}
