/*---[ savelog.c ]----------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Functions for saving the contents of the hit log to a disk file
 *--------------------------------------------------------------------*/

#include "savelog.h"
#include "firestarter.h"
#include "globals.h"
#include "hitview.h"
#include "util.h"

static void
write_hit (gpointer data, gpointer userdata)
{
	Hit *h;
	FILE *f = (FILE *)userdata;

	h = (Hit *)data;
	if (h != NULL)
		fprintf (f, "time:%s in:%s out:%s port:%s source:%s dest:%s len:%s tos:%s protocol:%s service:%s\n",
			 h->time,
			 h->in,
			 h->out,
			 h->port,
			 h->source,
			 h->destination,
			 h->length,
			 h->tos,
			 h->protocol,
			 h->service);

	free_hit (h);
}

/* [ savelog_to_disk ]
 * Saves the log to a disk file
 */
static void
savelog_to_disk (GtkWidget *widget, GtkFileSelection *filesel)
{
	FILE *f;
	const gchar *savefile;
	GList *hits;

	savefile = gtk_file_selection_get_filename (filesel);

	if ((f = fopen (savefile, "w")) == NULL) {
		printf ("Error writing log file");
		return;
	}

	hits = hitview_get_all_hits ();
	g_list_foreach (hits, write_hit, f);

	g_list_free (hits);
	fclose (f);
}

/* [ create_savelog_filesel ]
 * Creates a file selection dialog, passed to savelog
 */
void
create_savelog_filesel (void)
{
	GtkWidget *filesel;

	filesel = gtk_file_selection_new (_("Select file to save log to"));

	g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
			  "clicked", G_CALLBACK (savelog_to_disk),
			  (gpointer) filesel);

	g_signal_connect_object (G_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
				 "clicked", G_CALLBACK (gtk_widget_destroy),
				 (gpointer) filesel, G_CONNECT_SWAPPED);

	g_signal_connect_object (G_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button),
				 "clicked", G_CALLBACK (gtk_widget_destroy),
				 (gpointer) filesel, G_CONNECT_SWAPPED);

	gtk_widget_show (filesel);
}
