/*---[ util.h ]-------------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Miscellaneous utility functions
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_UTIL
#define _FIRESTARTER_UTIL

#include <config.h>
#include <gnome.h>

#include "firestarter.h"

void error_dialog (gchar *message);
gboolean detect_netfilter (void);
const gchar *get_system_log_path (void);
gchar *get_file_path (gint rulegroupnum);
void print_hit (Hit *h);
void print_rule (Rule *r);
Hit *copy_hit (Hit *h);
gboolean hit_is_for_me (Hit *h);
gboolean compare_to_last_hit (Hit *h);
GList* create_devicelist (void);
gboolean is_capable_of_nat (void);
gchar *get_text_between (const gchar *string, gchar *marker1, gchar *marker2);
gchar *lookup_ip (gchar *ip);
gboolean is_a_valid_port (const gchar *port);
gboolean is_a_valid_host (const gchar *host);
void free_hit (Hit *h);
#endif
