#include "fische.h"

int parse_options ( int count, char** args ) {

	int c;
	
	static struct option long_options[] = {
		{"geometry", 1, 0, 'g'},
		{0, 0, 0, 0}
	};

	while ( 1 ) {
		
		int option_index = 0;
		
		c = getopt_long ( count, args, "g:", long_options, &option_index );
		
		if ( c == -1 ) break;
		
		switch ( c ) {
			case 'g':
				if ( ! strstr ( optarg, "x" ) ) {
					printf ( "EE parse_options: %s is no valid geometry string\n", optarg );
					return ( 0 );
				}
				sscanf ( optarg, "%dx%d", &XRes, &YRes );
				if ( ( XRes % 16 ) != 0 ) {
					printf ( "EE parse_options: X has to be a multiple of 16\n" );
					return ( 0 );
				}
				break;
			case '?':
				return ( 0 );
			default:
				break;
		}
	}
	return ( 1 );
}
