/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <getopt.h>
#include <unistd.h>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <cstdio>
#include "configuration.h"

using namespace std;

Configuration::Configuration(int count, char** args)
{
	alsa_device = (const char*)malloc(64);
	strcpy((char*)alsa_device, "default");
	vecX = 0;
	vecY = 0;
	virtX = 0;
	virtY = 0;
	fs = false;
	fps = 30;
	MT = true;
	
	static struct option long_options[] = {
		{"geometry", required_argument, 0, 'g'},
		{"virtual", required_argument, 0, 'v'},
		{"device", required_argument, 0, 'd'},
		{"fullscreen", no_argument, 0, 'f'},
		{"fps", required_argument, 0, 's'},
		{"single", no_argument, 0, '1'},
		{"help", no_argument, 0, 'h'},
		{0, 0, 0, 0}
	};

	int option_index = 0;
	int c;
	while((c = getopt_long(count, args, "g:v:d:fs:1h", long_options, &option_index)) != -1)
	{
		switch(c)
		{
			case 'g':
				if(!strstr(optarg, "x"))
				{
					cerr << "ERROR: %s is no valid geometry string" << endl;
					help();		
				}
				sscanf(optarg, "%dx%d", &vecX, &vecY);
				if((vecX < 16) || (vecX > 4096) || (vecY < 16) || (vecY > 4096))
				{
					cerr <<	"ERROR: goemetry string invalid" << endl;
					help();
				}
				cout << "* using custom animation geometry " << vecX << " by " << vecY << endl;
				break;
			case 'v':
				if(!strstr(optarg, "x"))
				{
					cerr << "ERROR: %s is no valid virtual geometry string" << endl;
					help();		
				}
				sscanf(optarg, "%dx%d", &virtX, &virtY);
				if((virtX < 16) || (virtX > 4096) || (virtY < 16) || (virtY > 4096))
				{
					cerr <<	"ERROR: virtual goemetry string invalid" << endl;
					help();
				}
				if((virtX < vecX) || (virtY < vecY))
				{
					cerr << "ERROR: virtual cannot be smaller than actual geometry" << endl;
					help();
				}
				cout << "* using custom virtual geometry " << virtX << " by " << virtY << endl;
				break;
			case 'd':
				strncpy((char*)alsa_device, optarg, 64);
				cout << "* using custom capture device: \"" << alsa_device << "\"" << endl;
				break;
			case 'f':
				fs = true;
				break;
			case 's':
				sscanf(optarg, "%d", &fps);
				cout << "* using custom target fps = " << fps << endl;
				break;
			case '1':
				MT = false;
				cout << "* using single-threaded algorithms on user request" << endl;
				break;
			case 'h':
			case '?':
				help();
			default:
				break;
		}
	}
	if(!vecX) vecX = 800;
	if(!vecY) vecY = 400;
	if(!virtX) virtX = vecX;
	if(!virtY) virtY = vecY;
}

Configuration::~Configuration()
{
}

int Configuration::fpsTarget()
{
	return fps;
}

const char* Configuration::device()
{
	return alsa_device;
}

int Configuration::X()
{
	return vecX;
}

int Configuration::Y()
{
	return vecY;
}

int Configuration::screenX()
{
	return virtX;
}

int Configuration::screenY()
{
	return virtY;
}

bool Configuration::fullscreen()
{
	return fs;
}

bool Configuration::multiThreaded()
{
	return MT;
}

void Configuration::help()
{
	cout << endl;
	cout << "Usage: fische [-d (device)] [-g (X)x(Y)] [-v (X)x(Y)] [-f] [-s (fps)] [-1] [-h]" << endl;
	cout << endl;
	cout << "Details:" << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-d --device (device)        (device) names the alsa pcm capture device to get" << endl;
	cout << "                            the sound data from. On most systems, the default" << endl;
	cout << "                            will do just fine." << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-g --geometry (X)x(Y)       (X) and (Y) specify the width and height of the" << endl;
	cout << "                            animation. default: 800x400" << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-v --virtual (X)x(Y)        (X) and (Y) specify the width and height of the" << endl;
	cout << "                            application window. Use this to prevent your" << endl;
	cout << "                            computer from trying to switch to non-existent" << endl;
	cout << "                            fullscreen resolutions." << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-f --fullscreen             Start up in fullscreen mode. At runtime, you can" << endl;
	cout << "                            toggle fullscreen mode by pressing 'F'." << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-s --fps (fps)              (fps) specifies the target frames per second." << endl;
	cout << "                            The default, 30, is what fische is designed for" << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-1 --single                 Use only one CPU, even if there are more available" << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	cout << "-h --help                   This message." << endl;
	cout << "--------------------------------------------------------------------------------" << endl;
	exit(EXIT_FAILURE);
}
