/*
 * Simple flexible configuration file handling
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _TH_CONFIG_H
#define _TH_CONFIG_H

#include "th_util.h"

/*
 * Type definations
 */
enum ITEM_TYPE {
	ITEM_STRING = 1,
	ITEM_INT,
	ITEM_BOOL
};

typedef struct tconfignode {
	char	*itemName;	/* Config item name */
	int	itemType;	/* Type of the item */
	void	*itemData;	/* Dynamically allocated contents / value */

	struct tconfignode *pNext, *pPrev;
} t_config_item;


typedef struct {
	t_config_item	*pItems;
} t_config;


/*
 * Functions
 */
int	th_config_read(char *, t_config **);
/*int	th_config_save(char *, t_config *);*/
void	th_config_free(t_config *);

int	th_config_get_int(t_config *, char *, int);
char 	*th_config_get_str(t_config *, char *, char *);
BOOL	th_config_get_bool(t_config *, char *, BOOL);

#endif /* _TH_CONFIG_H */
