// This file is part of fityk program. Copyright (C) 2005 Marcin Wojdyr
// Licence: GNU General Public License ver. 2+
// $Id: cmd.h 596 2009-11-25 15:09:56Z wojdyr $

#ifndef FITYK_CMD__H__
#define FITYK_CMD__H__


#include "common.h"
#include "ui.h"

/// return true if the syntax is correct
bool check_command_syntax(std::string const& str);

/// parse and execute command; does not throw exceptions, returns status
Commands::Status parse_and_execute(std::string const& str);

/// like parse_and_execute(), but returns false on syntax error, throw exception on execute error
bool parse_and_execute_e(std::string const& str);

#endif
