
/* wordwrap.h
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef wordwrap_h_INCLUDED
#define wordwrap_h_INCLUDED

#include "types.h"


struct wordwrap_target
{
  void (*wrapped_text_output_destination)(z_ucs *output,
      /*@null@*/ void *parameter);
  void (*padding_starts)(void *destination_parameter);
  void (*padding_ends)(void *destination_parameter);
};


struct wordwrap_metadata
{
  /*@dependent@*/ z_ucs *output_index;
  void (*metadata_output_function)(void *ptr_parameter, uint32_t int_parameter);
  /*@temp@*/ void *ptr_parameter;
  uint32_t int_parameter;
};


typedef struct
{
  int line_length;
  void (*wrapped_text_output_destination)(z_ucs *output,
      /*@null@*/ void *parameter);
  void (*padding_starts)();
  void (*padding_ends)();
  /*@temp@*/ /*@null@*/ void *destination_parameter;
  int line_index;
  /*@owned@*/ z_ucs *output_buffer;
  /*@owned@*/ z_ucs *padding_buffer;
  /*@dependent@*/ z_ucs *output_buffer_index;
  size_t output_buffer_size;
  bool add_newline_after_full_line;
  int left_side_padding;
  /*@only@*/ /*@null@*/ struct wordwrap_metadata *metadata;
  int metadata_size;
  int metadata_index;
  bool newline_was_inserted;
  bool last_line_was_completely_filled;
  //bool has_received_any_output;
} WORDWRAP;


WORDWRAP *wordwrap_new_wrapper(
    size_t line_length,
    struct wordwrap_target *target,
    //void (*wrapped_text_output_destination)(z_ucs *output,
    //  /*@null@*/ void *parameter),
    /*@null@*/ void *destination_parameter,
    bool add_newline_after_full_line, int left_side_padding);
void wordwrap_destroy_wrapper(
    /*@only@*/ WORDWRAP *wrapper_to_destroy);
void wordwrap_wrap_z_ucs(
    WORDWRAP *wrapper, z_ucs *input);
void wordwrap_flush_output(
    WORDWRAP *wrapper);
void wordwrap_insert_metadata(
    WORDWRAP *wrapper,
    void (*metadata_output)(void *ptr_parameter, uint32_t int_parameter),
    void *ptr_parameter,
    uint32_t int_parameter);
void wordwrap_set_line_index(
    WORDWRAP *wrapper, int new_line_index);
void wordwrap_output_left_padding(WORDWRAP *wrapper);

// Used by screen interface:
/*@-exportlocal@*/
void wordwrap_adjust_line_length(
    WORDWRAP *wrapper, size_t new_line_length);
/*@+exportlocal@*/

#endif /* wordwrap_h_INCLUDED */

