
/* z_ucs_i.c
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <stdlib.h>

#include "z_ucs_i.h"
#include "config.h"
#include "z_ucs.h"
#include "fizmo.h"
#include "i18n.h"
#include "splint.h"


char *z_ucs_to_system_charset(z_ucs *string)
{
  char *result;
  size_t bytes_required;
  z_ucs *ptr;
  char *dest;

  if (system_charset == SYSTEM_CHARSET_ASCII)
  {
    result = (char*)fizmo_malloc(z_ucs_len(string) + 1);

    dest = result;

    while (*string != 0)
    {
      if ((*string & 0xffffff80) != 0)
        *dest = '_';
      else
        *dest = (char)(*string & 0x7f);

      string++;
      dest++;
    }
    *dest = '\0';
    return result;
  }
  else if (system_charset == SYSTEM_CHARSET_ISO_8859_1)
  {
    result = (char*)fizmo_malloc(z_ucs_len(string) + 1);

    dest = result;

    while (*string != 0)
    {
      if ((*string & 0xffffff00) != 0)
        *dest = '_';
      else
        *dest = (char)(*string & 0xff);

      string++;
      dest++;
    }
    *dest = '\0';
    return result;
  }
  else if (system_charset == SYSTEM_CHARSET_UTF_8)
  {
    ptr = string;
    bytes_required = (size_t)z_ucs_to_utf_8(NULL, &ptr, 0);
    result = (char*)fizmo_malloc(bytes_required);

    ptr = string;
    (void)z_ucs_to_utf_8(result, &ptr, bytes_required);
    return result;
  }

  return NULL;
}

