// This code is heavily inspired by Chris Pederick (useragentswitcher) install.js
// Contributors: Philip Chee, deathburger
//
// Philip Chee: Added installation of prefs, components, and locales.
// deathburger: Refactored to move all changable items to the top of the file.

// Editable Items Begin
var displayName         = "Flashblock"; // The name displayed to the user (don't include the version)
var version             = "1.3.5";
var name                = "flashblock"; // The leafname of the JAR file (without the .jar part)

// The following three sets of variables tell this installer script how your
// extension directory structure looks.
// If your jar file contains content/packagename use the second packageDir
// variable. Same rule applies for skinDir and localeDir. I set them up
// independent of each other just in case an extension layout is wacky.
//var packageDir           = "/"
var packageDir           = "/" + name + "/"
//var skinDir           = "/"
var skinDir           = "/" + name + "/"
//var localeDir           = "/"
var localeDir           = "/" + name + "/"

var locales             = new Array( "en-US", "it-IT", "nl-NL", "de-DE",
"fr-FR", "pl-PL", "ko-KR", "pt-BR", "da-DK", "hu-HU", "cs-CZ", "es-ES",
"ru-RU", "ro-RO", "de-AT", "ja-JP", "zh-CN", "ar-YE", "ar-JO", "fi-FI",
"sv-SE", "sk-SK", "zh-TW", "tr-TR" );
var skins               = new Array( "classic" ); // "modern"
var prefs               = new Array( "flashblock.js" );
var components          = new Array(  );
var searchPlugins       = new Array(  );

// Mozilla Suite/Seamonkey stores all pref files in a single directory
// under the application directory.  If the name of the preference file(s)
// is/are not unique enough, you may override other extension preferences.
// set this to true if you need to prevent this.
var disambiguatePrefs   = false;

// Editable Items End

var jarName             = name + ".jar";
var jarFolder           = "content" + packageDir
var error               = null;

var folder              = getFolder("Profile", "chrome");
var prefFolder          = getFolder(getFolder("Program", "defaults"), "pref");
var compFolder          = getFolder("Components");
var searchFolder        = getFolder("Plugins");

var existsInApplication = File.exists(getFolder(getFolder("chrome"), jarName));
var existsInProfile     = File.exists(getFolder(folder, jarName));

var contentFlag         = CONTENT | PROFILE_CHROME;
var localeFlag          = LOCALE | PROFILE_CHROME;
var skinFlag            = SKIN | PROFILE_CHROME;

var APP_PLATFORM        = "";
var gPlatform           = getPlatform();

// If the extension exists in the application folder or it doesn't exist
// in the profile folder and the user doesn't want it installed to the
// profile folder
if(existsInApplication ||
    (!existsInProfile &&
      !confirm( "Do you want to install the " + displayName +
                " extension into your profile folder?\n" +
                "(Cancel will install into the application folder)")))
{
    contentFlag = CONTENT | DELAYED_CHROME;
    folder      = getFolder("chrome");
    localeFlag  = LOCALE | DELAYED_CHROME;
    skinFlag    = SKIN | DELAYED_CHROME;
}

initInstall(displayName, name, version);
setPackageFolder(folder);
error = addFile(name, version, "chrome/" + jarName, folder, null);

// If adding the JAR file succeeded
if(error == SUCCESS)
{
    folder = getFolder(folder, jarName);

    registerChrome(contentFlag, folder, jarFolder);
    for (var i = 0; i < locales.length; i++) {
        registerChrome(localeFlag, folder, "locale/" + locales[i] + localeDir);
    }

    for (var i = 0; i < skins.length; i++) {
        registerChrome(skinFlag, folder, "skin/" + skins[i] + skinDir);
    }

    for (var i = 0; i < prefs.length; i++) {
        if (!disambiguatePrefs) {
            addFile(name + " Defaults", version, "defaults/preferences/" + prefs[i],
                prefFolder, prefs[i], true);
        } else {
            addFile(name + " Defaults", version, "defaults/preferences/" + prefs[i],
                prefFolder, name + "-" + prefs[i], true);
        }
    }

    for (var i = 0; i < components.length; i++) {
        addFile(name + " Components", version, "components/" + components[i],
            compFolder, components[i], true);
    }

    for (var i = 0; i < searchPlugins.length; i++) {
        addFile(name + " searchPlugins", version, "searchplugins/" + searchPlugins[i],
            searchFolder, searchPlugins[i], true);
    }

    error = performInstall();

    // If the install failed
    if(error != SUCCESS && error != REBOOT_NEEDED)
    {
        displayError(error);
    	cancelInstall(error);
    }
    else
    {
    msg = displayName + " " + version + " has been succesfully installed.\n"
          + "Flash objects will now be replaced with a button that you can click on to view them.\n\n"
          + "Please restart your browser to enable " + displayName + ".";
        alert(msg);
    }
}
else
{
    displayError(error);
	cancelInstall(error);
}

// Displays the error message to the user
function displayError(error)
{
    // If the error code was -215
    if(error == READ_ONLY)
    {
        alert("The installation of " + displayName +
            " failed.\nOne of the files being overwritten is read-only.");
    }
    // If the error code was -235
    else if(error == INSUFFICIENT_DISK_SPACE)
    {
        alert("The installation of " + displayName +
            " failed.\nThere is insufficient disk space.");
    }
    // If the error code was -239
    else if(error == CHROME_REGISTRY_ERROR)
    {
        alert("The installation of " + displayName +
            " failed.\nChrome registration failed.");
    }
    else
    {
        alert("The installation of " + displayName +
            " failed.\nThe error code is: " + error);
    }
}

function getPlatform() {
	var platformStr, platformNode;

	if ('platform' in Install) {
		platformStr = new String(Install.platform);
		APP_PLATFORM = platformStr;
		// Mac OS X (aka Darwin) is a real unix system
		if (!platformStr.search(/.*Darwin/))
			platformNode = 'unix';
		else if (!platformStr.search(/^Macintosh/))
			platformNode = 'mac';
		else if (!platformStr.search(/^Win/))
			platformNode = 'win';
		else if (!platformStr.search(/^OS\/2/))
			platformNode = 'win';
		else if (!platformStr.search(/unix|sun|linux/i))
			platformNode = 'unix';
		else if (getFolder("Unix Lib") != null)
			platformNode = 'unix';
		else
			platformNode = 'unknown';
	}
	else
	{
		if (getFolder("Unix Lib") != null)
			platformNode = 'unix';
		else if (getFolder("Mac System")!= null)
			platformNode = 'mac';
		else if(getFolder("Win System")!= null)
			platformNode = 'win';
		else
			platformNode = 'unknown';
	}
	return platformNode;
}
