//
// "$Id: Fl_Print_Dialog.H 432 2006-11-26 21:45:08Z mike $"
//
// flPhoto print dialog.
//
// Copyright 2002-2006 by Michael Sweet.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

// generated by Fast Light User Interface Designer (fluid) version 1.0108

#ifndef Fl_Print_Dialog_H
#define Fl_Print_Dialog_H
#include <FL/Fl.H>
#include "Fl_Image_Browser.H"
#include "flstring.h"
#include "SpringWindow.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Check_Button.H>
#include "MenuTabs.h"
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Box.H>
#include "SmartGroup.h"
#include <FL/Fl_Progress.H>
#include <FL/Fl_Double_Window.H>
#include <errno.h>
#include <FL/Fl_Browser.H>
#include <time.h>

class Fl_Print_Dialog {
  const char *(*callback_)(Fl_Print_Dialog *pd, void *); 
  void *calldata_; 
  Fl_Image_Browser *image_browser_; 
  char mat_colors_[16][8]; 
  Fl_RGB_Image *mat_preview_image_; 
  void *ppd_; 
  char progress_label_[1024]; 
  const char *title_; 
  void date_update_cb();
  void load_prefs(); 
  void load_printers(); 
  void mat_color_cb(Fl_Widget *w); 
  void mat_type_cb(); 
  void media_cb(); 
  static void ppd_cb(Fl_Widget *w, void *d); 
  void print_cb(); 
  void printer_cb(); 
  void save_prefs(); 
public:
  enum { CALENDAR_AUTO = -1, CALENDAR_LEFT, CALENDAR_TOP }; 
  enum { CALENDAR_PAGE = 0, CALENDAR_FOLDED_FRONT_PAGES, CALENDAR_FOLDED_BACK_PAGES, CALENDAR_FOLDED_ALL_PAGES, CALENDAR_BOUND_FRONT_PAGES, CALENDAR_BOUND_BACK_PAGES, CALENDAR_BOUND_ALL_PAGES }; 
  enum { MAT_BLANK, MAT_PLAIN, MAT_STANDARD, MAT_VELVET }; 
  enum { MODE_GRAYSCALE, MODE_COLOR }; 
  enum { PRINT_CURRENT, PRINT_SELECTED, PRINT_ALL }; 
  enum { PRINT_INDEX, PRINT_1UP, PRINT_2UP, PRINT_4UP, PRINT_PORTRAIT, PRINT_CALENDAR, PRINT_MATTED }; 
  enum { QUALITY_DRAFT, QUALITY_NORMAL, QUALITY_BEST }; 
  Fl_Print_Dialog();
private:
  SpringWindow *window_;
  Fl_Group *control_group_;
  Fl_Choice *printer_chooser_;
  void cb_printer_chooser__i(Fl_Choice*, void*);
  static void cb_printer_chooser_(Fl_Choice*, void*);
  Fl_Check_Button *print_to_file_button_;
  MenuTabs *tabs_;
  SmartGroup *general_tab_;
  Fl_Round_Button *print_current_button_;
  void cb_print_current_button__i(Fl_Round_Button*, void*);
  static void cb_print_current_button_(Fl_Round_Button*, void*);
  Fl_Round_Button *print_selected_button_;
  void cb_print_selected_button__i(Fl_Round_Button*, void*);
  static void cb_print_selected_button_(Fl_Round_Button*, void*);
  Fl_Round_Button *print_all_button_;
  void cb_print_all_button__i(Fl_Round_Button*, void*);
  static void cb_print_all_button_(Fl_Round_Button*, void*);
  Fl_Button *print_index_button_;
  void cb_print_index_button__i(Fl_Button*, void*);
  static void cb_print_index_button_(Fl_Button*, void*);
  Fl_Button *print_1up_button_;
  void cb_print_1up_button__i(Fl_Button*, void*);
  static void cb_print_1up_button_(Fl_Button*, void*);
  Fl_Button *print_2up_button_;
  void cb_print_2up_button__i(Fl_Button*, void*);
  static void cb_print_2up_button_(Fl_Button*, void*);
  Fl_Button *print_4up_button_;
  void cb_print_4up_button__i(Fl_Button*, void*);
  static void cb_print_4up_button_(Fl_Button*, void*);
  Fl_Button *print_portrait_button_;
  void cb_print_portrait_button__i(Fl_Button*, void*);
  static void cb_print_portrait_button_(Fl_Button*, void*);
  Fl_Button *print_calendar_button_;
  void cb_print_calendar_button__i(Fl_Button*, void*);
  static void cb_print_calendar_button_(Fl_Button*, void*);
  Fl_Button *print_matted_button_;
  void cb_print_matted_button__i(Fl_Button*, void*);
  static void cb_print_matted_button_(Fl_Button*, void*);
  Fl_Spinner *copies_value_;
  Fl_Choice *quality_chooser_;
  static Fl_Menu_Item menu_quality_chooser_[];
  Fl_Choice *mode_chooser_;
  static Fl_Menu_Item menu_mode_chooser_[];
  Fl_Group *printer_tab_;
  Fl_Choice *media_chooser_;
  void cb_media_chooser__i(Fl_Choice*, void*);
  static void cb_media_chooser_(Fl_Choice*, void*);
  Fl_Group *media_group_;
  Fl_Spinner *media_width_value_;
  Fl_Spinner *media_length_value_;
  Fl_Choice *media_units_;
  static Fl_Menu_Item menu_media_units_[];
  Fl_Scroll *ppd_scroll_;
  SmartGroup *calendar_group_;
  Fl_Choice *calendar_day_chooser_;
  static Fl_Menu_Item menu_calendar_day_chooser_[];
  Fl_Choice *calendar_month_chooser_;
  static Fl_Menu_Item menu_calendar_month_chooser_[];
  Fl_Spinner *calendar_year_value_;
  Fl_Round_Button *calendar_left_button_;
  Fl_Round_Button *calendar_top_button_;
  Fl_Round_Button *calendar_auto_button_;
  Fl_Choice *calendar_type_chooser_;
  static Fl_Menu_Item menu_calendar_type_chooser_[];
  Fl_Input *calendar_file_field_;
  void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
  void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
  Fl_Group *mat_group_;
  Fl_Choice *mat_type_chooser_;
  void cb_mat_type_chooser__i(Fl_Choice*, void*);
  static void cb_mat_type_chooser_(Fl_Choice*, void*);
  static Fl_Menu_Item menu_mat_type_chooser_[];
  Fl_Box *mat_preview_box_;
  Fl_Spinner *mat_width_value_;
  Fl_Choice *mat_width_units_;
  static Fl_Menu_Item menu_mat_width_units_[];
  Fl_Input *mat_color_field_;
  void cb_mat_color_field__i(Fl_Input*, void*);
  static void cb_mat_color_field_(Fl_Input*, void*);
  Fl_Button *mat_color_button_;
  void cb_mat_color_button__i(Fl_Button*, void*);
  static void cb_mat_color_button_(Fl_Button*, void*);
  void cb_mat_color_buttons__i(Fl_Button*, void*);
  static void cb_mat_color_buttons_(Fl_Button*, void*);
  void cb_mat_color_buttons_1_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_1(Fl_Button*, void*);
  void cb_mat_color_buttons_2_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_2(Fl_Button*, void*);
  void cb_mat_color_buttons_3_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_3(Fl_Button*, void*);
  void cb_mat_color_buttons_4_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_4(Fl_Button*, void*);
  void cb_mat_color_buttons_5_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_5(Fl_Button*, void*);
  void cb_mat_color_buttons_6_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_6(Fl_Button*, void*);
  void cb_mat_color_buttons_7_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_7(Fl_Button*, void*);
  void cb_mat_color_buttons_8_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_8(Fl_Button*, void*);
  void cb_mat_color_buttons_9_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_9(Fl_Button*, void*);
  void cb_mat_color_buttons_a_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_a(Fl_Button*, void*);
  void cb_mat_color_buttons_b_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_b(Fl_Button*, void*);
  void cb_mat_color_buttons_c_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_c(Fl_Button*, void*);
  void cb_mat_color_buttons_d_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_d(Fl_Button*, void*);
  void cb_mat_color_buttons_e_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_e(Fl_Button*, void*);
  Fl_Button *mat_color_buttons_[16];
  void cb_mat_color_buttons_f_i(Fl_Button*, void*);
  static void cb_mat_color_buttons_f(Fl_Button*, void*);
  Fl_Group *image_group_;
  Fl_Spinner *image_width_value_;
  Fl_Spinner *image_length_value_;
  Fl_Choice *image_units_;
  static Fl_Menu_Item menu_image_units_[];
  Fl_Spinner *image_cols_value_;
  Fl_Spinner *image_rows_value_;
  Fl_Check_Button *mat_comments_button_;
  void cb_Print_i(Fl_Button*, void*);
  static void cb_Print(Fl_Button*, void*);
  void cb_Cancel_i(Fl_Button*, void*);
  static void cb_Cancel(Fl_Button*, void*);
  Fl_Progress *progress_;
  Fl_Double_Window *date_window_;
  Fl_Browser *date_browser_;
  void cb_date_browser__i(Fl_Browser*, void*);
  static void cb_date_browser_(Fl_Browser*, void*);
  void cb_5plus_i(Fl_Button*, void*);
  static void cb_5plus(Fl_Button*, void*);
  Fl_Button *date_remove_button_;
  void cb_date_remove_button__i(Fl_Button*, void*);
  static void cb_date_remove_button_(Fl_Button*, void*);
  Fl_Group *date_group_;
  Fl_Check_Button *date_repeat_button_;
  void cb_date_repeat_button__i(Fl_Check_Button*, void*);
  static void cb_date_repeat_button_(Fl_Check_Button*, void*);
  Fl_Spinner *date_year_;
  void cb_date_year__i(Fl_Spinner*, void*);
  static void cb_date_year_(Fl_Spinner*, void*);
  Fl_Spinner *date_month_;
  void cb_date_month__i(Fl_Spinner*, void*);
  static void cb_date_month_(Fl_Spinner*, void*);
  Fl_Spinner *date_day_;
  void cb_date_day__i(Fl_Spinner*, void*);
  static void cb_date_day_(Fl_Spinner*, void*);
  Fl_Input *date_comment_;
  void cb_date_comment__i(Fl_Input*, void*);
  static void cb_date_comment_(Fl_Input*, void*);
  void cb_4reload_i(Fl_Button*, void*);
  static void cb_4reload(Fl_Button*, void*);
  void cb_Save_i(Fl_Button*, void*);
  static void cb_Save(Fl_Button*, void*);
  void cb_Cancel1_i(Fl_Button*, void*);
  static void cb_Cancel1(Fl_Button*, void*);
public:
  ~Fl_Print_Dialog();
  void calendar(int &day, int &month, int &year, int &orient, int &bound, char *datefile, int dfsize);
  void callback(const char *(*cb)(Fl_Print_Dialog *pd, void *d), void *d);
  void copies(int c);
  int copies();
  void format(int f); 
  int format(); 
  int have_ppd();
  void hide();
  void imageable_area(int &left, int &bottom, int &right, int &top); 
  void matcolors(Fl_Image_Browser *b); 
  void matimage(uchar *data, int alpha = 0); 
  void matting(int &type, float &width, uchar *rgb, float &image_width, float &image_height, int &image_cols, int &image_rows, int &show_comments); 
  void media(const char *m); 
  const char *media(); 
  void mode(int m);
  int mode();
  void paper_dimension(int &width, int &length); 
  int print_file(const char *f); 
  int print_to_file();
  void printer(const char *p); 
  const char * printer();
  void progress_hide();
  void progress_show(int percent, const char *format, ...); 
  void quality(int q);
  int quality();
  void show();
  int shown();
  void title(const char *t);
  const char * title();
  int visible();
  void which(int w); 
  int which(); 
};
#endif

//
// End of "$Id: Fl_Print_Dialog.H 432 2006-11-26 21:45:08Z mike $".
//
