#!/usr/bin/env python
# -*- coding: utf-8 -*-        
# Copyright (C) Martin v. Löwis 2002

import os, sys
from distutils.core import setup, Extension
from distutils.util import newer, spawn
from distutils.command.build_py import build_py
from distutils.command.install_scripts import install_scripts
from setupext  import Data_Files, install_Data_Files

ext_modules = []

args = sys.argv[:]
for arg in args:
    if arg == '--with-bison':
        sys.argv.remove(arg)
        grammar_c = os.path.join("src","grammar.c")
        grammar_y = os.path.join("src","grammar.y")
        lexer_c = os.path.join("src","lexer.c")
        lexer_l = os.path.join("src","lexer.l")
        if newer(grammar_y, grammar_c):
            spawn(["bison", "-o", grammar_c, "-d", grammar_y], verbose=1)
        if newer(lexer_l, lexer_c):
            spawn(["flex", "-o"+lexer_c, lexer_l], verbose=1)
        src = ['src/bisonmodule.c','src/grammar.c','src/lexer.c']
        ext_modules.append(Extension("bison",
                                     include_dirs=["src"],
                                     define_macros=[('YYDEBUG','1')],
                                     sources=src))

# Install examples and test cases as data 
# XXX dotless names don't work for recursive-include on Windows
docfiles="""
recursive-include examples *.py *.idl 
recursive-include tests *.py *.idl *.cpp *.h Makefile*
include examples/*/README tests/*/README
include CHANGES LICENSE.HTML MANIFEST MANIFEST.in README README.jython
global-exclude */CVS/*
"""

if sys.platform=='win32':
    docdir = 'Fnorb-doc'
else:
    docdir = 'share/doc/Fnorb'

data_files = [
        Data_Files(copy_to = docdir,
                   template = docfiles.split("\n"),
                   preserve_path = 1)
        ]

# Mechanism to add additional modules
class fnorb_build_py(build_py):
    def find_package_modules(self, package, package_dir):
        if package == 'Fnorb.parser':
            self.build_idl_py(package_dir)
            self.copy_yappsrt(package_dir)

        elif package.startswith('Fnorb.cos.naming.CosNaming'):
            self.compile_idl(package_dir, 'CosNaming')

        elif package.startswith('Fnorb.cos.interface_repository.IntRep'):
            self.compile_idl(package_dir, 'IntRep')

        res = build_py.find_package_modules(self, package, package_dir)

        return res

    def build_idl_py(self, dir):
        idl_py = os.path.join(dir, "idl.py")
        idl_g = os.path.join(dir, "idl.g")
        if newer(idl_g, idl_py):
            self.debug_print("Building idl.py")
            yappspath = os.path.join(dir, os.pardir, "src", "yapps")
            sys.path.append(yappspath)
            import yapps2
            yapps2.generate(idl_g, idl_py)
            del sys.path[-1]

    def copy_yappsrt(self, dir):
        yappsrt = os.path.join(dir, os.pardir, "src",
                               "yapps", "yappsrt.py")
        self.copy_file(yappsrt, os.path.join(dir, "yappsrt.py"))

    def compile_idl(self, dir, idl):
        # dir is ./cos/naming/CosNaming at first
        dir = os.path.normpath(os.path.join(dir, os.pardir))
        idlfile = os.path.join(dir, idl+".idl")
        initfile = os.path.join(dir, idl, "__init__.py")
        if newer(idlfile, initfile):
            # Hack "." as Fnorb into sys.modules
            import imp
            sys.modules['Fnorb'] = imp.load_package("Fnorb",".")
            from Fnorb.script.fnidl import main
            main(['fnidl', '--directory='+dir,
                  idlfile])
            if idl == "IntRep":
                self.copy_file(os.path.join(dir,"CORBA","__init__.py"),
                               os.path.join(dir,"IntRep","__init__.py"))
                self.copy_file(os.path.join(dir,"CORBA_skel","__init__.py"),
                               os.path.join(dir,"IntRep_skel","__init__.py"))
                import shutil
                shutil.rmtree(os.path.join(dir,"CORBA"))
                shutil.rmtree(os.path.join(dir,"CORBA_skel"))

# We subclass this only on Windows
fnorb_install_scripts = install_scripts

scripts = ['fnidl', 'fnaming', 'fnfeed', 'fngen', 
           'fnifr', 'fnior', 'fnmkior', 'fnoptions', 'fnping'
          ]

# On Windows, install .bat scripts instead
if sys.platform == "win32":
    script = open("script/fnpostinst.in").read()
    script = script.replace("@FILES@", repr(scripts))
    open("script/fnpostinst", "w").write(script)
    if 'bdist_wininst' in sys.argv:
	if sys.version_info < (2,3):
	    print "bdist_wininst requires Python 2.3 for Fnorb"
	    raise SystemExit
	scripts = ['script/fnpostinst']
    else:
	scripts = []
	class fnorb_install_scripts(install_scripts):
	    def run():
                execfile('script/fnpostinst')
else:
    # Find the scripts to install in the script subdirectory
    s1 = []
    for s in scripts: s1.append('script/%s' % s)
    scripts = s1


setup (name = "Fnorb",
       version = "1.3",
       description = "Fnorb 1.3",
       author = "Fnorb is a CORBA 2.1 ORB",
       author_email = "fnorb@dstc.edu.au",
       url = "http://www.fnorb.org/",
       long_description =
"""Fnorb is a CORBA 2.1 ORB for Python first developed by DSTC.
This project will take the formerly closed Fnorb source-base and turn
it into a pure-python ORB with up-to-date Python mapping and CORBA 2.4
compliance
""",

       # Override command classes
       cmdclass = {'build_py':fnorb_build_py,
                   'install_scripts':fnorb_install_scripts,
                   'install_data':install_Data_Files},

       package_dir = {'Fnorb':'.'},

       packages = ['Fnorb', 'Fnorb.compiler', 'Fnorb.parser',
                   'Fnorb.cos', 'Fnorb.cos.naming',
                   'Fnorb.cos.naming.CosNaming',
                   'Fnorb.cos.naming.CosNaming_skel',
                   'Fnorb.cos.interface_repository',
                   'Fnorb.cos.interface_repository.IntRep',
                   'Fnorb.cos.interface_repository.IntRep_skel',
                   'Fnorb.orb', 'Fnorb.script'
                   ],

       data_files = data_files,

       ext_modules = ext_modules,

       scripts = scripts
       )

