#!/usr/bin/env python

#
# Perform all the data transfer tests.
#

import unittest

import shorttest
import longtest
import chartest
import wchartest
import wstringtest
import seqtest
import fixedtest

from orbrunner import ORBRunner
from serverrunner import ServerRunner

name = "data transfer"

class AllTests:
    def __init__(self):
        self.server_runner = ServerRunner('python DataTransferServer.py')
        self.server_runner.run()
        self.orb_runner = ORBRunner()

    def done(self):
        self.server_runner.halt()

    def get_test_suite(self):
        test_suite = unittest.TestSuite()

        for module in (shorttest, longtest, chartest, wchartest,
                       wstringtest, seqtest, fixedtest):
            new_test_suite = module.build_test_suite(self.orb_runner)
            test_suite.addTest(new_test_suite)

        return test_suite


if __name__ == "__main__":

    tests = AllTests()
    test_runner = unittest.TextTestRunner()
    test_runner.run(tests.get_test_suite())
    tests.done()
