## Module: folder

##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

from basicfontlist import *
import fontybugs
import sys

class Folder ( BasicFontList ):
    """Controller.
    It reps an entire Folder
    Contains a list of pafs to ttf files in a given path.
    Supply the path"""
    def __init__ ( self, path ):
        BasicFontList.__init__ ( self )
        ## Public var
        self.path = os.path.abspath ( path ) # fix relative paths

        ## Fill my tanks!
        for f in os.listdir (  self.path  ):
            if f.upper ( ).endswith ( ".TTF" ):
                #print "f is ", f
                try:
                    fi = FontItem ( os.path.join ( self.path ,f ) , False ) 
                except UnicodeDecodeError, e:
                    sys.exit ( "The file %s has caused a unicode error.\nPlease rename it, removing any strange characters, and try again." % f )
                self.append ( fi ) 
        if len ( self ) == 0:
            raise fontybugs.FolderHasNoFonts ( self.path )
            
    def label ( self ):
        return str ( self.path )
