##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

## Import actually loads AND runs those modules.
import strings
import sys
import fpsys

## PIL : Is it there?
try: import Image, ImageFont, ImageDraw 
except: sys.exit ( strings.PILError ( ) ) 
    
## Process the command line stuff
import cli

## All alternate gui stuff is pie-in-the-sky code
## I have yet to start that battle!
## Right now, it's only wxPython.

## Determine if the gui chosen can be opened
validguis = [ "wxgui", "qtgui" ]

chosengui = fpsys.config.usegui # this was set in cli module (default is wxgui)

## Quick tests - which is there?
## Using imp will find a module very quickly, faster than import x
import imp
try:
    imp.find_module ( "wx" )
    import wxversion
    wxversion.ensureMinimal ( "2.6" )  
except: validguis.remove ( "wxgui" )

try: imp.find_module ( "qt" )
except: validguis.remove ( "qtgui" )

if chosengui in validguis:
    fpsys.config.usegui = chosengui #update config
else:    
    sys.exit ( "Neither wxgui nor qtgui interfaces could be found. Please consult the help.")

## Dynamic import of a named module
## Wild statement - I don't yet grok the need for the fontypython. bit, 
## because here i am, in the fontypython directory ... but hack on!
gui = __import__ ( "fontypython." + chosengui ) 

## End, clean up
fpsys.config.Save ( )
