#!/bin/sh
### install.sh - instalacni skript pro ceske a slovenske fortunes
### -- Zdenek Pytela, 1998.06.08--2000.12.15
###
### Instalace:
### V adresari FORTUNESDIR se vytvori podadresar cs a pripadne cs-KODOVANI
###  podle verze kodovani, zdrojove texty jsou kodovany v ISO 8859-2.
### Ceske fortunes se spousti "fortune cs",
###  eventualne "fortune cs-KODOVANI", napr. fortune cs-ascii.
### Pripominky, opravy chyb a nove prispevky vlastni i nalezene muzete
###  posilat na adresu <letty@mrakoplas.phil.muni.cz>.
VERZE="1.6.4"

### Prefix nastavte, pokud chcete vytvorit strom jinam
###  nez do sve adresarove struktury
PREFIX=${PREFIX-""}

### Ze zdroju vyradte ty, ktere se vam nelibi
ZDROJECZ1="zemeplocha mladik pocitace skala prislovi"
ZDROJECZ2="stopar parafraze jerome wodehouse lodge mikulas rdvcitaty"
ZDROJECZ3="cimrman ignac parkinson murphy josef guth"
ZDROJECZ4="citat klasik-cz market citace stoa1 plihal vodnansky"
ZDROJESK="klasik-sk"
ZDROJE=${ZDROJE-"$ZDROJECZ1 $ZDROJECZ2 $ZDROJECZ3 $ZDROJECZ4 $ZDROJESK"}

### Dokumentace
DOC="README BIBLIOGRAFIE INFO LICENSE HISTORIE fortune-cs.lsm"
DOCDIR=$PREFIX/${DOCDIR-"/usr/share/doc/fortune-cs-$VERZE"}

### Pozadujete-li koexistenci vice kodovych verzi, nastavte promennou KODOVANI
#KODOVANI=${KODOVANI-"il2 ascii pc2 1250 kam il1"}
KODZDROJE="il2"

### Kde je adresar s texty fortunes - zmna podle FHS 2.0 (RHL 7.0+, Debian)
FORTUNESDIR=$PREFIX/${FORTUNESDIR:-"/usr/share/games/fortune"}
# [ -d "$FORTUNESDIR" ] || \
# FORTUNESDIR=$PREFIX/${FORTUNESDIR:-"/usr/share/games/fortunes"}

### wish skript fortune.tk
GAMESDIR=$PREFIX/usr/games
APPLNKDIR=$PREFIX/etc/X11/applnk/Games
PIXMAPDIR=$PREFIX/usr/share/pixmaps

### Konec sekce s nastavovanim promennych
###
### Instalace

### Dokumentace
if [ -d $DOCDIR ] || mkdir -p $DOCDIR
then cp -f $DOC $DOCDIR
else
 echo "Nelze vytvorit adresar $DOCDIR."
 exit 2
fi

### Pokud nemame cstocs, instalovat se muze jenom jedno kodovani
if [ "`type -path cstocs`" = "" ]
then
 KODOVANI=""
fi

### Instalace do adresare games/fortunes/cs
if [ -d $FORTUNESDIR/cs ] || mkdir -p $FORTUNESDIR/cs
then
 for SOUBOR in $ZDROJE
 do
  cp -f $SOUBOR $FORTUNESDIR/cs
  /usr/sbin/strfile -s $FORTUNESDIR/cs/$SOUBOR
 done
 else
  echo "Chyba pri vytvareni adresare $FORTUNESDIR."
  exit 3
fi

### Eventualni instalace vsech zdroju ve vsech vybranych kodovanich
for KOD in $KODOVANI
do
 CILOVYADR="$FORTUNESDIR/cs-$KOD"
 if [ -d "$CILOVYADR" ] || mkdir -p "$CILOVYADR"
 then
  for SOUBOR in $ZDROJE
  do
   CILOVYSOUBOR="$CILOVYADR/$SOUBOR"
   if cstocs $KODZDROJE $KOD $SOUBOR > $CILOVYSOUBOR
   then
    strfile -s $CILOVYSOUBOR
   else
    echo "Nelze zapsat soubor $CILOVYSOUBOR."
    exit 4
   fi
  done
 else
  echo "Nelze vytvorit adresar $CILOVYADR."
  exit 5
 fi
done

#set -x
### wish skript a odkaz pro menu
install -d $GAMESDIR \
&& install -m755 fortune-cs.tk $GAMESDIR
install -d $APPLNKDIR \
&& install -m644 fortune-cs.desktop $APPLNKDIR
install -d $PIXMAPDIR \
&& install -m644 smile35x34.xpm $PIXMAPDIR

### Zkouska: funguje to?
/usr/games/fortune $FORTUNESDIR/cs > /dev/null
exit $?

