{****************************************************************************

    $Id: os2def.pas,v 1.1.2.4 2002/11/04 21:24:16 hajny Exp $

    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2002 by the Free Pascal development team.

    Common OS/2 types and constants

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 ****************************************************************************}
unit OS2Def;

{Warning: This code is alfa. Future versions
 of this unit might not be compatible.}

interface

const
       Severity_NoError = $0;
       Severity_Warning = $4;
       Severity_Error = $8;
       Severity_Severe = $C;
       Severity_Unrecoverable = $10;
      
       WinErr_Base = $1000;
       GPIErr_Base = $2000;
       DevErr_Base = $3000;
       SplErr_Base = $4000;

       Address = 0;
       Driver_Name = 1;
       Driver_Data = 2;
       Data_Type = 3;
       Comment = 4;
       Proc_Name = 5;
       Proc_Params = 6;
       Spl_Params = 7;
       Network_Params = 8;

       PD_Job_Property = $0001;
       FAttr_Sel_Italic = $0001;
       FAttr_Sel_Underscore = $0002;
       FAttr_Sel_Outline = $0008;
       FAttr_Sel_Strikeout = $0010;
       FAttr_Sel_Bold = $0020;
       FAttr_Type_Kerning = $0004;
       FAttr_Type_MBCS = $0008;
       FAttr_Type_DBCS = $0010;
       FAttr_Type_Antialiased = $0020;
       FAttr_FontUse_NoMix = $0002;
       FAttr_FontUse_Outline = $0004;
       FAttr_FontUse_Transformable = $0008;
       FaceSize = 32;
      
       FM_Type_Fixed = $0001;
       FM_Type_Licensed = $0002;
       FM_Type_Kerning = $0004;
       FM_Type_DBCS = $0010;
       FM_Type_MBCS = $0018;
       FM_Type_64K = $8000;
       FM_Type_Atoms = $4000;
       FM_Type_FamTrunc = $2000;
       FM_Type_FaceTrunc = $1000;
       FM_Defn_Outline = $0001;
       FM_Defn_IFI = $0002;
       FM_Defn_Win = $0004;
       FM_Defn_Generic = $8000;
       FM_Sel_Italic = $0001;
       FM_Sel_Underscore = $0002;
       FM_Sel_Negative = $0004;
       FM_Sel_Outline = $0008;
       FM_Sel_Strikeout = $0010;
       FM_Sel_Bold = $0020;
       FM_Cap_NoMix = $0001;

    type
       PCardinal = ^cardinal;
       PLongint = ^longint;
       PInteger = ^integer;
       PShortint = ^shortint;
       PPointer = ^pointer;
       PByte = ^byte;
       
       PointL = record
	  X: longint;
	  Y: longint;
       end;

       PPointL = ^PointL;

       PointS = record
	  X: integer;
	  Y: integer;
       end;
      
       PPointS = ^PointS;
      
       RectL = record
	  xLeft: longint;
	  yBottom: longint;
	  xRight: longint;
	  yTop: longint;
       end;

       PRectL = ^RectL;

       NPrectL = ^RectL;
       
       Str8 = array[0..7] of char;

       PStr8 = ^Str8;

       DrivData = record
	  cb: longint;
	  lVersion: longint;
	  szDeviceName: array[0..31] of char;
	  abGeneralData: array[0..0] of char;
       end;

       PDrivData = ^DrivData;

       DevOpenStruc = record
	  pszLogAddress: PChar;
	  pszDriverName: PChar;
	  pdriv: PDrivData;
	  pszDataType: PChar;
	  pszComment: PChar;
	  pszQueueProcName: PChar;
	  pszQueueProcParams: PChar;
	  pszSpoolerParams: PChar;
	  pszNetworkParams: PChar;
       end;

       PDevOpenStruc = ^DevOpenStruc;

       PDevOpenData = PDevOpenStruc;

       PrintDest = record
	  cb: cardinal;
	  lType: longint;
	  pszToken: PChar;
	  lCount: longint;
	  pdopData: PDevOpenData;
	  fl: cardinal;
	  pszPrinter: PChar;
       end;

       PPrintDest = ^PrintDest;
       
       FAttrs = record
	  usRecordLength: word;
	  fsSelection: word;
	  lMatch: longint;
	  szFacename: array[0..FaceSize-1] of char;
	  idRegistry: word;
	  usCodePage: word;
	  lMaxBaselineExt: longint;
	  lAveCharWidth: longint;
	  fsType: word;
	  fsFontUse: word;
       end;

       PFAttrs = ^FAttrs;
       
       Panose = record
	  bFamilyType: byte;
	  bSerifStyle: byte;
	  bWeight: byte;
	  bProportion: byte;
	  bContrast: byte;
	  bStrokeVariation: byte;
	  bArmStyle: byte;
	  bLetterform: byte;
	  bMidline: byte;
	  bXHeight: byte;
	  abReserved: array[0..1] of byte;
       end;

       FontMetrics = record
	  szFamilyname: array[0..FaceSize-1] of char;
	  szFacename: array[0..FaceSize-1] of char;
	  idRegistry: word;
	  usCodePage: word;
	  lEmHeight: longint;
	  lXHeight: longint;
	  lMaxAscender: longint;
	  lMaxDescender: longint;
	  lLowerCaseAscent: longint;
	  lLowerCaseDescent: longint;
	  lInternalLeading: longint;
	  lExternalLeading: longint;
	  lAveCharWidth: longint;
	  lMaxCharInc: longint;
	  lEmInc: longint;
	  lMaxBaselineExt: longint;
	  sCharSlope: integer;
	  sInlineDir: integer;
	  sCharRot: integer;
	  usWeightClass: word;
	  usWidthClass: word;
	  sXDeviceRes: integer;
	  sYDeviceRes: integer;
	  sFirstChar: integer;
	  sLastChar: integer;
	  sDefaultChar: integer;
	  sBreakChar: integer;
	  sNominalPointSize: integer;
	  sMinimumPointSize: integer;
	  sMaximumPointSize: integer;
	  fsType: word;
	  fsDefn: word;
	  fsSelection: word;
	  fsCapabilities: word;
	  lSubscriptXSize: longint;
	  lSubscriptYSize: longint;
	  lSubscriptXOffset: longint;
	  lSubscriptYOffset: longint;
	  lSuperscriptXSize: longint;
	  lSuperscriptYSize: longint;
	  lSuperscriptXOffset: longint;
	  lSuperscriptYOffset: longint;
	  lUnderscoreSize: longint;
	  lUnderscorePosition: longint;
	  lStrikeoutSize: longint;
	  lStrikeoutPosition: longint;
	  sKerningPairs: integer;
	  sFamilyClass: integer;
	  lMatch: longint;
	  FamilyNameAtom: longint;
	  FaceNameAtom: longint;
	  _Panose: Panose;
       end;

       PFontMetrics = ^FontMetrics;
       
      { Null terminated strings are often declared as array[0..0] of byte  }
      { in header files, the following type makes type conversion possible }
      CharArray = array[0..0] of char;
     
{Names beginning with T for compatibility}
	TPointL = PointL;
	TPointS = PointS;
	TRectL = RectL;
	TStr8 = Str8;
	TDrivData = DrivData;
	TDevOpenStruc = DevOpenStruc;
	TPrintDest = PrintDest;
	TFAttrs = FAttrs;
	TPanose = Panose;
	TFontMetrics = FontMetrics;
	TCharArray = CharArray;

{Another bunch of compatibility things}
        HWnd = cardinal;
        THWnd = HWnd;
        PHWnd = ^HWnd;
        HAB = cardinal;
        THAB = HAB;
        PHAB = ^HAB;
        HMQ = cardinal;
        THMQ = HMQ;
        PHMQ = ^HMQ;
        HPS = cardinal;
        THPS = HPS;
        PHPS = ^HPS;
        HRGN = cardinal;
        THRGN = HRGN;
        PHRGN = ^HRGN;
        HBitmap = cardinal;
        THBitmap = HBitmap;
        PHBitmap = ^HBitmap;
        HEv = cardinal;
        THEv = HEv;
        PHEv = ^HEv;
        HMtx = cardinal;
        THMtx = HMtx;
        PHMtx = ^HMtx;
        ULONG = cardinal;
        MParam = pointer;
        MResult = pointer;
        Fixed = longint;
        Fixed88 = integer;

{ Constants from bseord.h header file (ordinal numbers of API functions) }

    const
       Ord_AnsiINJECT = 1;
       Ord_AnsiKEYDEF = 2;
       Ord_AnsiINTERP = 3;
       Ord_NlsCONVERTBIDINUMERICS = 1;
       Ord_NlsCONVERTBIDISTRING = 2;
       Ord_NlsSETBIDIATT = 5;
       Ord_NlsQUERYBIDIATT = 6;
       Ord_NlsINVERSESTRING = 7;
       Ord_NlsSETBIDIPRINT = 8;
       Ord_NlsEDITSHAPE = 9;
       Ord_NlsSHAPEBIDISTRING = 10;
       Ord_NlsINTSETBIDIATT = 3;
       Ord_NlsINTQUERYBIDIATT = 4;
       Ord_NLPOPUP = 11;
       Ord_BksMAIN = 1;
       Ord_DrgACCESSDRAGINFO = 1;
       Ord_DrgADDSTRHANDLE = 2;
       Ord_DrgALLOCDRAGINFO = 3;
       Ord_DrgALLOCDRAGTRANSFER = 4;
       Ord_DrgDELETEDRAGINFOSTRHANDLES = 5;
       Ord_DrgDELETESTRHANDLE = 6;
       Ord_DrgDRAG = 7;
       Ord_DrgFREEDRAGINFO = 8;
       Ord_DrgFREEDRAGTRANSFER = 9;
       Ord_DrgGETPS = 10;
       Ord_DrgPOSTTRANSFERMSG = 11;
       Ord_DrgPUSHDRAGINFO = 12;
       Ord_DrgQUERYDRAGITEM = 13;
       Ord_DrgQUERYDRAGITEMCOUNT = 14;
       Ord_DrgQUERYDRAGITEMPTR = 15;
       Ord_DrgQUERYNATIVERMF = 16;
       Ord_DrgQUERYNATIVERMFLEN = 17;
       Ord_DrgQUERYSTRNAME = 18;
       Ord_DrgQUERYSTRNAMELEN = 19;
       Ord_DrgQUERYTRUETYPE = 20;
       Ord_DrgQUERYTRUETYPELEN = 21;
       Ord_DrgRELEASEPS = 22;
       Ord_DrgSENDTRANSFERMSG = 23;
       Ord_DrgSETDRAGPOINTER = 24;
       Ord_DrgSETDRAGIMAGE = 25;
       Ord_DrgSETDRAGITEM = 26;
       Ord_DrgVERIFYNATIVERMF = 27;
       Ord_DrgVERIFYRMF = 28;
       Ord_DrgVERIFYTRUETYPE = 29;
       Ord_DrgVERIFYTYPE = 30;
       Ord_DrgVERIFYTYPESET = 31;
       Ord_DrgDRAGFILES = 63;
       Ord_DrgACCEPTDROPPEDFILES = 64;
       Ord_Drg32ACCESSDRAGINFO = 32;
       Ord_Drg32ADDSTRHANDLE = 33;
       Ord_Drg32ALLOCDRAGINFO = 34;
       Ord_Drg32ALLOCDRAGTRANSFER = 35;
       Ord_Drg32DELETEDRAGINFOSTRHANDLES = 36;
       Ord_Drg32DELETESTRHANDLE = 37;
       Ord_Drg32DRAG = 38;
       Ord_Drg32FREEDRAGINFO = 39;
       Ord_Drg32FREEDRAGTRANSFER = 40;
       Ord_Drg32GETPS = 41;
       Ord_Drg32POSTTRANSFERMSG = 42;
       Ord_Drg32PUSHDRAGINFO = 43;
       Ord_Drg32QUERYDRAGITEM = 44;
       Ord_Drg32QUERYDRAGITEMCOUNT = 45;
       Ord_Drg32QUERYDRAGITEMPTR = 46;
       Ord_Drg32QUERYNATIVERMF = 47;
       Ord_Drg32QUERYNATIVERMFLEN = 48;
       Ord_Drg32QUERYSTRNAME = 49;
       Ord_Drg32QUERYSTRNAMELEN = 50;
       Ord_Drg32QUERYTRUETYPE = 51;
       Ord_Drg32QUERYTRUETYPELEN = 52;
       Ord_Drg32RELEASEPS = 53;
       Ord_Drg32SENDTRANSFERMSG = 54;
       Ord_Drg32SETDRAGPOINTER = 55;
       Ord_Drg32SETDRAGIMAGE = 56;
       Ord_Drg32SETDRAGITEM = 57;
       Ord_Drg32VERIFYNATIVERMF = 58;
       Ord_Drg32VERIFYRMF = 59;
       Ord_Drg32VERIFYTRUETYPE = 60;
       Ord_Drg32VERIFYTYPE = 61;
       Ord_Drg32VERIFYTYPESET = 62;
       Ord_Drg32DRAGFILES = 65;
       Ord_Drg32ACCEPTDROPPEDFILES = 66;
       Ord_FKAINIT = 64;
       Ord_QUERYFKADISPLAYDETAILS = 65;
       Ord_WinFKAWNDPROC = 66;
       Ord_WinLOADFKA = 67;
       Ord_WinCREATEFKA = 68;
       Ord_WinSETFKAFORM = 69;
       Ord_WinQUERYFKAFORM = 70;
       Ord_WinGOTOFKA = 71;
       Ord_WinGOFROMFKA = 72;
       Ord_WinCREATEHELPINSTANCE = 1;
       Ord_WinDESTROYHELPINSTANCE = 2;
       Ord_WinQUERYHELPINSTANCE = 3;
       Ord_WinASSOCIATEHELPINSTANCE = 4;
       Ord_WinLOADHELPTABLE = 5;
       Ord_WinCREATEHELPTABLE = 6;
       Ord_Win32CREATEHELPINSTANCE = 51;
       Ord_Win32DESTROYHELPINSTANCE = 52;
       Ord_Win32QUERYHELPINSTANCE = 53;
       Ord_Win32ASSOCIATEHELPINSTANCE = 54;
       Ord_Win32LOADHELPTABLE = 55;
       Ord_Win32CREATEHELPTABLE = 56;
       Ord_DDFINITIALIZE = 74;
       Ord_DDFPARA = 75;
       Ord_DDFSETFORMAT = 76;
       Ord_DDFSETTEXTALIGN = 77;
       Ord_DDFSETCOLOR = 78;
       Ord_DDFINFORM = 79;
       Ord_DDFSETFONTSTYLE = 80;
       Ord_DDFHYPERTEXT = 81;
       Ord_DDFBEGINLIST = 82;
       Ord_DDFLISTITEM = 83;
       Ord_DDFENDLIST = 84;
       Ord_DDFTEXT = 85;
       Ord_DDFMETAFILE = 86;
       Ord_DDFSETFONT = 87;
       Ord_DDFBITMAP = 88;
       Ord_KbdSETCUSTXT = 1;
       Ord_KbdGETCP = 3;
       Ord_KbdCHARIN = 4;
       Ord_KbdSETCP = 5;
       Ord_KbdSYNCH = 7;
       Ord_KbdREGISTER = 8;
       Ord_KbdSTRINGIN = 9;
       Ord_KbdGETSTATUS = 10;
       Ord_KbdSETSTATUS = 11;
       Ord_KbdGETFOCUS = 12;
       Ord_KbdFLUSHBUFFER = 13;
       Ord_KbdXLATE = 14;
       Ord_KbdCLOSE = 17;
       Ord_KbdFREEFOCUS = 18;
       Ord_KbdDEREGISTER = 20;
       Ord_KbdSETFGND = 21;
       Ord_KbdPEEK = 22;
       Ord_KbdOPEN = 23;
       Ord_KbdGETHWID = 24;
       Ord_KbdSETHWID = 25;
       Ord_DosMONOPEN = 4;
       Ord_DosMONCLOSE = 3;
       Ord_DosMONREAD = 2;
       Ord_DosMONWRITE = 1;
       Ord_DosMONREG = 5;
       Ord_MouGETPTRSHAPE = 1;
       Ord_MouSETPTRSHAPE = 2;
       Ord_MouGETNUMMICKEYS = 3;
       Ord_MouGETHOTKEY = 4;
       Ord_MouGETSCALEFACT = 6;
       Ord_MouFLUSHQUE = 7;
       Ord_MouGETNUMBUTTONS = 8;
       Ord_MouCLOSE = 9;
       Ord_MouSETHOTKEY = 10;
       Ord_MouSETSCALEFACT = 11;
       Ord_MouGETNUMQUEEL = 13;
       Ord_MouDEREGISTER = 14;
       Ord_MouGETEVENTMASK = 15;
       Ord_MouSETEVENTMASK = 16;
       Ord_MouOPEN = 17;
       Ord_MouREMOVEPTR = 18;
       Ord_MouGETPTRPOS = 19;
       Ord_MouREADEVENTQUE = 20;
       Ord_MouSETPTRPOS = 21;
       Ord_MouGETDEVSTATUS = 22;
       Ord_MouSYNCH = 23;
       Ord_MouREGISTER = 24;
       Ord_MouSETDEVSTATUS = 25;
       Ord_MouDRAWPTR = 26;
       Ord_MouINITREAL = 27;
       Ord_MouGETTHRESHOLD = 29;
       Ord_MouSETTHRESHOLD = 30;
       Ord_DosPUTMESSAGE = 1;
       Ord_DosTRUEGETMESSAGE = 2;
       Ord_DosINSMESSAGE = 3;
       Ord_Dos32INSERTMESSAGE = 4;
       Ord_Dos32PUTMESSAGE = 5;
       Ord_Dos32TRUEGETMESSAGE = 6;
       Ord_DosIQUERYMESSAGECP = 7;
       Ord_Dos32IQUERYMESSAGECP = 8;
       Ord_DosCASEMAP = 1;
       Ord_DosGETCOLLATE = 2;
       Ord_DosGETCTRYINFO = 3;
       Ord_DosGETDBCSEV = 4;
       Ord_Dos32QUERYCTRYINFO = 5;
       Ord_Dos32QUERYDBCSENV = 6;
       Ord_Dos32MAPCASE = 7;
       Ord_Dos32QUERYCOLLATE = 8;
       Ord_DosMAKENMPIPE = 1;
       Ord_DosQNMPIPEINFO = 2;
       Ord_DosCONNECTNMPIPE = 3;
       Ord_DosDISCONNECTNMPIPE = 4;
       Ord_DosQNMPHANDSTATE = 5;
       Ord_DosSETNMPHANDSTATE = 6;
       Ord_DosPEEKNMPIPE = 7;
       Ord_DosWAITNMPIPE = 8;
       Ord_DosTRANSACTNMPIPE = 9;
       Ord_DosCALLNMPIPE = 10;
       Ord_DosRAWREADNMPIPE = 11;
       Ord_DosRAWWRITENMPIPE = 12;
       Ord_DosSETNMPIPESEM = 13;
       Ord_DosQNMPIPESEMSTATE = 14;
       Ord_DosCWAIT = 2;
       Ord_DosENTERCRITSEC = 3;
       Ord_DosEXIT = 5;
       Ord_DosEXITCRITSEC = 6;
       Ord_DosEXITLIST = 7;
       Ord_DosGETINFOSEG = 8;
       Ord_DosGETPRTY = 9;
       Ord_DosKILLPROCESS = 10;
       Ord_DosSETPRTY = 11;
       Ord_DosPTRACE = 12;
       Ord_DosHOLDSIGNAL = 13;
       Ord_DosSETSIGHANDLER = 14;
       Ord_DosFLAGPROCESS = 15;
       Ord_DosMAKEPIPE = 16;
       Ord_DosSEMSETWAIT = 20;
       Ord_DosMUXSEMWAIT = 22;
       Ord_DosCLOSESEM = 23;
       Ord_DosCREATESEM = 24;
       Ord_DosOPENSEM = 25;
       Ord_DosRESUMETHREAD = 26;
       Ord_DosSUSPENDTHREAD = 27;
       Ord_DosSETDATETIME = 28;
       Ord_DosTIMERASYNC = 29;
       Ord_DosTIMERSTART = 30;
       Ord_DosTIMERSTOP = 31;
       Ord_DosSLEEP = 32;
       Ord_DosGETDATETIME = 33;
       Ord_DosALLOCSEG = 34;
       Ord_DosALLOCSHRSEG = 35;
       Ord_DosGETSHRSEG = 36;
       Ord_DosGIVESEG = 37;
       Ord_DosREALLOCSEG = 38;
       Ord_DosFREESEG = 39;
       Ord_DosALLOCHUGE = 40;
       Ord_DosGETHUGESHIFT = 41;
       Ord_DosREALLOCHUGE = 42;
       Ord_DosCREATECSALIAS = 43;
       Ord_DosLOADMODULE = 44;
       Ord_DosGETPROCADDR = 45;
       Ord_DosFREEMODULE = 46;
       Ord_DosGETMODHANDLE = 47;
       Ord_DosGETMODNAME = 48;
       Ord_DosGETMACHINEMODE = 49;
       Ord_DosBEEP = 50;
       Ord_DosCLIACCESS = 51;
       Ord_DosDEVCONFIG = 52;
       Ord_DosDEVIOCTL = 53;
       Ord_DosBUFRESET = 56;
       Ord_DosCHDIR = 57;
       Ord_DosCHGFILEPTR = 58;
       Ord_DosCLOSE = 59;
       Ord_DosDELETE = 60;
       Ord_DosDUPHANDLE = 61;
       Ord_DosFILELOCKS = 62;
       Ord_DosFINDCLOSE = 63;
       Ord_DosFINDFIRST = 64;
       Ord_DosFINDNEXT = 65;
       Ord_DosMKDIR = 66;
       Ord_DosMOVE = 67;
       Ord_DosNEWSIZE = 68;
       Ord_DosPORTACCESS = 69;
       Ord_DosOPEN = 70;
       Ord_DosQCURDIR = 71;
       Ord_DosQCURDISK = 72;
       Ord_DosQFHANDSTATE = 73;
       Ord_DosQFILEINFO = 74;
       Ord_DosQFILEMODE = 75;
       Ord_DosQFSINFO = 76;
       Ord_DosQHANDTYPE = 77;
       Ord_DosQVERIFY = 78;
       Ord_DosRMDIR = 80;
       Ord_DosSELECTDISK = 81;
       Ord_DosSETFHANDSTATE = 82;
       Ord_DosSETFILEINFO = 83;
       Ord_DosSETFILEMODE = 84;
       Ord_DosSETMAXFH = 85;
       Ord_DosSETVERIFY = 86;
       Ord_DosSYSTEMSERVICE = 88;
       Ord_DosSETVEC = 89;
       Ord_DosSYSTRACE = 90;
       Ord_DosGETENV = 91;
       Ord_DosGETVERSION = 92;
       Ord_DosGETPID = 94;
       Ord_DosOPEN2 = 95;
       Ord_DosLIBINIT = 96;
       Ord_DosSETFSINFO = 97;
       Ord_DosQPATHINFO = 98;
       Ord_DosDEVIOCTL2 = 99;
       Ord_DosSETPATHINFO = 104;
       Ord_DosISETRELMAXFH = 108;
       Ord_DosIDEVIOCTL = 109;
       Ord_Dos32FORCEDELETE = 110;
       Ord_Dos32KILLTHREAD = 111;
       Ord_DosQUERYRASINFO = 112;
       Ord_DosERROR = 120;
       Ord_DosGETSEG = 121;
       Ord_DosLOCKSEG = 122;
       Ord_DosUNLOCKSEG = 123;
       Ord_DosSIZESEG = 126;
       Ord_DosMEMAVAIL = 127;
       Ord_DosPHYSICALDISK = 129;
       Ord_DosGETCP = 130;
       Ord_DosSENDSIGNAL = 134;
       Ord_DosHUGESHIFT = 135;
       Ord_DosHUGEINCR = 136;
       Ord_DosREAD = 137;
       Ord_DosWRITE = 138;
       Ord_DosERRCLASS = 139;
       Ord_DosSEMREQUEST = 140;
       Ord_DosSEMCLEAR = 141;
       Ord_DosSEMWAIT = 142;
       Ord_DosSEMSET = 143;
       Ord_DosEXECPGM = 144;
       Ord_DosCREATETHREAD = 145;
       Ord_DosSUBSET = 146;
       Ord_DosSUBALLOC = 147;
       Ord_DosSUBFREE = 148;
       Ord_DosREADASYNC = 149;
       Ord_DosWRITEASYNC = 150;
       Ord_DosSEARCHPATH = 151;
       Ord_DosSCANENV = 152;
       Ord_DosSETCP = 153;
       Ord_DosGETRESOURCE = 155;
       Ord_DosGETPPID = 156;
       Ord_DosCALLBACK = 157;
       Ord_DosR2STACKREALLOC = 160;
       Ord_DosFSRAMSEMREQUEST = 161;
       Ord_DosFSRAMSEMCLEAR = 162;
       Ord_DosQAPPTYPE = 163;
       Ord_DosSETPROCCP = 164;
       Ord_DosDYNAMICTRACE = 165;
       Ord_DosQSYSINFO = 166;
       Ord_DosFSATTACH = 181;
       Ord_DosQFSATTACH = 182;
       Ord_DosFSCTL = 183;
       Ord_DosFINDFIRST2 = 184;
       Ord_DosMKDIR2 = 185;
       Ord_DosFILEIO = 186;
       Ord_DosFINDNOTIFYCLOSE = 187;
       Ord_DosFINDNOTIFYFIRST = 188;
       Ord_DosFINDNOTIFYNEXT = 189;
       Ord_DosEDITNAME = 191;
       Ord_DosCOPY = 201;
       Ord_DosFORCEDELETE = 203;
       Ord_DosENUMATTRIBUTE = 204;
       Ord_DosSHUTDOWN = 206;
       Ord_DosGETRESOURCE2 = 207;
       Ord_DosFREERESOURCE = 208;
       Ord_Dos32SETMAXFH = 209;
       Ord_Dos32SETVERIFY = 210;
       Ord_Dos32ERRCLASS = 211;
       Ord_Dos32ERROR = 212;
       Ord_DosMAXPATHLEN = 214;
       Ord_DosPAGESIZE = 215;
       Ord_DosLOCALINFO = 216;
       Ord_DosGLOBALINFO = 217;
       Ord_Dos32SETFILEINFO = 218;
       Ord_Dos32SETPATHINFO = 219;
       Ord_Dos32SETDEFAULTDISK = 220;
       Ord_Dos32SETFHSTATE = 221;
       Ord_Dos32SETFSINFO = 222;
       Ord_Dos32QUERYPATHINFO = 223;
       Ord_Dos32QUERYHTYPE = 224;
       Ord_Dos32QUERYVERIFY = 225;
       Ord_Dos32DELETEDIR = 226;
       Ord_Dos32SCANENV = 227;
       Ord_Dos32SEARCHPATH = 228;
       Ord_Dos32SLEEP = 229;
       Ord_Dos32GETDATETIME = 230;
       Ord_Dos32DEVCONFIG = 231;
       Ord_Dos32ENTERCRITSEC = 232;
       Ord_Dos32EXITCRITSEC = 233;
       Ord_Dos32EXIT = 234;
       Ord_Dos32KILLPROCESS = 235;
       Ord_Dos32SETPRIORITY = 236;
       Ord_Dos32RESUMETHREAD = 237;
       Ord_Dos32SUSPENDTHREAD = 238;
       Ord_Dos32CREATEPIPE = 239;
       Ord_Dos32CALLNPIPE = 240;
       Ord_Dos32CONNECTNPIPE = 241;
       Ord_Dos32DISCONNECTNPIPE = 242;
       Ord_Dos32CREATENPIPE = 243;
       Ord_Dos32PEEKNPIPE = 244;
       Ord_Dos32QUERYNPHSTATE = 245;
       Ord_Dos32RAWREADNPIPE = 246;
       Ord_Dos32RAWWRITENPIPE = 247;
       Ord_Dos32QUERYNPIPEINFO = 248;
       Ord_Dos32QUERYNPIPESEMSTATE = 249;
       Ord_Dos32SETNPHSTATE = 250;
       Ord_Dos32SETNPIPESEM = 251;
       Ord_Dos32TRANSACTNPIPE = 252;
       Ord_Dos32WAITNPIPE = 253;
       Ord_Dos32RESETBUFFER = 254;
       Ord_Dos32SETCURRENTDIR = 255;
       Ord_Dos32SETFILEPTR = 256;
       Ord_Dos32CLOSE = 257;
       Ord_Dos32COPY = 258;
       Ord_Dos32DELETE = 259;
       Ord_Dos32DUPHANDLE = 260;
       Ord_Dos32EDITNAME = 261;
       Ord_Dos32FINDCLOSE = 263;
       Ord_Dos32FINDFIRST = 264;
       Ord_Dos32FINDNEXT = 265;
       Ord_DosOPENVDD = 266;
       Ord_DosREQUESTVDD = 267;
       Ord_DosCLOSEVDD = 268;
       Ord_Dos32FSATTACH = 269;
       Ord_Dos32CREATEDIR = 270;
       Ord_Dos32MOVE = 271;
       Ord_Dos32SETFILESIZE = 272;
       Ord_Dos32OPEN = 273;
       Ord_Dos32QUERYCURRENTDIR = 274;
       Ord_Dos32QUERYCURRENTDISK = 275;
       Ord_Dos32QUERYFHSTATE = 276;
       Ord_Dos32QUERYFSATTACH = 277;
       Ord_Dos32QUERYFSINFO = 278;
       Ord_Dos32QUERYFILEINFO = 279;
       Ord_Dos32WAITCHILD = 280;
       Ord_Dos32READ = 281;
       Ord_Dos32WRITE = 282;
       Ord_Dos32EXECPGM = 283;
       Ord_Dos32DEVIOCTL = 284;
       Ord_Dos32FSCTL = 285;
       Ord_Dos32BEEP = 286;
       Ord_Dos32PHYSICALDISK = 287;
       Ord_Dos32SETCP = 288;
       Ord_Dos32SETPROCESSCP = 289;
       Ord_Dos32STOPTIMER = 290;
       Ord_Dos32QUERYCP = 291;
       Ord_Dos32SETDATETIME = 292;
       Ord_Dos32EXITLIST = 296;
       Ord_Dos32ALLOCMEM = 299;
       Ord_Dos32ALLOCSHAREDMEM = 300;
       Ord_Dos32GETNAMEDSHAREDMEM = 301;
       Ord_Dos32GETSHAREDMEM = 302;
       Ord_Dos32GIVESHAREDMEM = 303;
       Ord_Dos32FREEMEM = 304;
       Ord_Dos32SETMEM = 305;
       Ord_Dos32QUERYMEM = 306;
       Ord_Dos32OPENVDD = 308;
       Ord_Dos32REQUESTVDD = 309;
       Ord_Dos32CLOSEVDD = 310;
       Ord_Dos32CREATETHREAD = 311;
       Ord_Dos32GETINFOBLOCKS = 312;
       Ord_Dos32DYNAMICTRACE = 316;
       Ord_Dos32DEBUG = 317;
       Ord_Dos32LOADMODULE = 318;
       Ord_Dos32QUERYMODULEHANDLE = 319;
       Ord_Dos32QUERYMODULENAME = 320;
       Ord_Dos32QUERYPROCADDR = 321;
       Ord_Dos32FREEMODULE = 322;
       Ord_Dos32QUERYAPPTYPE = 323;
       Ord_Dos32CREATEEVENTSEM = 324;
       Ord_Dos32OPENEVENTSEM = 325;
       Ord_Dos32CLOSEEVENTSEM = 326;
       Ord_Dos32RESETEVENTSEM = 327;
       Ord_Dos32POSTEVENTSEM = 328;
       Ord_Dos32WAITEVENTSEM = 329;
       Ord_Dos32QUERYEVENTSEM = 330;
       Ord_Dos32CREATEMUTEXSEM = 331;
       Ord_Dos32OPENMUTEXSEM = 332;
       Ord_Dos32CLOSEMUTEXSEM = 333;
       Ord_Dos32REQUESTMUTEXSEM = 334;
       Ord_Dos32RELEASEMUTEXSEM = 335;
       Ord_Dos32QUERYMUTEXSEM = 336;
       Ord_Dos32CREATEMUXWAITSEM = 337;
       Ord_Dos32OPENMUXWAITSEM = 338;
       Ord_Dos32CLOSEMUXWAITSEM = 339;
       Ord_Dos32WAITMUXWAITSEM = 340;
       Ord_Dos32ADDMUXWAITSEM = 341;
       Ord_Dos32DELETEMUXWAITSEM = 342;
       Ord_Dos32QUERYMUXWAITSEM = 343;
       Ord_Dos32SUBSETMEM = 344;
       Ord_Dos32SUBALLOCMEM = 345;
       Ord_Dos32SUBFREEMEM = 346;
       Ord_Dos32SUBUNSETMEM = 347;
       Ord_Dos32QUERYSYSINFO = 348;
       Ord_Dos32WAITTHREAD = 349;
       Ord_Dos32ASYNCTIMER = 350;
       Ord_Dos32STARTTIMER = 351;
       Ord_Dos32GETRESOURCE = 352;
       Ord_Dos32FREERESOURCE = 353;
       Ord_Dos32SETEXCEPTIONHANDLER = 354;
       Ord_Dos32UNSETEXCEPTIONHANDLER = 355;
       Ord_Dos32RAISEEXCEPTION = 356;
       Ord_Dos32UNWINDEXCEPTION = 357;
       Ord_Dos32TMRQUERYFREQ = 362;
       Ord_Dos32TMRQUERYTIME = 363;
       Ord_Dos32REGISTERPERFCTRS = 367;
       Ord_Dos32ENUMATTRIBUTE = 372;
       Ord_Dos32QUERYDOSPROPERTY = 373;
       Ord_Dos32SETDOSPROPERTY = 374;
       Ord_DosQUERYDOSPROPERTY = 375;
       Ord_DosSETDOSPROPERTY = 376;
       Ord_Dos32PROFILE = 377;
       Ord_Dos32SETSIGNALEXCEPTIONFOC = 378;
       Ord_Dos32SENDSIGNALEXCEPTION = 379;
       Ord_Dos32ENTERMUSTCOMPLETE = 380;
       Ord_Dos32EXITMUSTCOMPLETE = 381;
       Ord_Dos32SETRELMAXFH = 382;
       Ord_Dos32SHUTDOWN = 415;
       Ord_Dos32REPLACEMODULE = 417;
       Ord_Dos32ACKNOWLEDGESIGNALEXC = 418;
       Ord_Dos32TIB = 419;
       Ord_DosTMRQUERYFREQ = 420;
       Ord_DosTMRQUERYTIME = 421;
       Ord_DosREGISTERPERFCTRS = 422;
       Ord_DosFLATTOSEL = 423;
       Ord_DosSELTOFLAT = 424;
       Ord_Dos32FLATTOSEL = 425;
       Ord_Dos32SELTOFLAT = 426;
       Ord_Dos32SETFILELOCKS = 428;
       Ord_Dos32CANCELLOCKREQUEST = 429;
       Ord_DosOPENCHANGENOTIFY = 437;
       Ord_DosRESETCHANGENOTIFY = 438;
       Ord_DosCLOSECHANGENOTIFY = 439;
       Ord_Dos32OPENCHANGENOTIFY = 440;
       Ord_Dos32RESETCHANGENOTIFY = 441;
       Ord_Dos32CLOSECHANGENOTIFY = 442;
       Ord_Dos32QUERYRESOURCESIZE = 572;
       Ord_DosQUERYRESOURCESIZE = 573;
       Ord_Dos32INITIALIZEPORTHOLE = 580;
       Ord_Dos32QUERYHEADERINFO = 582;
       Ord_DosINITIALIZEPORTHOLE = 583;
       Ord_DosQUERYHEADERINFO = 584;
       Ord_Dos32QUERYPROCTYPE = 586;
       Ord_DosQUERYPROCTYPE = 587;
       Ord_DevOPENDC = 1;
       Ord_DevCLOSEDC = 2;
       Ord_DevPOSTDEVICEMODES = 3;
       Ord_DevESCAPE = 4;
       Ord_DevQUERYHARDCOPYCAPS = 5;
       Ord_DevQUERYCAPS = 6;
       Ord_GpiCREATEPS = 7;
       Ord_GpiQUERYPS = 9;
       Ord_GpiDESTROYPS = 10;
       Ord_GpiRESETPS = 11;
       Ord_GpiSAVEPS = 12;
       Ord_GpiRESTOREPS = 13;
       Ord_GpiASSOCIATE = 14;
       Ord_GpiERRORSEGMENTDATA = 15;
       Ord_GpiERASE = 16;
       Ord_GpiSETDRAWCONTROL = 17;
       Ord_GpiQUERYDRAWCONTROL = 18;
       Ord_GpiDRAWCHAIN = 19;
       Ord_GpiDRAWFROM = 20;
       Ord_GpiDRAWSEGMENT = 21;
       Ord_GpiSETSTOPDRAW = 22;
       Ord_GpiQUERYSTOPDRAW = 23;
       Ord_GpiREMOVEDYNAMICS = 24;
       Ord_GpiDRAWDYNAMICS = 25;
       Ord_GpiSETDRAWINGMODE = 26;
       Ord_GpiQUERYDRAWINGMODE = 27;
       Ord_GpiGETDATA = 28;
       Ord_GpiPUTDATA = 29;
       Ord_GpiSETPICKAPERTURESIZE = 30;
       Ord_GpiQUERYPICKAPERTURESIZE = 31;
       Ord_GpiSETPICKAPERTUREPOSITION = 32;
       Ord_GpiQUERYPICKAPERTUREPOSITION = 33;
       Ord_GpiSETTAG = 34;
       Ord_GpiQUERYTAG = 35;
       Ord_GpiCORRELATECHAIN = 36;
       Ord_GpiCORRELATEFROM = 37;
       Ord_GpiCORRELATESEGMENT = 38;
       Ord_GpiRESETBOUNDARYDATA = 42;
       Ord_GpiQUERYBOUNDARYDATA = 43;
       Ord_GpiOPENSEGMENT = 44;
       Ord_GpiCLOSESEGMENT = 46;
       Ord_GpiDELETESEGMENT = 47;
       Ord_GpiDELETESEGMENTS = 48;
       Ord_GpiQUERYSEGMENTNAMES = 49;
       Ord_GpiSETINITIALSEGMENTATTRS = 51;
       Ord_GpiQUERYINITIALSEGMENTATTRS = 52;
       Ord_GpiSETSEGMENTATTRS = 53;
       Ord_GpiQUERYSEGMENTATTRS = 54;
       Ord_GpiSETSEGMENTPRIORITY = 55;
       Ord_GpiQUERYSEGMENTPRIORITY = 56;
       Ord_GpiSETEDITMODE = 57;
       Ord_GpiQUERYEDITMODE = 58;
       Ord_GpiSETELEMENTPOINTER = 59;
       Ord_GpiQUERYELEMENTPOINTER = 60;
       Ord_GpiOFFSETELEMENTPOINTER = 61;
       Ord_GpiDELETEELEMENT = 62;
       Ord_GpiDELETEELEMENTRANGE = 63;
       Ord_GpiLABEL = 64;
       Ord_GpiSETELEMENTPOINTERATLABEL = 65;
       Ord_GpiDELETEELEMENTSBETWEENLABELS = 66;
       Ord_GpiQUERYELEMENTTYPE = 67;
       Ord_GpiQUERYELEMENT = 68;
       Ord_GpiELEMENT = 69;
       Ord_GpiBEGINELEMENT = 70;
       Ord_GpiENDELEMENT = 71;
       Ord_GpiSETSEGMENTTRANSFORMMATRIX = 78;
       Ord_GpiQUERYSEGMENTTRANSFORMMATRIX = 79;
       Ord_GpiSETMODELTRANSFORMMATRIX = 80;
       Ord_GpiQUERYMODELTRANSFORMMATRIX = 81;
       Ord_GpiCALLSEGMENTMATRIX = 82;
       Ord_GpiSETDEFAULTVIEWMATRIX = 83;
       Ord_GpiQUERYDEFAULTVIEWMATRIX = 84;
       Ord_GpiSETPAGEVIEWPORT = 85;
       Ord_GpiQUERYPAGEVIEWPORT = 86;
       Ord_GpiSETVIEWINGTRANSFORMMATRIX = 87;
       Ord_GpiQUERYVIEWINGTRANSFORMMATRIX = 88;
       Ord_GpiSETGRAPHICSFIELD = 89;
       Ord_GpiQUERYGRAPHICSFIELD = 90;
       Ord_GpiSETVIEWINGLIMITS = 91;
       Ord_GpiQUERYVIEWINGLIMITS = 92;
       Ord_GpiCONVERT = 93;
       Ord_GpiSETATTRMODE = 94;
       Ord_GpiQUERYATTRMODE = 95;
       Ord_GpiPOP = 96;
       Ord_GpiSETATTRS = 97;
       Ord_GpiQUERYATTRS = 98;
       Ord_GpiCREATELOGCOLORTABLE = 99;
       Ord_GpiREALIZECOLORTABLE = 100;
       Ord_GpiUNREALIZECOLORTABLE = 101;
       Ord_GpiQUERYCOLORDATA = 102;
       Ord_GpiQUERYLOGCOLORTABLE = 103;
       Ord_GpiQUERYREALCOLORS = 104;
       Ord_GpiQUERYNEARESTCOLOR = 105;
       Ord_GpiQUERYCOLORINDEX = 106;
       Ord_GpiQUERYRGBCOLOR = 107;
       Ord_GpiSETCOLOR = 108;
       Ord_GpiQUERYCOLOR = 109;
       Ord_GpiSETBACKCOLOR = 110;
       Ord_GpiQUERYBACKCOLOR = 111;
       Ord_GpiSETMIX = 112;
       Ord_GpiQUERYMIX = 113;
       Ord_GpiSETBACKMIX = 114;
       Ord_GpiQUERYBACKMIX = 115;
       Ord_GpiSETLINETYPE = 116;
       Ord_GpiQUERYLINETYPE = 117;
       Ord_GpiSETLINEWIDTH = 118;
       Ord_GpiQUERYLINEWIDTH = 119;
       Ord_GpiSETLINEWIDTHGEOM = 120;
       Ord_GpiQUERYLINEWIDTHGEOM = 121;
       Ord_GpiSETLINEEND = 122;
       Ord_GpiQUERYLINEEND = 123;
       Ord_GpiSETLINEJOIN = 124;
       Ord_GpiQUERYLINEJOIN = 125;
       Ord_GpiSETCURRENTPOSITION = 126;
       Ord_GpiQUERYCURRENTPOSITION = 127;
       Ord_GpiMOVE = 128;
       Ord_GpiLINE = 129;
       Ord_GpiPOLYLINE = 130;
       Ord_GpiBOX = 131;
       Ord_GpiPTVISIBLE = 132;
       Ord_GpiRECTVISIBLE = 133;
       Ord_GpiSETARCPARAMS = 134;
       Ord_GpiQUERYARCPARAMS = 135;
       Ord_GpiPOINTARC = 136;
       Ord_GpiFULLARC = 137;
       Ord_GpiPARTIALARC = 138;
       Ord_GpiPOLYFILLET = 139;
       Ord_GpiPOLYFILLETSHARP = 140;
       Ord_GpiPOLYSPLINE = 141;
       Ord_GpiSETBITMAPID = 142;
       Ord_GpiQUERYBITMAPHANDLE = 143;
       Ord_GpiSETPATTERNSET = 144;
       Ord_GpiQUERYPATTERNSET = 145;
       Ord_GpiSETPATTERN = 146;
       Ord_GpiQUERYPATTERN = 147;
       Ord_GpiSETPATTERNREFPOINT = 148;
       Ord_GpiQUERYPATTERNREFPOINT = 149;
       Ord_GpiBEGINAREA = 150;
       Ord_GpiENDAREA = 151;
       Ord_GpiLOADFONTS = 152;
       Ord_GpiUNLOADFONTS = 153;
       Ord_GpiCREATELOGFONT = 154;
       Ord_GpiDELETESETID = 155;
       Ord_GpiQUERYNUMBERSETIDS = 156;
       Ord_GpiQUERYSETIDS = 157;
       Ord_GpiQUERYFONTS = 158;
       Ord_GpiQUERYFONTMETRICS = 159;
       Ord_GpiQUERYKERNINGPAIRS = 160;
       Ord_GpiQUERYWIDTHTABLE = 161;
       Ord_GpiSETCP = 162;
       Ord_GpiQUERYCP = 163;
       Ord_GpiQUERYTEXTBOX = 164;
       Ord_DevQUERYDEVICENAMES = 165;
       Ord_GpiQUERYDEFCHARBOX = 166;
       Ord_GpiQUERYFONTFILEDESCRIPTIONS = 167;
       Ord_GpiSETCHARSET = 168;
       Ord_GpiQUERYCHARSET = 169;
       Ord_GpiSETCHARBOX = 170;
       Ord_GpiQUERYCHARBOX = 171;
       Ord_GpiSETCHARANGLE = 172;
       Ord_GpiQUERYCHARANGLE = 173;
       Ord_GpiSETCHARSHEAR = 174;
       Ord_GpiQUERYCHARSHEAR = 175;
       Ord_GpiSETCHARDIRECTION = 176;
       Ord_GpiQUERYCHARDIRECTION = 177;
       Ord_GpiSETCHARMODE = 178;
       Ord_GpiQUERYCHARMODE = 179;
       Ord_GpiCHARSTRING = 180;
       Ord_GpiCHARSTRINGAT = 181;
       Ord_GpiCHARSTRINGPOS = 182;
       Ord_GpiCHARSTRINGPOSAT = 183;
       Ord_GpiSETMARKERSET = 184;
       Ord_GpiQUERYMARKERSET = 185;
       Ord_GpiSETMARKER = 186;
       Ord_GpiQUERYMARKER = 187;
       Ord_GpiSETMARKERBOX = 188;
       Ord_GpiQUERYMARKERBOX = 189;
       Ord_GpiMARKER = 190;
       Ord_GpiPOLYMARKER = 191;
       Ord_GpiIMAGE = 192;
       Ord_GpiCREATEBITMAP = 196;
       Ord_GpiDELETEBITMAP = 197;
       Ord_GpiSETBITMAP = 198;
       Ord_GpiSETBITMAPDIMENSION = 199;
       Ord_GpiQUERYBITMAPDIMENSION = 200;
       Ord_GpiQUERYDEVICEBITMAPFORMATS = 201;
       Ord_GpiQUERYBITMAPPARAMETERS = 202;
       Ord_GpiSETBITMAPBITS = 203;
       Ord_GpiQUERYBITMAPBITS = 204;
       Ord_GpiBITBLT = 205;
       Ord_GpiSETPEL = 206;
       Ord_GpiQUERYPEL = 207;
       Ord_GpiCREATEREGION = 208;
       Ord_GpiSETREGION = 209;
       Ord_GpiDESTROYREGION = 210;
       Ord_GpiCOMBINEREGION = 211;
       Ord_GpiEQUALREGION = 212;
       Ord_GpiOFFSETREGION = 213;
       Ord_GpiPTINREGION = 214;
       Ord_GpiRECTINREGION = 215;
       Ord_GpiQUERYREGIONBOX = 216;
       Ord_GpiQUERYREGIONRECTS = 217;
       Ord_GpiSETCLIPREGION = 218;
       Ord_GpiQUERYCLIPREGION = 219;
       Ord_GpiQUERYCLIPBOX = 220;
       Ord_GpiINTERSECTCLIPRECTANGLE = 221;
       Ord_GpiEXCLUDECLIPRECTANGLE = 222;
       Ord_GpiOFFSETCLIPREGION = 223;
       Ord_GpiPAINTREGION = 224;
       Ord_GpiLOADMETAFILE = 225;
       Ord_GpiCOPYMETAFILE = 226;
       Ord_GpiPLAYMETAFILE = 227;
       Ord_GpiSAVEMETAFILE = 228;
       Ord_GpiDELETEMETAFILE = 229;
       Ord_GpiQUERYMETAFILEBITS = 230;
       Ord_GpiSETMETAFILEBITS = 231;
       Ord_GpiQUERYMETAFILELENGTH = 232;
       Ord_GpiSETCLIPPATH = 233;
       Ord_GpiBEGINPATH = 234;
       Ord_GpiENDPATH = 235;
       Ord_GpiCLOSEFIGURE = 236;
       Ord_GpiMODIFYPATH = 237;
       Ord_GpiFILLPATH = 238;
       Ord_GpiSTARTREQUEST = 239;
       Ord_GpiQUERYDEVICE = 240;
       Ord_DevSTDOPEN = 244;
       Ord_GpiQUERYCHARSTRINGPOS = 245;
       Ord_GpiQUERYCHARSTRINGPOSAT = 246;
       Ord_GpiSETPS = 248;
       Ord_SEGSGWOPENSEGMENTWINDOW = 249;
       Ord_MTENDREADREQUEST = 250;
       Ord_MTGETDESCRIPTION = 251;
       Ord_FMTORDERTABLE = 252;
       Ord_MTGETCODEPAGE = 253;
       Ord_MTGETLCT = 254;
       Ord_MTGETGDDINFO = 255;
       Ord_FMTCONVERTGOCAPOLY = 256;
       Ord_MTGETFIRSTFONT = 257;
       Ord_SEGSGWNEWPARTDATA = 258;
       Ord_MTSTARTREADREQUEST = 259;
       Ord_MTGETFIRSTGRAPHICSDATA = 260;
       Ord_MTGETNEXTFONT = 261;
       Ord_MTGETNEXTGRAPHICSDATA = 262;
       Ord_GpiLOADPUBLICFONTS = 263;
       Ord_GpiUNLOADPUBLICFONTS = 264;
       Ord_GpiCOMMENT = 268;
       Ord_GpiWCBITBLT = 269;
       Ord_GpiSTROKEPATH = 270;
       Ord_SEGSGWNEXTORDERF = 271;
       Ord_GpiOUTLINEPATH = 274;
       Ord_GpiSETDEFTAG = 275;
       Ord_GpiQUERYDEFTAG = 276;
       Ord_GpiSETDEFATTRS = 277;
       Ord_GpiQUERYDEFATTRS = 278;
       Ord_GpiSETDEFVIEWINGLIMITS = 279;
       Ord_GpiQUERYDEFVIEWINGLIMITS = 280;
       Ord_GpiSETDEFARCPARAMS = 281;
       Ord_GpiQUERYDEFARCPARAMS = 282;
       Ord_GpiTRANSLATE = 283;
       Ord_GpiSCALE = 284;
       Ord_GpiROTATE = 285;
       Ord_GpiPOLYLINEDISJOINT = 286;
       Ord_GpiPATHTOREGION = 287;
       Ord_GpiFLOODFILL = 289;
       Ord_GpiDRAWBITS = 290;
       Ord_GpiQUERYBITMAPINFOHEADER = 291;
       Ord_GpiQUERYLOGICALFONT = 292;
       Ord_GpiQUERYFACESTRING = 293;
       Ord_GpiQUERYFONTACTION = 294;
       Ord_GpiCREATEPALETTE = 295;
       Ord_GpiDELETEPALETTE = 296;
       Ord_GpiSELECTPALETTE = 297;
       Ord_GpiANIMATEPALETTE = 298;
       Ord_GpiSETPALETTEENTRIES = 299;
       Ord_GpiQUERYPALETTE = 300;
       Ord_GpiQUERYPALETTEINFO = 301;
       Ord_GpiQUERYCHAREXTRA = 302;
       Ord_GpiSETCHAREXTRA = 303;
       Ord_GpiQUERYCHARBREAKEXTRA = 304;
       Ord_GpiSETCHARBREAKEXTRA = 305;
       Ord_GpiFRAMEREGION = 306;
       Ord_GpiCONVERTWITHMATRIX = 307;
       Ord_Gpi32ASSOCIATE = 351;
       Ord_Gpi32BEGINAREA = 352;
       Ord_Gpi32BEGINELEMENT = 353;
       Ord_Gpi32BEGINPATH = 354;
       Ord_Gpi32BITBLT = 355;
       Ord_Gpi32BOX = 356;
       Ord_Gpi32CALLSEGMENTMATRIX = 357;
       Ord_Gpi32CHARSTRING = 358;
       Ord_Gpi32CHARSTRINGAT = 359;
       Ord_Gpi32CLOSEFIGURE = 360;
       Ord_Gpi32CLOSESEGMENT = 361;
       Ord_Gpi32COMBINEREGION = 362;
       Ord_Gpi32COMMENT = 363;
       Ord_Gpi32CONVERT = 364;
       Ord_Gpi32COPYMETAFILE = 365;
       Ord_Gpi32CORRELATECHAIN = 366;
       Ord_Gpi32CORRELATEFROM = 367;
       Ord_Gpi32CREATELOGFONT = 368;
       Ord_Gpi32CREATEPS = 369;
       Ord_Gpi32CREATEREGION = 370;
       Ord_Gpi32DELETEBITMAP = 371;
       Ord_Gpi32DELETEELEMENT = 372;
       Ord_Gpi32DELETEELEMENTRANGE = 373;
       Ord_Gpi32DELETEELEMENTSBETWEENLABE = 374;
       Ord_Gpi32DELETEMETAFILE = 375;
       Ord_Gpi32DELETESEGMENT = 376;
       Ord_Gpi32DELETESEGMENTS = 377;
       Ord_Gpi32DELETESETID = 378;
       Ord_Gpi32DESTROYPS = 379;
       Ord_Gpi32DRAWCHAIN = 380;
       Ord_Gpi32DRAWDYNAMICS = 381;
       Ord_Gpi32DRAWFROM = 382;
       Ord_Gpi32DRAWSEGMENT = 383;
       Ord_Gpi32ELEMENT = 384;
       Ord_Gpi32ENDAREA = 385;
       Ord_Gpi32ENDELEMENT = 386;
       Ord_Gpi32ENDPATH = 387;
       Ord_Gpi32EQUALREGION = 388;
       Ord_Gpi32ERASE = 389;
       Ord_Gpi32ERRORSEGMENTDATA = 390;
       Ord_Gpi32EXCLUDECLIPRECTANGLE = 391;
       Ord_Gpi32FILLPATH = 392;
       Ord_Gpi32FULLARC = 393;
       Ord_Gpi32GETDATA = 394;
       Ord_Gpi32IMAGE = 395;
       Ord_Gpi32INTERSECTCLIPRECTANGLE = 396;
       Ord_Gpi32LABEL = 397;
       Ord_Gpi32LINE = 398;
       Ord_Gpi32LOADBITMAP = 399;
       Ord_Gpi32LOADFONTS = 400;
       Ord_Gpi32LOADMETAFILE = 401;
       Ord_Gpi32MARKER = 402;
       Ord_Gpi32MODIFYPATH = 403;
       Ord_Gpi32MOVE = 404;
       Ord_Gpi32OFFSETCLIPREGION = 405;
       Ord_Gpi32OFFSETELEMENTPOINTER = 406;
       Ord_Gpi32OFFSETREGION = 407;
       Ord_Gpi32OPENSEGMENT = 408;
       Ord_Gpi32PAINTREGION = 409;
       Ord_Gpi32PLAYMETAFILE = 411;
       Ord_Gpi32POINTARC = 412;
       Ord_Gpi32POLYFILLET = 413;
       Ord_Gpi32POLYFILLETSHARP = 414;
       Ord_Gpi32POLYLINE = 415;
       Ord_Gpi32POLYMARKER = 416;
       Ord_Gpi32POLYSPLINE = 417;
       Ord_Gpi32POP = 418;
       Ord_Gpi32PTINREGION = 419;
       Ord_Gpi32PTVISIBLE = 420;
       Ord_Gpi32PUTDATA = 421;
       Ord_Gpi32QUERYARCPARAMS = 422;
       Ord_Gpi32QUERYATTRMODE = 423;
       Ord_Gpi32QUERYBACKCOLOR = 424;
       Ord_Gpi32QUERYBACKMIX = 425;
       Ord_Gpi32QUERYBITMAPDIMENSION = 426;
       Ord_Gpi32QUERYBITMAPHANDLE = 427;
       Ord_Gpi32QUERYBOUNDARYDATA = 428;
       Ord_Gpi32QUERYCHARANGLE = 429;
       Ord_Gpi32QUERYCHARBOX = 430;
       Ord_Gpi32QUERYCHARDIRECTION = 431;
       Ord_Gpi32QUERYCHARMODE = 432;
       Ord_Gpi32QUERYCHARSET = 433;
       Ord_Gpi32QUERYCHARSHEAR = 434;
       Ord_Gpi32QUERYCLIPBOX = 435;
       Ord_Gpi32QUERYCLIPREGION = 436;
       Ord_Gpi32QUERYCOLOR = 437;
       Ord_Gpi32QUERYCOLORDATA = 438;
       Ord_Gpi32QUERYCOLORINDEX = 439;
       Ord_Gpi32QUERYCP = 440;
       Ord_Gpi32QUERYCURRENTPOSITION = 441;
       Ord_Gpi32QUERYDEFCHARBOX = 442;
       Ord_Gpi32QUERYDEFAULTVIEWMATRIX = 443;
       Ord_Gpi32QUERYDEVICE = 444;
       Ord_Gpi32QUERYDEVICEBITMAPFORMATS = 445;
       Ord_Gpi32QUERYDRAWCONTROL = 446;
       Ord_Gpi32QUERYDRAWINGMODE = 447;
       Ord_Gpi32QUERYEDITMODE = 448;
       Ord_Gpi32QUERYELEMENT = 449;
       Ord_Gpi32QUERYELEMENTPOINTER = 450;
       Ord_Gpi32QUERYELEMENTTYPE = 451;
       Ord_Gpi32QUERYFONTFILEDESCRIPTIONS = 452;
       Ord_Gpi32QUERYFONTMETRICS = 453;
       Ord_Gpi32QUERYGRAPHICSFIELD = 454;
       Ord_Gpi32QUERYINITIALSEGMENTATTRS = 455;
       Ord_Gpi32QUERYKERNINGPAIRS = 456;
       Ord_Gpi32QUERYLINEEND = 457;
       Ord_Gpi32QUERYLINEJOIN = 458;
       Ord_Gpi32QUERYLINETYPE = 459;
       Ord_Gpi32QUERYLINEWIDTH = 460;
       Ord_Gpi32QUERYLINEWIDTHGEOM = 461;
       Ord_Gpi32QUERYMARKER = 462;
       Ord_Gpi32QUERYMARKERBOX = 463;
       Ord_Gpi32QUERYMARKERSET = 464;
       Ord_Gpi32QUERYMETAFILEBITS = 465;
       Ord_Gpi32QUERYMETAFILELENGTH = 466;
       Ord_Gpi32QUERYMIX = 467;
       Ord_Gpi32QUERYMODELTRANSFORMMATRIX = 468;
       Ord_Gpi32QUERYNEARESTCOLOR = 469;
       Ord_Gpi32QUERYNUMBERSETIDS = 470;
       Ord_Gpi32QUERYPS = 471;
       Ord_Gpi32QUERYPAGEVIEWPORT = 472;
       Ord_Gpi32QUERYPATTERN = 473;
       Ord_Gpi32QUERYPATTERNREFPOINT = 474;
       Ord_Gpi32QUERYPATTERNSET = 475;
       Ord_Gpi32QUERYPEL = 476;
       Ord_Gpi32QUERYPICKAPERTUREPOSITION = 477;
       Ord_Gpi32QUERYPICKAPERTURESIZE = 478;
       Ord_Gpi32QUERYRGBCOLOR = 479;
       Ord_Gpi32QUERYREALCOLORS = 480;
       Ord_Gpi32QUERYREGIONBOX = 481;
       Ord_Gpi32QUERYSEGMENTATTRS = 482;
       Ord_Gpi32QUERYSEGMENTNAMES = 483;
       Ord_Gpi32QUERYSEGMENTPRIORITY = 484;
       Ord_Gpi32QUERYSEGMENTTRANSFORMMATR = 485;
       Ord_Gpi32QUERYSETIDS = 486;
       Ord_Gpi32QUERYSTOPDRAW = 487;
       Ord_Gpi32QUERYTAG = 488;
       Ord_Gpi32QUERYTEXTBOX = 489;
       Ord_Gpi32QUERYVIEWINGLIMITS = 490;
       Ord_Gpi32QUERYVIEWINGTRANSFORMMATR = 491;
       Ord_Gpi32QUERYWIDTHTABLE = 492;
       Ord_Gpi32RECTINREGION = 494;
       Ord_Gpi32RECTVISIBLE = 495;
       Ord_Gpi32REMOVEDYNAMICS = 496;
       Ord_Gpi32RESETBOUNDARYDATA = 497;
       Ord_Gpi32RESETPS = 498;
       Ord_Gpi32RESTOREPS = 499;
       Ord_Gpi32SAVEMETAFILE = 500;
       Ord_Gpi32SAVEPS = 501;
       Ord_Gpi32SETARCPARAMS = 502;
       Ord_Gpi32SETATTRMODE = 503;
       Ord_Gpi32SETBACKCOLOR = 504;
       Ord_Gpi32SETBACKMIX = 505;
       Ord_Gpi32SETBITMAP = 506;
       Ord_Gpi32SETBITMAPDIMENSION = 507;
       Ord_Gpi32SETBITMAPID = 508;
       Ord_Gpi32SETCHARANGLE = 509;
       Ord_Gpi32SETCHARBOX = 510;
       Ord_Gpi32SETCHARDIRECTION = 511;
       Ord_Gpi32SETCHARMODE = 512;
       Ord_Gpi32SETCHARSET = 513;
       Ord_Gpi32SETCHARSHEAR = 514;
       Ord_Gpi32SETCLIPPATH = 515;
       Ord_Gpi32SETCLIPREGION = 516;
       Ord_Gpi32SETCOLOR = 517;
       Ord_Gpi32SETCP = 518;
       Ord_Gpi32SETCURRENTPOSITION = 519;
       Ord_Gpi32SETDEFAULTVIEWMATRIX = 520;
       Ord_Gpi32SETDRAWCONTROL = 521;
       Ord_Gpi32SETDRAWINGMODE = 522;
       Ord_Gpi32SETEDITMODE = 523;
       Ord_Gpi32SETELEMENTPOINTER = 524;
       Ord_Gpi32SETELEMENTPOINTERATLABEL = 525;
       Ord_Gpi32SETGRAPHICSFIELD = 526;
       Ord_Gpi32SETINITIALSEGMENTATTRS = 527;
       Ord_Gpi32SETLINEEND = 528;
       Ord_Gpi32SETLINEJOIN = 529;
       Ord_Gpi32SETLINETYPE = 530;
       Ord_Gpi32SETLINEWIDTH = 531;
       Ord_Gpi32SETLINEWIDTHGEOM = 532;
       Ord_Gpi32SETMARKER = 533;
       Ord_Gpi32SETMARKERBOX = 534;
       Ord_Gpi32SETMARKERSET = 535;
       Ord_Gpi32SETMETAFILEBITS = 536;
       Ord_Gpi32SETMIX = 537;
       Ord_Gpi32SETMODELTRANSFORMMATRIX = 538;
       Ord_Gpi32SETPS = 539;
       Ord_Gpi32SETPAGEVIEWPORT = 540;
       Ord_Gpi32SETPATTERN = 541;
       Ord_Gpi32SETPATTERNREFPOINT = 542;
       Ord_Gpi32SETPATTERNSET = 543;
       Ord_Gpi32SETPEL = 544;
       Ord_Gpi32SETPICKAPERTUREPOSITION = 545;
       Ord_Gpi32SETREGION = 546;
       Ord_Gpi32SETSEGMENTATTRS = 547;
       Ord_Gpi32SETSEGMENTPRIORITY = 548;
       Ord_Gpi32SETSEGMENTTRANSFORMMATRIX = 549;
       Ord_Gpi32SETSTOPDRAW = 550;
       Ord_Gpi32SETTAG = 551;
       Ord_Gpi32SETVIEWINGLIMITS = 552;
       Ord_Gpi32SETVIEWINGTRANSFORMMATRIX = 553;
       Ord_Gpi32STROKEPATH = 554;
       Ord_Gpi32UNLOADFONTS = 555;
       Ord_Gpi32WCBITBLT = 557;
       Ord_Gpi32POLYLINEDISJOINT = 558;
       Ord_Gpi32PATHTOREGION = 559;
       Ord_Gpi32FLOODFILL = 560;
       Ord_Gpi32SUSPENDPLAY = 561;
       Ord_Gpi32RESUMEPLAY = 562;
       Ord_Gpi32OUTLINEPATH = 563;
       Ord_Gpi32TRANSLATE = 564;
       Ord_Gpi32SCALE = 565;
       Ord_Gpi32ROTATE = 566;
       Ord_Gpi32QUERYDEFARCPARAMS = 567;
       Ord_Gpi32QUERYDEFTAG = 568;
       Ord_Gpi32QUERYDEFVIEWINGLIMITS = 569;
       Ord_Gpi32SETDEFARCPARAMS = 570;
       Ord_Gpi32SETDEFTAG = 571;
       Ord_Gpi32SETDEFVIEWINGLIMITS = 572;
       Ord_Gpi32QUERYBITMAPPARAMETERS = 573;
       Ord_Gpi32QUERYLOGICALFONT = 574;
       Ord_Gpi32QUERYFACESTRING = 575;
       Ord_Gpi32QUERYFONTACTION = 576;
       Ord_Gpi32DELETEPALETTE = 577;
       Ord_Gpi32SELECTPALETTE = 578;
       Ord_Gpi32QUERYPALETTE = 579;
       Ord_Gpi32CHARSTRINGPOS = 580;
       Ord_Gpi32CHARSTRINGPOSAT = 581;
       Ord_Gpi32CORRELATESEGMENT = 582;
       Ord_Gpi32QUERYATTRS = 583;
       Ord_Gpi32QUERYCHARSTRINGPOS = 584;
       Ord_Gpi32QUERYCHARSTRINGPOSAT = 585;
       Ord_Gpi32QUERYFONTS = 586;
       Ord_Gpi32QUERYREGIONRECTS = 587;
       Ord_Gpi32SETATTRS = 588;
       Ord_Gpi32SETPICKAPERTURESIZE = 589;
       Ord_Gpi32QUERYDEFATTRS = 590;
       Ord_Gpi32SETDEFATTRS = 591;
       Ord_Gpi32CREATELOGCOLORTABLE = 592;
       Ord_Gpi32QUERYLOGCOLORTABLE = 593;
       Ord_Gpi32CREATEPALETTE = 594;
       Ord_Gpi32ANIMATEPALETTE = 595;
       Ord_Gpi32SETPALETTEENTRIES = 596;
       Ord_Gpi32QUERYPALETTEINFO = 597;
       Ord_Gpi32CREATEBITMAP = 598;
       Ord_Gpi32QUERYBITMAPBITS = 599;
       Ord_Gpi32QUERYBITMAPINFOHEADER = 601;
       Ord_Gpi32SETBITMAPBITS = 602;
       Ord_Gpi32DRAWBITS = 603;
       Ord_Dev32CLOSEDC = 604;
       Ord_Dev32ESCAPE = 605;
       Ord_Dev32QUERYCAPS = 606;
       Ord_Dev32QUERYDEVICENAMES = 607;
       Ord_Dev32QUERYHARDCOPYCAPS = 608;
       Ord_Dev32POSTDEVICEMODES = 609;
       Ord_Dev32OPENDC = 610;
       Ord_Gpi32DESTROYREGION = 611;
       Ord_Gpi32PARTIALARC = 612;
       Ord_Gpi32QUERYCHAREXTRA = 613;
       Ord_Gpi32SETCHAREXTRA = 614;
       Ord_Gpi32QUERYCHARBREAKEXTRA = 615;
       Ord_Gpi32SETCHARBREAKEXTRA = 616;
       Ord_Gpi32FRAMEREGION = 617;
       Ord_Gpi32CONVERTWITHMATRIX = 618;
       Ord_Gpi32LOADPUBLICFONTS = 622;
       Ord_Gpi32UNLOADPUBLICFONTS = 623;
       Ord_WinQUERYDESKTOPWINDOW = 1;
       Ord_WinQUERYOBJECTWINDOW = 2;
       Ord_WinREGISTERCLASS = 3;
       Ord_WinQUERYCLASSNAME = 4;
       Ord_WinQUERYCLASSINFO = 5;
       Ord_WinCREATEWINDOW = 6;
       Ord_WinDESTROYWINDOW = 7;
       Ord_WinSETWINDOWPOS = 8;
       Ord_WinSETMULTWINDOWPOS = 9;
       Ord_WinQUERYWINDOWPOS = 10;
       Ord_WinENABLEWINDOW = 11;
       Ord_WinISWINDOWENABLED = 12;
       Ord_WinSHOWWINDOW = 13;
       Ord_WinENABLEWINDOWUPDATE = 14;
       Ord_WinISWINDOWVISIBLE = 15;
       Ord_WinSETWINDOWTEXT = 16;
       Ord_WinQUERYWINDOWTEXT = 17;
       Ord_WinQUERYWINDOWTEXTLENGTH = 18;
       Ord_WinWINDOWFROMID = 19;
       Ord_WinMULTWINDOWFROMIDS = 20;
       Ord_WinISWINDOW = 21;
       Ord_WinISCHILD = 22;
       Ord_WinSETPARENT = 23;
       Ord_WinSETOWNER = 24;
       Ord_WinQUERYWINDOW = 25;
       Ord_WinQUERYWINDOWRECT = 26;
       Ord_WinQUERYWINDOWPROCESS = 27;
       Ord_WinSETWINDOWUSHORT = 28;
       Ord_WinQUERYWINDOWUSHORT = 29;
       Ord_WinSETWINDOWULONG = 30;
       Ord_WinQUERYWINDOWULONG = 31;
       Ord_WinBEGINENUMWINDOWS = 32;
       Ord_WinGETNEXTWINDOW = 33;
       Ord_WinENDENUMWINDOWS = 34;
       Ord_WinWINDOWFROMPOINT = 35;
       Ord_WinMAPWINDOWPOINTS = 36;
       Ord_WinSUBCLASSWINDOW = 37;
       Ord_WinLOCKWINDOW = 38;
       Ord_WinQUERYWINDOWLOCKCOUNT = 39;
       Ord_WinREGISTERWINDOWDESTROY = 40;
       Ord_WinOPENWINDOWDC = 41;
       Ord_WinGETSCREENPS = 42;
       Ord_WinGETPS = 43;
       Ord_WinRELEASEPS = 44;
       Ord_WinBEGINPAINT = 45;
       Ord_WinENDPAINT = 46;
       Ord_WinINVALIDATERECT = 47;
       Ord_WinINVALIDATEREGION = 48;
       Ord_WinVALIDATERECT = 49;
       Ord_WinVALIDATEREGION = 50;
       Ord_WinQUERYUPDATERECT = 51;
       Ord_WinQUERYUPDATEREGION = 52;
       Ord_WinUPDATEWINDOW = 53;
       Ord_WinEXCLUDEUPDATEREGION = 54;
       Ord_WinLOCKWINDOWUPDATE = 55;
       Ord_WinLOCKVISREGIONS = 56;
       Ord_WinWINDOWFROMDC = 57;
       Ord_WinCREATEMSGQUEUE = 58;
       Ord_WinDESTROYMSGQUEUE = 59;
       Ord_WinQUERYQUEUESTATUS = 60;
       Ord_WinSENDMSG = 61;
       Ord_WinBROADCASTMSG = 63;
       Ord_WinINSENDMSG = 64;
       Ord_WinGETMSG = 65;
       Ord_WinPEEKMSG = 66;
       Ord_WinWAITMSG = 67;
       Ord_WinDISPATCHMSG = 68;
       Ord_WinPOSTMSG = 69;
       Ord_WinPOSTQUEUEMSG = 70;
       Ord_WinQUERYMSGPOS = 71;
       Ord_WinQUERYMSGTIME = 72;
       Ord_WinCALLMSGFILTER = 73;
       Ord_WinSETMSGINTEREST = 74;
       Ord_WinSETCAPTURE = 75;
       Ord_WinQUERYCAPTURE = 76;
       Ord_WinSETFOCUS = 77;
       Ord_WinQUERYFOCUS = 78;
       Ord_WinSETACTIVEWINDOW = 79;
       Ord_WinQUERYACTIVEWINDOW = 80;
       Ord_WinSETSYSMODALWINDOW = 81;
       Ord_WinQUERYSYSMODALWINDOW = 82;
       Ord_WinISTHREADACTIVE = 83;
       Ord_WinSTARTTIMER = 84;
       Ord_WinSTOPTIMER = 85;
       Ord_WinGETCURRENTTIME = 86;
       Ord_WinLOADPOINTER = 87;
       Ord_WinCREATEPOINTER = 88;
       Ord_WinDESTROYPOINTER = 89;
       Ord_OldWinQUERYPOINTERINFO = 90;
       Ord_WinQUERYSYSPOINTER = 91;
       Ord_WinSETPOINTER = 92;
       Ord_WinQUERYPOINTER = 93;
       Ord_WinSHOWPOINTER = 94;
       Ord_WinSETPOINTERPOS = 95;
       Ord_WinQUERYPOINTERPOS = 96;
       Ord_WinGETSYSBITMAP = 97;
       Ord_WinCREATECURSOR = 98;
       Ord_WinDESTROYCURSOR = 99;
       Ord_WinSHOWCURSOR = 100;
       Ord_WinQUERYCURSORINFO = 101;
       Ord_WinLOADACCELTABLE = 102;
       Ord_WinCREATEACCELTABLE = 103;
       Ord_WinDESTROYACCELTABLE = 104;
       Ord_WinTRANSLATEACCEL = 105;
       Ord_WinSETACCELTABLE = 106;
       Ord_WinQUERYACCELTABLE = 107;
       Ord_WinCOPYACCELTABLE = 108;
       Ord_WinSETHOOK = 109;
       Ord_WinRELEASEHOOK = 110;
       Ord_WinOPENCLIPBRD = 111;
       Ord_WinCLOSECLIPBRD = 112;
       Ord_WinEMPTYCLIPBRD = 113;
       Ord_WinSETCLIPBRDOWNER = 114;
       Ord_WinQUERYCLIPBRDOWNER = 115;
       Ord_WinSETCLIPBRDDATA = 116;
       Ord_WinQUERYCLIPBRDDATA = 117;
       Ord_WinENUMCLIPBRDFMTS = 118;
       Ord_WinQUERYCLIPBRDFMTINFO = 119;
       Ord_WinSETCLIPBRDVIEWER = 120;
       Ord_WinQUERYCLIPBRDVIEWER = 121;
       Ord_WinLOADDLG = 122;
       Ord_WinCREATEDLG = 123;
       Ord_WinPROCESSDLG = 124;
       Ord_WinDLGBOX = 125;
       Ord_WinDISMISSDLG = 126;
       Ord_WinSENDDLGITEMMSG = 127;
       Ord_WinSETDLGITEMSHORT = 128;
       Ord_WinQUERYDLGITEMSHORT = 129;
       Ord_WinMAPDLGPOINTS = 130;
       Ord_WinSUBSTITUTESTRINGS = 132;
       Ord_WinENUMDLGITEM = 133;
       Ord_WinSETDLGITEMTEXT = 134;
       Ord_WinQUERYDLGITEMTEXT = 135;
       Ord_WinLOADMENU = 136;
       Ord_WinCREATEMENU = 137;
       Ord_WinALARM = 138;
       Ord_WinMESSAGEBOX = 139;
       Ord_WinCREATESTDWINDOW = 140;
       Ord_WinCREATEFRAMECONTROLS = 141;
       Ord_WinCALCFRAMERECT = 143;
       Ord_WinFLASHWINDOW = 144;
       Ord_WinGETMINPOSITION = 146;
       Ord_WinGETMAXPOSITION = 147;
       Ord_WinQUERYSYSVALUE = 149;
       Ord_WinSETSYSVALUE = 150;
       Ord_WinSETSYSCOLORS = 151;
       Ord_WinQUERYSYSCOLOR = 152;
       Ord_WinSCROLLWINDOW = 153;
       Ord_WinTRACKRECT = 154;
       Ord_WinSHOWTRACKRECT = 155;
       Ord_GpiLOADBITMAP = 156;
       Ord_WinLOADSTRING = 157;
       Ord_WinLOADMESSAGE = 158;
       Ord_WinSETRECTEMPTY = 159;
       Ord_WinSETRECT = 160;
       Ord_WinCOPYRECT = 161;
       Ord_WinISRECTEMPTY = 162;
       Ord_WinEQUALRECT = 163;
       Ord_WinPTINRECT = 164;
       Ord_WinOFFSETRECT = 165;
       Ord_WinINFLATERECT = 166;
       Ord_WinINTERSECTRECT = 167;
       Ord_WinUNIONRECT = 168;
       Ord_WinSUBTRACTRECT = 169;
       Ord_WinMAKERECT = 170;
       Ord_WinMAKEPOINTS = 171;
       Ord_WinINVERTRECT = 172;
       Ord_WinFILLRECT = 173;
       Ord_KbdPACKET = 174;
       Ord_WinDRAWPOINTER = 177;
       Ord_WinDEFWINDOWPROC = 178;
       Ord_WinDEFDLGPROC = 179;
       Ord_WinGETKEYSTATE = 211;
       Ord_WinGETPHYSKEYSTATE = 212;
       Ord_WinSETKEYBOARDSTATETABLE = 213;
       Ord_WinENABLEPHYSINPUT = 214;
       Ord_WinSETCP = 215;
       Ord_WinQUERYCP = 216;
       Ord_WinQUERYCPLIST = 217;
       Ord_WinCPTRANSLATESTRING = 218;
       Ord_WinCPTRANSLATECHAR = 219;
       Ord_WinCOMPARESTRINGS = 220;
       Ord_WinUPPER = 221;
       Ord_WinUPPERCHAR = 222;
       Ord_WinNEXTCHAR = 223;
       Ord_WinPREVCHAR = 224;
       Ord_WinCREATEHEAP = 225;
       Ord_WinDESTROYHEAP = 226;
       Ord_WinAVAILMEM = 227;
       Ord_WinALLOCMEM = 228;
       Ord_WinREALLOCMEM = 229;
       Ord_WinFREEMEM = 230;
       Ord_WinLOCKHEAP = 231;
       Ord_WinCREATEATOMTABLE = 233;
       Ord_WinDESTROYATOMTABLE = 234;
       Ord_WinADDATOM = 235;
       Ord_WinFINDATOM = 236;
       Ord_WinDELETEATOM = 237;
       Ord_WinQUERYATOMUSAGE = 238;
       Ord_WinQUERYATOMLENGTH = 239;
       Ord_WinQUERYATOMNAME = 240;
       Ord_WinQUERYSYSTEMATOMTABLE = 241;
       Ord_WinGETLASTERROR = 243;
       Ord_WinGETERRORINFO = 244;
       Ord_WinFREEERRORINFO = 245;
       Ord_WinINITIALIZE = 246;
       Ord_WinTERMINATE = 247;
       Ord_WinCATCH = 248;
       Ord_WinTHROW = 249;
       Ord_WinQUERYVERSION = 250;
       Ord__WinSETERRORINFO = 263;
       Ord_WinISPHYSINPUTENABLED = 264;
       Ord_WinQUERYWINDOWDC = 265;
       Ord_WinDRAWBORDER = 266;
       Ord_WinDRAWTEXT = 267;
       Ord_WinDRAWBITMAP = 268;
       Ord_WinQUERYWINDOWPTR = 269;
       Ord_WinSETWINDOWPTR = 270;
       Ord_WinMSGSEMWAIT = 274;
       Ord_WinMSGMUXSEMWAIT = 275;
       Ord_WinCANCELSHUTDOWN = 277;
       Ord_WinSETWINDOWBITS = 278;
       Ord_WinGETCLIPPS = 279;
       Ord_WinSAVEWINDOWPOS = 285;
       Ord_WinFOCUSCHANGE = 286;
       Ord_WinQUERYQUEUEINFO = 287;
       Ord_WinSETCLASSMSGINTEREST = 292;
       Ord_WinQUERYDLGITEMTEXTLENGTH = 294;
       Ord_WinDDEINITIATE = 297;
       Ord_WinDDERESPOND = 298;
       Ord_WinDDEPOSTMSG = 299;
       Ord_WinSETPRESPARAM = 301;
       Ord_WinQUERYPRESPARAM = 302;
       Ord_WinREMOVEPRESPARAM = 303;
       Ord_DumWinCREATEHELPINSTANCE = 311;
       Ord_DumWinDESTROYHELPINSTANCE = 312;
       Ord_DumWinASSOCIATEHELPINSTANCE = 313;
       Ord_DumWinCREATEHELPTABLE = 314;
       Ord_DumWinLOADHELPTABLE = 315;
       Ord_DumWinQUERYHELPINSTANCE = 316;
       Ord_DummyHelpEntry = 322;
       Ord_WinSETCLASSTHUNKPROC = 959;
       Ord_WinQUERYCLASSTHUNKPROC = 960;
       Ord_WinSETWINDOWTHUNKPROC = 961;
       Ord_WinQUERYWINDOWTHUNKPROC = 962;
       Ord_WinQUERYWINDOWMODEL = 317;
       Ord_WinSETDESKTOPBKGND = 318;
       Ord_WinQUERYDESKTOPBKGND = 319;
       Ord_WinPOPUPMENU = 320;
       Ord_WinREALIZEPALETTE = 321;
       Ord_WinDELETELIBRARY = 602;
       Ord_WinLOADPROCEDURE = 603;
       Ord_WinDELETEPROCEDURE = 604;
       Ord_WinSETMSGMODE = 605;
       Ord_WinSETSYNCHROMODE = 606;
       Ord_WinGETDLGMSG = 607;
       Ord_WinREGISTERUSERMSG = 608;
       Ord_WinQUERYANCHORBLOCK = 609;
       Ord_WinREGISTERUSERDATATYPE = 612;
       Ord_WinISWINDOWSHOWING = 614;
       Ord_WinLOADLIBRARY = 615;
       Ord_WinCREATEPOINTERINDIRECT = 616;
       Ord_WinQUERYPOINTERINFO = 617;
       Ord_WinGETERASEPS = 624;
       Ord_WinRELEASEERASEPS = 625;
       Ord_WinSTRETCHPOINTER = 632;
       Ord_WinSETPOINTEROWNER = 633;
       Ord_Win32ADDATOM = 700;
       Ord_Win32ALARM = 701;
       Ord_Win32BEGINENUMWINDOWS = 702;
       Ord_Win32BEGINPAINT = 703;
       Ord_Win32CALCFRAMERECT = 704;
       Ord_Win32CANCELSHUTDOWN = 705;
       Ord_Win32CLOSECLIPBRD = 707;
       Ord_Win32COMPARESTRINGS = 708;
       Ord_Win32COPYACCELTABLE = 709;
       Ord_Win32COPYRECT = 710;
       Ord_Win32CPTRANSLATECHAR = 711;
       Ord_Win32CPTRANSLATESTRING = 712;
       Ord_Win32CREATEACCELTABLE = 713;
       Ord_Win32CREATEATOMTABLE = 714;
       Ord_Win32CREATECURSOR = 715;
       Ord_Win32CREATEMSGQUEUE = 716;
       Ord_Win32CREATEPOINTER = 717;
       Ord_Win32DDEINITIATE = 718;
       Ord_Win32DDEPOSTMSG = 719;
       Ord_Win32DDERESPOND = 720;
       Ord_Win32DELETEATOM = 721;
       Ord_Win32DELETELIBRARY = 722;
       Ord_Win32DESTROYACCELTABLE = 723;
       Ord_Win32DESTROYATOMTABLE = 724;
       Ord_Win32DESTROYCURSOR = 725;
       Ord_Win32DESTROYMSGQUEUE = 726;
       Ord_Win32DESTROYPOINTER = 727;
       Ord_Win32DESTROYWINDOW = 728;
       Ord_Win32DISMISSDLG = 729;
       Ord_Win32DRAWBITMAP = 730;
       Ord_Win32DRAWBORDER = 731;
       Ord_Win32DRAWPOINTER = 732;
       Ord_Win32EMPTYCLIPBRD = 733;
       Ord_Win32ENABLEPHYSINPUT = 734;
       Ord_Win32ENABLEWINDOW = 735;
       Ord_Win32ENABLEWINDOWUPDATE = 736;
       Ord_Win32ENDENUMWINDOWS = 737;
       Ord_Win32ENDPAINT = 738;
       Ord_Win32ENUMCLIPBRDFMTS = 739;
       Ord_Win32ENUMDLGITEM = 740;
       Ord_Win32EQUALRECT = 741;
       Ord_Win32EXCLUDEUPDATEREGION = 742;
       Ord_Win32FILLRECT = 743;
       Ord_Win32FINDATOM = 744;
       Ord_Win32FLASHWINDOW = 745;
       Ord_Win32FOCUSCHANGE = 746;
       Ord_Win32FREEERRORINFO = 748;
       Ord_Win32GETCLIPPS = 749;
       Ord_Win32GETCURRENTTIME = 750;
       Ord_Win32GETERRORINFO = 751;
       Ord_Win32GETKEYSTATE = 752;
       Ord_Win32GETLASTERROR = 753;
       Ord_Win32GETMAXPOSITION = 754;
       Ord_Win32GETMINPOSITION = 755;
       Ord_Win32GETNEXTWINDOW = 756;
       Ord_Win32GETPS = 757;
       Ord_Win32GETPHYSKEYSTATE = 758;
       Ord_Win32GETSCREENPS = 759;
       Ord_Win32GETSYSBITMAP = 760;
       Ord_Win32INSENDMSG = 761;
       Ord_Win32INFLATERECT = 762;
       Ord_Win32INITIALIZE = 763;
       Ord_Win32INTERSECTRECT = 764;
       Ord_Win32INVALIDATERECT = 765;
       Ord_Win32INVALIDATEREGION = 766;
       Ord_Win32INVERTRECT = 767;
       Ord_Win32ISCHILD = 768;
       Ord_Win32ISPHYSINPUTENABLED = 769;
       Ord_Win32ISRECTEMPTY = 770;
       Ord_Win32ISTHREADACTIVE = 771;
       Ord_Win32ISWINDOW = 772;
       Ord_Win32ISWINDOWENABLED = 773;
       Ord_Win32ISWINDOWSHOWING = 774;
       Ord_Win32ISWINDOWVISIBLE = 775;
       Ord_Win32LOADACCELTABLE = 776;
       Ord_Win32LOADLIBRARY = 777;
       Ord_Win32LOADMENU = 778;
       Ord_Win32LOADMESSAGE = 779;
       Ord_Win32LOADPOINTER = 780;
       Ord_Win32LOADSTRING = 781;
       Ord_Win32LOCKVISREGIONS = 782;
       Ord_Win32LOCKWINDOWUPDATE = 784;
       Ord_Win32MAKEPOINTS = 785;
       Ord_Win32MAKERECT = 786;
       Ord_Win32MAPDLGPOINTS = 787;
       Ord_Win32MAPWINDOWPOINTS = 788;
       Ord_Win32MESSAGEBOX = 789;
       Ord_Win32MSGSEMWAIT = 790;
       Ord_Win32NEXTCHAR = 791;
       Ord_Win32OFFSETRECT = 792;
       Ord_Win32OPENCLIPBRD = 793;
       Ord_Win32OPENWINDOWDC = 794;
       Ord_Win32PREVCHAR = 795;
       Ord_Win32PROCESSDLG = 796;
       Ord_Win32PTINRECT = 797;
       Ord_Win32QUERYACCELTABLE = 798;
       Ord_Win32QUERYACTIVEWINDOW = 799;
       Ord_Win32QUERYANCHORBLOCK = 800;
       Ord_Win32QUERYATOMLENGTH = 801;
       Ord_Win32QUERYATOMNAME = 802;
       Ord_Win32QUERYATOMUSAGE = 803;
       Ord_Win32QUERYCAPTURE = 804;
       Ord_Win32QUERYCLASSNAME = 805;
       Ord_Win32QUERYCLIPBRDDATA = 806;
       Ord_Win32QUERYCLIPBRDFMTINFO = 807;
       Ord_Win32QUERYCLIPBRDOWNER = 808;
       Ord_Win32QUERYCLIPBRDVIEWER = 809;
       Ord_Win32QUERYCP = 810;
       Ord_Win32QUERYCPLIST = 811;
       Ord_Win32QUERYCURSORINFO = 812;
       Ord_Win32QUERYDESKTOPWINDOW = 813;
       Ord_Win32QUERYDLGITEMSHORT = 814;
       Ord_Win32QUERYDLGITEMTEXT = 815;
       Ord_Win32QUERYDLGITEMTEXTLENGTH = 816;
       Ord_Win32QUERYFOCUS = 817;
       Ord_Win32QUERYMSGPOS = 818;
       Ord_Win32QUERYMSGTIME = 819;
       Ord_Win32QUERYOBJECTWINDOW = 820;
       Ord_Win32QUERYPOINTER = 821;
       Ord_Win32QUERYPOINTERINFO = 822;
       Ord_Win32QUERYPOINTERPOS = 823;
       Ord_Win32QUERYQUEUEINFO = 824;
       Ord_Win32QUERYQUEUESTATUS = 825;
       Ord_Win32QUERYSYSCOLOR = 826;
       Ord_Win32QUERYSYSMODALWINDOW = 827;
       Ord_Win32QUERYSYSPOINTER = 828;
       Ord_Win32QUERYSYSVALUE = 829;
       Ord_Win32QUERYSYSTEMATOMTABLE = 830;
       Ord_Win32QUERYUPDATERECT = 831;
       Ord_Win32QUERYUPDATEREGION = 832;
       Ord_Win32QUERYVERSION = 833;
       Ord_Win32QUERYWINDOW = 834;
       Ord_Win32QUERYWINDOWDC = 835;
       Ord_Win32QUERYWINDOWPOS = 837;
       Ord_Win32QUERYWINDOWPROCESS = 838;
       Ord_Win32QUERYWINDOWPTR = 839;
       Ord_Win32QUERYWINDOWRECT = 840;
       Ord_Win32QUERYWINDOWTEXT = 841;
       Ord_Win32QUERYWINDOWTEXTLENGTH = 842;
       Ord_Win32QUERYWINDOWULONG = 843;
       Ord_Win32QUERYWINDOWUSHORT = 844;
       Ord_Win32REGISTERUSERDATATYPE = 845;
       Ord_Win32REGISTERUSERMSG = 846;
       Ord_Win32RELEASEPS = 848;
       Ord_Win32SCROLLWINDOW = 849;
       Ord_Win32SETACCELTABLE = 850;
       Ord_Win32SETACTIVEWINDOW = 851;
       Ord_Win32SETCAPTURE = 852;
       Ord_Win32SETCLASSMSGINTEREST = 853;
       Ord_Win32SETCLIPBRDDATA = 854;
       Ord_Win32SETCLIPBRDOWNER = 855;
       Ord_Win32SETCLIPBRDVIEWER = 856;
       Ord_Win32SETCP = 857;
       Ord_Win32SETDLGITEMSHORT = 858;
       Ord_Win32SETDLGITEMTEXT = 859;
       Ord_Win32SETFOCUS = 860;
       Ord_Win32SETMSGINTEREST = 861;
       Ord_Win32SETMSGMODE = 862;
       Ord_Win32SETMULTWINDOWPOS = 863;
       Ord_Win32SETOWNER = 864;
       Ord_Win32SETPARENT = 865;
       Ord_Win32SETPOINTER = 866;
       Ord_Win32SETPOINTERPOS = 867;
       Ord_Win32SETRECT = 868;
       Ord_Win32SETRECTEMPTY = 869;
       Ord_Win32SETSYNCHROMODE = 870;
       Ord_Win32SETSYSCOLORS = 871;
       Ord_Win32SETSYSMODALWINDOW = 872;
       Ord_Win32SETSYSVALUE = 873;
       Ord_Win32SETWINDOWBITS = 874;
       Ord_Win32SETWINDOWPOS = 875;
       Ord_Win32SETWINDOWPTR = 876;
       Ord_Win32SETWINDOWTEXT = 877;
       Ord_Win32SETWINDOWULONG = 878;
       Ord_Win32SETWINDOWUSHORT = 879;
       Ord_Win32SHOWCURSOR = 880;
       Ord_Win32SHOWPOINTER = 881;
       Ord_Win32SHOWTRACKRECT = 882;
       Ord_Win32SHOWWINDOW = 883;
       Ord_Win32STARTTIMER = 884;
       Ord_Win32STOPTIMER = 885;
       Ord_Win32SUBSTITUTESTRINGS = 886;
       Ord_Win32SUBTRACTRECT = 887;
       Ord_Win32TERMINATE = 888;
       Ord_Win32TRACKRECT = 890;
       Ord_Win32UNIONRECT = 891;
       Ord_Win32UPDATEWINDOW = 892;
       Ord_Win32UPPER = 893;
       Ord_Win32UPPERCHAR = 894;
       Ord_Win32VALIDATERECT = 895;
       Ord_Win32VALIDATEREGION = 896;
       Ord_Win32WAITMSG = 897;
       Ord_Win32WINDOWFROMDC = 898;
       Ord_Win32WINDOWFROMID = 899;
       Ord_Win32WINDOWFROMPOINT = 900;
       Ord_Win32BROADCASTMSG = 901;
       Ord_Win32POSTQUEUEMSG = 902;
       Ord_Win32SENDDLGITEMMSG = 903;
       Ord_Win32TRANSLATEACCEL = 904;
       Ord_Win32CALLMSGFILTER = 905;
       Ord_Win32CREATEFRAMECONTROLS = 906;
       Ord_Win32CREATEMENU = 907;
       Ord_Win32CREATESTDWINDOW = 908;
       Ord_Win32CREATEWINDOW = 909;
       Ord_Win32DEFDLGPROC = 910;
       Ord_Win32DEFWINDOWPROC = 911;
       Ord_Win32DISPATCHMSG = 912;
       Ord_Win32DRAWTEXT = 913;
       Ord_Win32GETDLGMSG = 914;
       Ord_Win32GETMSG = 915;
       Ord_Win32MSGMUXSEMWAIT = 916;
       Ord_Win32MULTWINDOWFROMIDS = 917;
       Ord_Win32PEEKMSG = 918;
       Ord_Win32POSTMSG = 919;
       Ord_Win32SENDMSG = 920;
       Ord_Win32SETKEYBOARDSTATETABLE = 921;
       Ord_Win32CREATEDLG = 922;
       Ord_Win32DLGBOX = 923;
       Ord_Win32LOADDLG = 924;
       Ord_Win32QUERYCLASSINFO = 925;
       Ord_Win32REGISTERCLASS = 926;
       Ord_Win32RELEASEHOOK = 927;
       Ord_Win32SETHOOK = 928;
       Ord_Win32SUBCLASSWINDOW = 929;
       Ord_Win32SETCLASSTHUNKPROC = 930;
       Ord_Win32QUERYCLASSTHUNKPROC = 931;
       Ord_Win32SETWINDOWTHUNKPROC = 932;
       Ord_Win32QUERYWINDOWTHUNKPROC = 933;
       Ord_Win32QUERYWINDOWMODEL = 934;
       Ord_Win32SETDESKTOPBKGND = 935;
       Ord_Win32QUERYDESKTOPBKGND = 936;
       Ord_Win32POPUPMENU = 937;
       Ord_Win32SETPRESPARAM = 938;
       Ord_Win32QUERYPRESPARAM = 939;
       Ord_Win32REMOVEPRESPARAM = 940;
       Ord_Win32REALIZEPALETTE = 941;
       Ord_Win32CREATEPOINTERINDIRECT = 942;
       Ord_Win32SAVEWINDOWPOS = 943;
       Ord_Win32GETERASEPS = 952;
       Ord_Win32RELEASEERASEPS = 953;
       Ord_Win32SETPOINTEROWNER = 971;
       Ord_Win32STRETCHPOINTER = 968;
       Ord_Win32SETERRORINFO = 977;
       Ord_Win32WAITEVENTSEM = 978;
       Ord_Win32REQUESTMUTEXSEM = 979;
       Ord_Win32WAITMUXWAITSEM = 980;
       Ord_PicPRINT = 1;
       Ord_PicICHG = 2;
       Ord_Pic32PRINT = 11;
       Ord_Pic32ICHG = 12;
       Ord_Prf32PIF2MET = 13;
       Ord_WinQUERYPROFILEINT = 2;
       Ord_WinQUERYPROFILESTRING = 3;
       Ord_WinWRITEPROFILESTRING = 4;
       Ord_WinQUERYPROFILESIZE = 5;
       Ord_WinQUERYPROFILEDATA = 6;
       Ord_WinWRITEPROFILEDATA = 7;
       Ord_WinINITSESSIONMGR = 8;
       Ord_WinSETFGNDWINDOW = 9;
       Ord_WinADDPROGRAM = 12;
       Ord_WinREMOVEPROGRAM = 13;
       Ord_WinCHANGEPROGRAM = 14;
       Ord_WinQUERYDEFINITION = 15;
       Ord_WinQUERYPROGRAMTITLES = 16;
       Ord_WinCREATEGROUP = 17;
       Ord_WinADDTOGROUP = 19;
       Ord_WinQUERYPROGRAMUSE = 20;
       Ord_WinREMOVEFROMGROUP = 21;
       Ord_WinDESTROYGROUP = 23;
       Ord_WinQUERYFILEEXTOPTS = 24;
       Ord_WinSETFILEEXTOPTS = 25;
       Ord_WinQUERYPROGRAMTYPE = 26;
       Ord_PrfQUERYPROFILEINT = 32;
       Ord_PrfQUERYPROFILESTRING = 33;
       Ord_PrfWRITEPROFILESTRING = 34;
       Ord_PrfQUERYPROFILESIZE = 35;
       Ord_PrfQUERYPROFILEDATA = 36;
       Ord_PrfWRITEPROFILEDATA = 37;
       Ord_PrfOPENPROFILE = 38;
       Ord_PrfCLOSEPROFILE = 39;
       Ord_PrfRESET = 42;
       Ord_PrfQUERYPROFILE = 43;
       Ord_WinINSTSTARTAPP = 44;
       Ord_WinTERMINATEAPP = 45;
       Ord_WinCREATESWITCHENTRY = 46;
       Ord_WinQUERYSESSIONTITLE = 47;
       Ord_WinADDSWITCHENTRY = 48;
       Ord_WinCHANGESWITCHENTRY = 49;
       Ord_PrfADDPROGRAM = 50;
       Ord_PrfREMOVEPROGRAM = 51;
       Ord_PrfCHANGEPROGRAM = 52;
       Ord_PrfQUERYDEFINITION = 53;
       Ord_PrfQUERYPROGRAMTITLES = 54;
       Ord_PrfCREATEGROUP = 55;
       Ord_WinQUERYSWITCHENTRY = 56;
       Ord_WinQUERYSWITCHHANDLE = 57;
       Ord_PrfQUERYPROGRAMHANDLE = 58;
       Ord_PrfQUERYPROGRAMCATEGORY = 59;
       Ord_PrfDESTROYGROUP = 60;
       Ord_WinQUERYTASKTITLE = 65;
       Ord_WinQUERYTASKSIZEPOS = 66;
       Ord_WinQUERYSWITCHLIST = 67;
       Ord_WinREMOVESWITCHENTRY = 68;
       Ord_WinSWITCHTOPROGRAM = 69;
       Ord_WinSWITCHPROGRAMREGISTER = 70;
       Ord_WinENDPROGRAM = 73;
       Ord_WinSTOPPROGRAM = 74;
       Ord_WinENDWINDOWSESSION = 75;
       Ord_WinSWITCHTOTASKMANAGER = 78;
       Ord_WinSWITCHTOPROGRAM2 = 80;
       Ord_WinPROCESSHOTKEY = 81;
       Ord_WinINITSESSION = 82;
       Ord_WinENDSESSION = 83;
       Ord_WinINITSWENTRY = 84;
       Ord_WinSETSWENTRY = 85;
       Ord_WinQUERYEXTIDFOCUS = 86;
       Ord_WinSETEXTIDFOCUS = 87;
       Ord_WinNOSHUTDOWN = 91;
       Ord_WinSETTITLE = 93;
       Ord_WinSETTITLEANDICON = 97;
       Ord_Prf32QUERYPROFILESIZE = 101;
       Ord_Prf32OPENPROFILE = 102;
       Ord_Prf32CLOSEPROFILE = 103;
       Ord_Prf32REMOVEPROGRAM = 104;
       Ord_Prf32DESTROYGROUP = 106;
       Ord_Prf32QUERYPROFILE = 107;
       Ord_Prf32RESET = 108;
       Ord_Prf32ADDPROGRAM = 109;
       Ord_Prf32CHANGEPROGRAM = 110;
       Ord_Prf32QUERYDEFINITION = 111;
       Ord_Prf32QUERYPROGRAMTITLES = 113;
       Ord_Prf32QUERYPROFILEINT = 114;
       Ord_Prf32QUERYPROFILESTRING = 115;
       Ord_Prf32WRITEPROFILESTRING = 116;
       Ord_Prf32QUERYPROFILEDATA = 117;
       Ord_Prf32WRITEPROFILEDATA = 118;
       Ord_Win32STARTAPP = 119;
       Ord_Win32ADDSWITCHENTRY = 120;
       Ord_Win32CREATESWITCHENTRY = 121;
       Ord_Win32QUERYSESSIONTITLE = 122;
       Ord_Win32CHANGESWITCHENTRY = 123;
       Ord_Win32QUERYSWITCHENTRY = 124;
       Ord_Win32QUERYSWITCHHANDLE = 125;
       Ord_Win32QUERYSWITCHLIST = 126;
       Ord_Win32QUERYTASKSIZEPOS = 127;
       Ord_Win32QUERYTASKTITLE = 128;
       Ord_Win32REMOVESWITCHENTRY = 129;
       Ord_Win32TERMINATEAPP = 130;
       Ord_Win32SWITCHTOPROGRAM = 131;
       Ord_Win32SWITCHPROGRAMREGISTER = 156;
       Ord_WinSTARTAPP = 201;
       Ord_WinHAPPFROMPID = 208;
       Ord_WinHSWITCHFROMHAPP = 209;
       Ord_DosREADQUEUE = 1;
       Ord_DosPURGEQUEUE = 2;
       Ord_DosCLOSEQUEUE = 3;
       Ord_DosQUERYQUEUE = 4;
       Ord_DosPEEKQUEUE = 5;
       Ord_DosWRITEQUEUE = 6;
       Ord_DosOPENQUEUE = 7;
       Ord_DosCREATEQUEUE = 8;
       Ord_Dos32READQUEUE = 9;
       Ord_Dos32PURGEQUEUE = 10;
       Ord_Dos32CLOSEQUEUE = 11;
       Ord_Dos32QUERYQUEUE = 12;
       Ord_Dos32PEEKQUEUE = 13;
       Ord_Dos32WRITEQUEUE = 14;
       Ord_Dos32OPENQUEUE = 15;
       Ord_Dos32CREATEQUEUE = 16;
       Ord_DosSTOPSESSION = 8;
       Ord_DosSELECTSESSION = 9;
       Ord_DosSETSESSION = 14;
       Ord_DosSTARTSESSION = 17;
       Ord_DosSMREGISTERDD = 29;
       Ord_Dos32STARTSESSION = 37;
       Ord_Dos32SELECTSESSION = 38;
       Ord_Dos32SETSESSION = 39;
       Ord_Dos32STOPSESSION = 40;
       Ord_WinFONTDLG = 2;
       Ord_WinDEFFONTDLGPROC = 3;
       Ord_WinFILEDLG = 4;
       Ord_WinDEFFILEDLGPROC = 5;
       Ord_WinFREEFILEDLGLIST = 6;
       Ord_VioENDPOPUP = 1;
       Ord_VioGETPHYSBUF = 2;
       Ord_VioGETANSI = 3;
       Ord_VioSETANSI = 5;
       Ord_VioDEREGISTER = 6;
       Ord_VioSCROLLUP = 7;
       Ord_VioPRTSC = 8;
       Ord_VioGETCURPOS = 9;
       Ord_VioWRTCELLSTR = 10;
       Ord_VioPOPUP = 11;
       Ord_VioSCROLLRT = 12;
       Ord_VioWRTCHARSTR = 13;
       Ord_VioSETCURPOS = 15;
       Ord_VioSCRUNLOCK = 18;
       Ord_VioWRTTTY = 19;
       Ord_VioGETMODE = 21;
       Ord_VioSETMODE = 22;
       Ord_VioSCRLOCK = 23;
       Ord_VioREADCELLSTR = 24;
       Ord_VioSAVREDRAWWAIT = 25;
       Ord_VioWRTNATTR = 26;
       Ord_VioGETCURTYPE = 27;
       Ord_VioSAVREDRAWUNDO = 28;
       Ord_VioGETFONT = 29;
       Ord_VioREADCHARSTR = 30;
       Ord_VioGETBUF = 31;
       Ord_VioSETCURTYPE = 32;
       Ord_VioSETFONT = 33;
       Ord_VioMODEUNDO = 35;
       Ord_VioMODEWAIT = 37;
       Ord_VioGETCP = 40;
       Ord_VioSETCP = 42;
       Ord_VioSHOWBUF = 43;
       Ord_VioSCROLLLF = 44;
       Ord_VioREGISTER = 45;
       Ord_VioGETCONFIG = 46;
       Ord_VioSCROLLDN = 47;
       Ord_VioWRTCHARSTRATT = 48;
       Ord_VioGETSTATE = 49;
       Ord_VioPRTSCTOGGLE = 50;
       Ord_VioSETSTATE = 51;
       Ord_VioWRTNCELL = 52;
       Ord_VioWRTNCHAR = 53;
       Ord_VioASSOCIATE = 55;
       Ord_VioCREATEPS = 56;
       Ord_VioDELETESETID = 57;
       Ord_VioGETDEVICECELLSIZE = 58;
       Ord_VioGETORG = 59;
       Ord_VioCREATELOGFONT = 60;
       Ord_VioDESTROYPS = 61;
       Ord_VioQUERYSETIDS = 62;
       Ord_VioSETORG = 63;
       Ord_VioQUERYFONTS = 64;
       Ord_VioSETDEVICECELLSIZE = 65;
       Ord_VioSHOWPS = 66;
       Ord_VioGETPSADDRESS = 67;
       Ord_VioGLOBALREG = 70;
       Ord_XVioSETCASTATE = 71;
       Ord_XVioCHECKCHARTYPE = 72;
       Ord_XVioDESTROYCA = 73;
       Ord_XVioCREATECA = 74;
       Ord_VioCHECKCHARTYPE = 75;
       Ord_XVioGETCASTATE = 76;
       Ord_WinDefAVioWindowProc = 30;

{ Declarations from bsedev.h header file (low-level device access) }
    const
       IOCTL_ASYNC = $0001;
       IOCTL_SCR_AND_PTRDRAW = $0003;
       IOCTL_KEYBOARD = $0004;
       IOCTL_PRINTER = $0005;
       IOCTL_LIGHTPEN = $0006;
       IOCTL_POINTINGDEVICE = $0007;
       IOCTL_DISK = $0008;
       IOCTL_PHYSICALDISK = $0009;
       IOCTL_MONITOR = $000A;
       IOCTL_GENERAL = $000B;
       ASYNC_SETBAUDRATE = $0041;
       ASYNC_SETLINECTRL = $0042;
       ASYNC_EXTSETBAUDRATE = $0043;
       ASYNC_SETEXTBAUDRATE = $0043;
       ASYNC_TRANSMITIMM = $0044;
       ASYNC_SETBREAKOFF = $0045;
       ASYNC_SETMODEMCTRL = $0046;
       ASYNC_SETBREAKON = $004B;
       ASYNC_STOPTRANSMIT = $0047;
       ASYNC_STARTTRANSMIT = $0048;
       ASYNC_SETDCBINFO = $0053;
       ASYNC_GETBAUDRATE = $0061;
       ASYNC_GETLINECTRL = $0062;
       ASYNC_EXTGETBAUDRATE = $0063;
       ASYNC_GETEXTBAUDRATE = $0063;
       ASYNC_GETCOMMSTATUS = $0064;
       ASYNC_GETLINESTATUS = $0065;
       ASYNC_GETMODEMOUTPUT = $0066;
       ASYNC_GETMODEMINPUT = $0067;
       ASYNC_GETINQUECOUNT = $0068;
       ASYNC_GETOUTQUECOUNT = $0069;
       ASYNC_GETCOMMERROR = $006D;
       ASYNC_GETCOMMEVENT = $0072;
       ASYNC_GETDCBINFO = $0073;
       SCR_ALLOCLDT = $0070;
       SCR_DEALLOCLDT = $0071;
       PTR_GETPTRDRAWADDRESS = $0072;
       SCR_ALLOCLDTOFF = $0075;
       KBD_SETTRANSTABLE = $0050;
       KBD_SETINPUTMODE = $0051;
       KBD_SETINTERIMFLAG = $0052;
       KBD_SETSHIFTSTATE = $0053;
       KBD_SETTYPAMATICRATE = $0054;
       KBD_SETFGNDSCREENGRP = $0055;
       KBD_SETSESMGRHOTKEY = $0056;
       KBD_SETFOCUS = $0057;
       KBD_SETKCB = $0058;
       KBD_SETNLS = $005C;
       KBD_CREATE = $005D;
       KBD_DESTROY = $005E;
       KBD_GETINPUTMODE = $0071;
       KBD_GETINTERIMFLAG = $0072;
       KBD_GETSHIFTSTATE = $0073;
       KBD_READCHAR = $0074;
       KBD_PEEKCHAR = $0075;
       KBD_GETSESMGRHOTKEY = $0076;
       KBD_GETKEYBDTYPE = $0077;
       KBD_GETCODEPAGEID = $0078;
       KBD_XLATESCAN = $0079;
       PRT_QUERYJOBHANDLE = $0021;
       PRT_SETFRAMECTL = $0042;
       PRT_SETINFINITERETRY = $0044;
       PRT_INITPRINTER = $0046;
       PRT_ACTIVATEFONT = $0048;
       PRT_GETFRAMECTL = $0062;
       PRT_GETINFINITERETRY = $0064;
       PRT_GETPRINTERSTATUS = $0066;
       PRT_QUERYACTIVEFONT = $0069;
       PRT_VERIFYFONT = $006A;
       MOU_ALLOWPTRDRAW = $0050;
       MOU_UPDATEDISPLAYMODE = $0051;
       MOU_SCREENSWITCH = $0052;
       MOU_SETSCALEFACTORS = $0053;
       MOU_SETEVENTMASK = $0054;
       MOU_SETHOTKEYBUTTON = $0055;
       MOU_SETPTRSHAPE = $0056;
       MOU_DRAWPTR = $0057;
       MOU_REMOVEPTR = $0058;
       MOU_SETPTRPOS = $0059;
       MOU_SETPROTDRAWADDRESS = $005A;
       MOU_SETREALDRAWADDRESS = $005B;
       MOU_SETMOUSTATUS = $005C;
       MOU_DISPLAYMODECHANGE = $005D;
       MOU_GETBUTTONCOUNT = $0060;
       MOU_GETMICKEYCOUNT = $0061;
       MOU_GETMOUSTATUS = $0062;
       MOU_READEVENTQUE = $0063;
       MOU_GETQUESTATUS = $0064;
       MOU_GETEVENTMASK = $0065;
       MOU_GETSCALEFACTORS = $0066;
       MOU_GETPTRPOS = $0067;
       MOU_GETPTRSHAPE = $0068;
       MOU_GETHOTKEYBUTTON = $0069;
       MOU_VER = $006A;
       DSK_LOCKDRIVE = $0000;
       DSK_UNLOCKDRIVE = $0001;
       DSK_REDETERMINEMEDIA = $0002;
       DSK_SETLOGICALMAP = $0003;
       DSK_BLOCKREMOVABLE = $0020;
       DSK_GETLOGICALMAP = $0021;
       DSK_SETDEVICEPARAMS = $0043;
       DSK_WRITETRACK = $0044;
       DSK_FORMATVERIFY = $0045;
       DSK_GETDEVICEPARAMS = $0063;
       DSK_READTRACK = $0064;
       DSK_VERIFYTRACK = $0065;
       PDSK_LOCKPHYSDRIVE = $0000;
       PDSK_UNLOCKPHYSDRIVE = $0001;
       PDSK_WRITEPHYSTRACK = $0044;
       PDSK_GETPHYSDEVICEPARAMS = $0063;
       PDSK_READPHYSTRACK = $0064;
       PDSK_VERIFYPHYSTRACK = $0065;
       MON_REGISTERMONITOR = $0040;
       DEV_FLUSHINPUT = $0001;
       DEV_FLUSHOUTPUT = $0002;
       DEV_QUERYMONSUPPORT = $0060;
       RX_QUE_OVERRUN = $0001;
       RX_HARDWARE_OVERRUN = $0002;
       PARITY_ERROR = $0004;
       FRAMING_ERROR = $0008;
       CHAR_RECEIVED = $0001;
       LAST_CHAR_SENT = $0004;
       CTS_CHANGED = $0008;
       DSR_CHANGED = $0010;
       DCD_CHANGED = $0020;
       BREAK_DETECTED = $0040;
       ERROR_OCCURRED = $0080;
       RI_DETECTED = $0100;
       TX_WAITING_FOR_CTS = $0001;
       TX_WAITING_FOR_DSR = $0002;
       TX_WAITING_FOR_DCD = $0004;
       TX_WAITING_FOR_XON = $0008;
       TX_WAITING_TO_SEND_XON = $0010;
       TX_WAITING_WHILE_BREAK_ON = $0020;
       TX_WAITING_TO_SEND_IMM = $0040;
       RX_WAITING_FOR_DSR = $0080;
       WRITE_REQUEST_QUEUED = $0001;
       DATA_IN_TX_QUE = $0002;
       HARDWARE_TRANSMITTING = $0004;
       CHAR_READY_TO_SEND_IMM = $0008;
       WAITING_TO_SEND_XON = $0010;
       WAITING_TO_SEND_XOFF = $0020;
       CTS_ON = $10;
       DSR_ON = $20;
       RI_ON = $40;
       DCD_ON = $80;
       BUILD_BPB_FROM_MEDIUM = $00;
       REPLACE_BPB_FOR_DEVICE = $01;
       REPLACE_BPB_FOR_MEDIUM = $02;
       ASCII_MODE = $00;
       BINARY_MODE = $80;
       CONVERSION_REQUEST = $20;
       INTERIM_CHAR = $80;
       HOTKEY_MAX_COUNT = $0000;
       HOTKEY_CURRENT_COUNT = $0001;
       KBD_DATA_RECEIVED = $0001;
       KBD_DATA_BINARY = $8000;
       KBD_READ_WAIT = $0000;
       KBD_READ_NOWAIT = $8000;
       SHIFT_REPORT_MODE = $01;
       MOUSE_MOTION = $0001;
       MOUSE_MOTION_WITH_BN1_DOWN = $0002;
       MOUSE_BN1_DOWN = $0004;
       MOUSE_MOTION_WITH_BN2_DOWN = $0008;
       MOUSE_BN2_DOWN = $0010;
       MOUSE_MOTION_WITH_BN3_DOWN = $0020;
       MOUSE_BN3_DOWN = $0040;
       MHK_BUTTON1 = $0001;
       MHK_BUTTON2 = $0002;
       MHK_BUTTON3 = $0004;
       MOU_NOWAIT = $0000;
       MOU_WAIT = $0001;
       MHK_NO_HOTKEY = $0000;
       MOUSE_QUEUEBUSY = $0001;
       MOUSE_BLOCKREAD = $0002;
       MOUSE_FLUSH = $0004;
       MOUSE_UNSUPPORTED_MODE = $0008;
       MOUSE_DISABLED = $0100;
       MOUSE_MICKEYS = $0200;
       PRINTER_TIMEOUT = $0001;
       PRINTER_IO_ERROR = $0008;
       PRINTER_SELECTED = $0010;
       PRINTER_OUT_OF_PAPER = $0020;
       PRINTER_ACKNOWLEDGED = $0040;
       PRINTER_NOT_BUSY = $0080;
       MODE_DTR_CONTROL = $01;
       MODE_DTR_HANDSHAKE = $02;
       MODE_CTS_HANDSHAKE = $08;
       MODE_DSR_HANDSHAKE = $10;
       MODE_DCD_HANDSHAKE = $20;
       MODE_DSR_SENSITIVITY = $40;
       MODE_AUTO_TRANSMIT = $01;
       MODE_AUTO_RECEIVE = $02;
       MODE_ERROR_CHAR = $04;
       MODE_NULL_STRIPPING = $08;
       MODE_BREAK_CHAR = $10;
       MODE_RTS_CONTROL = $40;
       MODE_RTS_HANDSHAKE = $80;
       MODE_TRANSMIT_TOGGLE = $C0;
       MODE_NO_WRITE_TIMEOUT = $01;
       MODE_READ_TIMEOUT = $02;
       MODE_WAIT_READ_TIMEOUT = $04;
       MODE_NOWAIT_READ_TIMEOUT = $06;

    type
       DCBINFO = record
          usWriteTimeout : word;
          usReadTimeout : word;
          fbCtlHndShake : byte;
          fbFlowReplace : byte;
          fbTimeout : byte;
          bErrorReplacementChar : byte;
          bBreakReplacementChar : byte;
          bXONChar : byte;
          bXOFFChar : byte;
       end;

       PDCBINFO = ^DCBINFO;
       TDCBInfo = DCBInfo;

    const
       DEVTYPE_48TPI = $0000;
       DEVTYPE_96TPI = $0001;
       DEVTYPE_35 = $0002;
       DEVTYPE_8SD = $0003;
       DEVTYPE_8DD = $0004;
       DEVTYPE_FIXED = $0005;
       DEVTYPE_TAPE = $0006;
       DEVTYPE_UNKNOWN = $0007;

{$PACKRECORDS 1}

    type
       BIOSPARAMETERBLOCK = record
          usBytesPerSector : word;
          bSectorsPerCluster : byte;
          usReservedSectors : word;
          cFATs : byte;
          cRootEntries : word;
          cSectors : word;
          bMedia : byte;
          usSectorsPerFAT : word;
          usSectorsPerTrack : word;
          cHeads : word;
          cHiddenSectors : cardinal;
          cLargeSectors : cardinal;
          abReserved : array[0..6-1] of byte;
          cCylinders : word;
          bDeviceType : byte;
          fsDeviceAttr : word;
       end;

       PBIOSPARAMETERBLOCK = ^BIOSPARAMETERBLOCK;
       TBIOSParameterBlock = BiosParameterBlock;

       SCREENGROUP = record
          idScreenGrp : word;
          fTerminate : word;
       end;

       PSCREENGROUP = ^SCREENGROUP;
       TScreenGroup = ScreenGroup;

       FRAME = record
          bCharsPerLine : byte;
          bLinesPerInch : byte;
       end;

       PFRAME = ^FRAME;
       TFrame = Frame;

       KBDTYPE = record
          usType : word;
          reserved1 : word;
          reserved2 : word;
       end;

       PKBDTYPE = ^KBDTYPE;
       TKbdType = KbdType;

       LINECONTROL = record
          bDataBits : byte;
          bParity : byte;
          bStopBits : byte;
          fTransBreak : byte;
       end;

       PLINECONTROL = ^LINECONTROL;
       TLineControl = LineControl;

    const
       DTR_ON = $01;
       RTS_ON = $02;
       DTR_OFF = $FE;
       RTS_OFF = $FD;

    type
       MODEMSTATUS = record
          fbModemOn : byte;
          fbModemOff : byte;
       end;

       PMODEMSTATUS = ^MODEMSTATUS;
       TModemStatus = ModemStatus;

       RXQUEUE = record
          cch : word;
          cb : word;
       end;

       PRXQUEUE = ^RXQUEUE;
       TRxQueue = RxQueue;

       DEVICEPARAMETERBLOCK = record
          reserved1 : word;
          cCylinders : word;
          cHeads : word;
          cSectorsPerTrack : word;
          reserved2 : word;
          reserved3 : word;
          reserved4 : word;
          reserved5 : word;
       end;

       PDEVICEPARAMETERBLOCK = ^DEVICEPARAMETERBLOCK;
       TDeviceParameterBlock = DeviceParameterBlock;

{$PACKRECORDS 2}

       PTRDRAWFUNCTION = record
          usReturnCode : word;
          pfnDraw : pointer;
          {!!!!!!!! pfnDraw : PFN; }
          pchDataSeg : pointer;
       end;

       PPTRDRAWFUNCTION = ^PTRDRAWFUNCTION;
       TPtrDrawFunction = PtrDrawFunction;

       PTRDRAWADDRESS = record
          reserved : word;
          ptrdfnc : PTRDRAWFUNCTION;
       end;

       PPTRDRAWADDRESS = ^PTRDRAWADDRESS;
       TPtrDrawAddress = PtrDrawAddress;

       SHIFTSTATE = record
          fsState : word;
          fNLS : byte;
       end;

       PSHIFTSTATE = ^SHIFTSTATE;
       TShiftState = ShiftState;

    const
       RIGHTSHIFT = $0001;
       LEFTSHIFT = $0002;
       CONTROL = $0004;
       ALT = $0008;
       SCROLLLOCK_ON = $0010;
       NUMLOCK_ON = $0020;
       CAPSLOCK_ON = $0040;
       INSERT_ON = $0080;
       LEFTCONTROL = $0100;
       LEFTALT = $0200;
       RIGHTCONTROL = $0400;
       RIGHTALT = $0800;
       SCROLLLOCK = $1000;
       NUMLOCK = $2000;
       CAPSLOCK = $4000;
       SYSREQ = $8000;

    type
       HOTKEY = record
          fsHotKey : word;
          uchScancodeMake : byte;
          uchScancodeBreak : byte;
          idHotKey : word;
       end;

       PHOTKEY = ^HOTKEY;
       THotKey = HotKey;

       MONITORPOSITION = record
          fPosition : word;
          index : word;
          pbInBuf : cardinal;
          offOutBuf : word;
       end;

       PMONITORPOSITION = ^MONITORPOSITION;
       TMonitorPosition = MonitorPosition;

       RATEDELAY = record
          usDelay : word;
          usRate : word;
       end;

       PRATEDELAY = ^RATEDELAY;
       TRateDelay = RateDelay;

       CODEPAGEINFO = record
          pbTransTable : PByte;
          idCodePage : word;
          idTable : word;
       end;

       PCODEPAGEINFO = ^CODEPAGEINFO;
       TCodePageInfo = CodePageInfo;

       CPID = record
          idCodePage : word;
          Reserved : word;
       end;

       PCPID = ^CPID;
       TCPID = CPID;

       LDTADDRINFO = record
          pulPhysAddr : PCardinal;
          cb : word;
       end;

       PLDTADDRINFO = ^LDTADDRINFO;
       TLDTAddrInfo = LDTAddrInfo;

       PTRDRAWDATA = record
          cb : word;
          usConfig : word;
          usFlag : word;
       end;

       PPTRDRAWDATA = ^PTRDRAWDATA;
       TPtrDrawData = PtrDrawData;

{$PACKRECORDS NORMAL}

{ Error constants from bseerr.h header file }

const
       No_Error = 0;
       Error_INVALID_FUNCTION = 1;
       Error_FILE_NOT_FOUND = 2;
       Error_PATH_NOT_FOUND = 3;
       Error_TOO_MANY_OPEN_FILES = 4;
       Error_ACCESS_DENIED = 5;
       Error_INVALID_HANDLE = 6;
       Error_ARENA_TRASHED = 7;
       Error_NOT_ENOUGH_MEMORY = 8;
       Error_INVALID_BLOCK = 9;
       Error_BAD_ENVIRONMENT = 10;
       Error_BAD_FORMAT = 11;
       Error_INVALID_ACCESS = 12;
       Error_INVALID_DATA = 13;
       Error_INVALID_DRIVE = 15;
       Error_CURRENT_DIRECTORY = 16;
       Error_NOT_SAME_DEVICE = 17;
       Error_NO_MORE_FILES = 18;
       Error_WRITE_PROTECT = 19;
       Error_BAD_UNIT = 20;
       Error_NOT_READY = 21;
       Error_BAD_COMMAND = 22;
       Error_CRC = 23;
       Error_BAD_LENGTH = 24;
       Error_SEEK = 25;
       Error_NOT_DOS_DISK = 26;
       Error_SECTOR_NOT_FOUND = 27;
       Error_OUT_OF_PAPER = 28;
       Error_WRITE_FAULT = 29;
       Error_READ_FAULT = 30;
       Error_GEN_FAILURE = 31;
       Error_SHARING_VIOLATION = 32;
       Error_LOCK_VIOLATION = 33;
       Error_WRONG_DISK = 34;
       Error_FCB_UNAVAILABLE = 35;
       Error_SHARING_BUFFER_EXCEEDED = 36;
       Error_CODE_PAGE_MISMATCHED = 37;
       Error_HANDLE_EOF = 38;
       Error_HANDLE_DISK_FULL = 39;
       Error_NOT_SUPPORTED = 50;
       Error_REM_NOT_LIST = 51;
       Error_DUP_NAME = 52;
       Error_BAD_NETPATH = 53;
       Error_NETWORK_BUSY = 54;
       Error_DEV_NOT_EXIST = 55;
       Error_TOO_MANY_CMDS = 56;
       Error_ADAP_HDW_ERR = 57;
       Error_BAD_NET_RESP = 58;
       Error_UNEXP_NET_ERR = 59;
       Error_BAD_REM_ADAP = 60;
       Error_PRINTQ_FULL = 61;
       Error_NO_SPOOL_SPACE = 62;
       Error_PRINT_CANCELLED = 63;
       Error_NETNAME_DELETED = 64;
       Error_NETWORK_ACCESS_DENIED = 65;
       Error_BAD_DEV_TYPE = 66;
       Error_BAD_NET_NAME = 67;
       Error_TOO_MANY_NAMES = 68;
       Error_TOO_MANY_SESS = 69;
       Error_SHARING_PAUSED = 70;
       Error_REQ_NOT_ACCEP = 71;
       Error_REDIR_PAUSED = 72;
       Error_SBCS_ATT_WRITE_PROT = 73;
       Error_SBCS_GENERAL_FAILURE = 74;
       Error_XGA_OUT_MEMORY = 75;
       Error_FILE_EXISTS = 80;
       Error_DUP_FCB = 81;
       Error_CANNOT_MAKE = 82;
       Error_FAIL_I24 = 83;
       Error_OUT_OF_STRUCTURES = 84;
       Error_ALREADY_ASSIGNED = 85;
       Error_INVALID_PASSWORD = 86;
       Error_INVALID_PARAMETER = 87;
       Error_NET_WRITE_FAULT = 88;
       Error_NO_PROC_SLOTS = 89;
       Error_NOT_FROZEN = 90;
       Error_SYS_COMP_NOT_LOADED = Error_NOT_FROZEN;
       ERR_TSTOVFL = 91;
       ERR_TSTDUP = 92;
       Error_NO_ITEMS = 93;
       Error_INTERRUPT = 95;
       Error_DEVICE_IN_USE = 99;
       Error_TOO_MANY_SEMAPHORES = 100;
       Error_EXCL_SEM_ALREADY_OWNED = 101;
       Error_SEM_IS_SET = 102;
       Error_TOO_MANY_SEM_REQUESTS = 103;
       Error_INVALID_AT_INTERRUPT_TIME = 104;
       Error_SEM_OWNER_DIED = 105;
       Error_SEM_USER_LIMIT = 106;
       Error_DISK_CHANGE = 107;
       Error_DRIVE_LOCKED = 108;
       Error_BROKEN_PIPE = 109;
       Error_OPEN_FAILED = 110;
       Error_BUFFER_OVERFLOW = 111;
       Error_DISK_FULL = 112;
       Error_NO_MORE_SEARCH_HANDLES = 113;
       Error_INVALID_TARGET_HANDLE = 114;
       Error_PROTECTION_VIOLATION = 115;
       Error_VIOKBD_REQUEST = 116;
       Error_INVALID_CATEGORY = 117;
       Error_INVALID_VERIFY_SWITCH = 118;
       Error_BAD_DRIVER_LEVEL = 119;
       Error_CALL_NOT_IMPLEMENTED = 120;
       Error_SEM_TIMEOUT = 121;
       Error_INSUFFICIENT_BUFFER = 122;
       Error_INVALID_NAME = 123;
       Error_INVALID_LEVEL = 124;
       Error_NO_VOLUME_LABEL = 125;
       Error_MOD_NOT_FOUND = 126;
       Error_PROC_NOT_FOUND = 127;
       Error_WAIT_NO_CHILDREN = 128;
       Error_CHILD_NOT_COMPLETE = 129;
       Error_DIRECT_ACCESS_HANDLE = 130;
       Error_NEGATIVE_SEEK = 131;
       Error_SEEK_ON_DEVICE = 132;
       Error_IS_JOIN_TARGET = 133;
       Error_IS_JOINED = 134;
       Error_IS_SUBSTED = 135;
       Error_NOT_JOINED = 136;
       Error_NOT_SUBSTED = 137;
       Error_JOIN_TO_JOIN = 138;
       Error_SUBST_TO_SUBST = 139;
       Error_JOIN_TO_SUBST = 140;
       Error_SUBST_TO_JOIN = 141;
       Error_BUSY_DRIVE = 142;
       Error_SAME_DRIVE = 143;
       Error_DIR_NOT_ROOT = 144;
       Error_DIR_NOT_EMPTY = 145;
       Error_IS_SUBST_PATH = 146;
       Error_IS_JOIN_PATH = 147;
       Error_PATH_BUSY = 148;
       Error_IS_SUBST_TARGET = 149;
       Error_SYSTEM_TRACE = 150;
       Error_INVALID_EVENT_COUNT = 151;
       Error_TOO_MANY_MUXWAITERS = 152;
       Error_INVALID_LIST_FORMAT = 153;
       Error_LABEL_TOO_LONG = 154;
       Error_TOO_MANY_TCBS = 155;
       Error_SIGNAL_REFUSED = 156;
       Error_DISCARDED = 157;
       Error_NOT_LOCKED = 158;
       Error_BAD_THREADID_ADDR = 159;
       Error_BAD_ARGUMENTS = 160;
       Error_BAD_PATHNAME = 161;
       Error_SIGNAL_PENDING = 162;
       Error_UNCERTAIN_MEDIA = 163;
       Error_MAX_THRDS_REACHED = 164;
       Error_MONITORS_NOT_SUPPORTED = 165;
       Error_UNC_DRIVER_NOT_INSTALLED = 166;
       Error_LOCK_FAILED = 167;
       Error_SWAPIO_FAILED = 168;
       Error_SWAPIN_FAILED = 169;
       Error_BUSY = 170;
       Error_CANCEL_VIOLATION = 173;
       Error_ATOMIC_LOCK_NOT_SUPPORTED = 174;
       Error_READ_LOCKS_NOT_SUPPORTED = 175;
       Error_INVALID_SEGMENT_NUMBER = 180;
       Error_INVALID_CALLGATE = 181;
       Error_INVALID_ORDINAL = 182;
       Error_ALREADY_EXISTS = 183;
       Error_NO_CHILD_PROCESS = 184;
       Error_CHILD_ALIVE_NOWAIT = 185;
       Error_INVALID_FLAG_NUMBER = 186;
       Error_SEM_NOT_FOUND = 187;
       Error_INVALID_STARTING_CODESEG = 188;
       Error_INVALID_STACKSEG = 189;
       Error_INVALID_MODULETYPE = 190;
       Error_INVALID_EXE_SIGNATURE = 191;
       Error_EXE_MARKED_INVALID = 192;
       Error_BAD_EXE_FORMAT = 193;
       Error_ITERATED_DATA_EXCEEDS_64k = 194;
       Error_INVALID_MINALLOCSIZE = 195;
       Error_DYNLINK_FROM_INVALID_RING = 196;
       Error_IOPL_NOT_ENABLED = 197;
       Error_INVALID_SEGDPL = 198;
       Error_AUTODATASEG_EXCEEDS_64k = 199;
       Error_RING2SEG_MUST_BE_MOVABLE = 200;
       Error_RELOC_CHAIN_XEEDS_SEGLIM = 201;
       Error_INFLOOP_IN_RELOC_CHAIN = 202;
       Error_ENVVAR_NOT_FOUND = 203;
       Error_NOT_CURRENT_CTRY = 204;
       Error_NO_SIGNAL_SENT = 205;
       Error_FILENAME_EXCED_RANGE = 206;
       Error_RING2_STACK_IN_USE = 207;
       Error_META_EXPANSION_TOO_LONG = 208;
       Error_INVALID_SIGNAL_NUMBER = 209;
       Error_THREAD_1_INACTIVE = 210;
       Error_INFO_NOT_AVAIL = 211;
       Error_LOCKED = 212;
       Error_BAD_DYNALINK = 213;
       Error_TOO_MANY_MODULES = 214;
       Error_NESTING_NOT_ALLOWED = 215;
       Error_CANNOT_SHRINK = 216;
       Error_ZOMBIE_PROCESS = 217;
       Error_STACK_IN_HIGH_MEMORY = 218;
       Error_INVALID_EXITROUTINE_RING = 219;
       Error_GETBUF_FAILED = 220;
       Error_FLUSHBUF_FAILED = 221;
       Error_TRANSFER_TOO_LONG = 222;
       Error_FORCENOSWAP_FAILED = 223;
       Error_SMG_NO_TARGET_WINDOW = 224;
       Error_NO_CHILDREN = 228;
       Error_INVALID_SCREEN_GROUP = 229;
       Error_BAD_PIPE = 230;
       Error_PIPE_BUSY = 231;
       Error_NO_DATA = 232;
       Error_PIPE_NOT_CONNECTED = 233;
       Error_MORE_DATA = 234;
       Error_VC_DISCONNECTED = 240;
       Error_CIRCULARITY_REQUESTED = 250;
       Error_DIRECTORY_IN_CDS = 251;
       Error_INVALID_FSD_NAME = 252;
       Error_INVALID_PATH = 253;
       Error_INVALID_EA_NAME = 254;
       Error_EA_LIST_INCONSISTENT = 255;
       Error_EA_LIST_TOO_LONG = 256;
       Error_NO_META_MATCH = 257;
       Error_FINDNOTIFY_TIMEOUT = 258;
       Error_NO_MORE_ITEMS = 259;
       Error_SEARCH_STRUC_REUSED = 260;
       Error_CHAR_NOT_FOUND = 261;
       Error_TOO_MUCH_STACK = 262;
       Error_INVALID_ATTR = 263;
       Error_INVALID_STARTING_RING = 264;
       Error_INVALID_DLL_INIT_RING = 265;
       Error_CANNOT_COPY = 266;
       Error_DIRECTORY = 267;
       Error_OPLOCKED_FILE = 268;
       Error_OPLOCK_THREAD_EXISTS = 269;
       Error_VOLUME_CHANGED = 270;
       Error_FINDNOTIFY_HANDLE_IN_USE = 271;
       Error_FINDNOTIFY_HANDLE_CLOSED = 272;
       Error_NOTIFY_OBJECT_REMOVED = 273;
       Error_ALREADY_SHUTDOWN = 274;
       Error_EAS_DIDNT_FIT = 275;
       Error_EA_FILE_CORRUPT = 276;
       Error_EA_TABLE_FULL = 277;
       Error_INVALID_EA_HANDLE = 278;
       Error_NO_CLUSTER = 279;
       Error_CREATE_EA_FILE = 280;
       Error_CANNOT_OPEN_EA_FILE = 281;
       Error_EAS_NOT_SUPPORTED = 282;
       Error_NEED_EAS_FOUND = 283;
       Error_DUPLICATE_HANDLE = 284;
       Error_DUPLICATE_NAME = 285;
       Error_EMPTY_MUXWAIT = 286;
       Error_MUTEX_OWNED = 287;
       Error_NOT_OWNER = 288;
       Error_PARAM_TOO_SMALL = 289;
       Error_TOO_MANY_HANDLES = 290;
       Error_TOO_MANY_OPENS = 291;
       Error_WRONG_TYPE = 292;
       Error_UNUSED_CODE = 293;
       Error_THREAD_NOT_TERMINATED = 294;
       Error_INIT_ROUTINE_FAILED = 295;
       Error_MODULE_IN_USE = 296;
       Error_NOT_ENOUGH_WATCHPOINTS = 297;
       Error_TOO_MANY_POSTS = 298;
       Error_ALREADY_POSTED = 299;
       Error_ALREADY_RESET = 300;
       Error_SEM_BUSY = 301;
       Error_USER_DEFINED_BASE = $FF00;
       Error_I24_WRITE_PROTECT = 0;
       Error_I24_BAD_UNIT = 1;
       Error_I24_NOT_READY = 2;
       Error_I24_BAD_COMMAND = 3;
       Error_I24_CRC = 4;
       Error_I24_BAD_LENGTH = 5;
       Error_I24_SEEK = 6;
       Error_I24_NOT_DOS_DISK = 7;
       Error_I24_SECTOR_NOT_FOUND = 8;
       Error_I24_OUT_OF_PAPER = 9;
       Error_I24_WRITE_FAULT = 10;
       Error_I24_READ_FAULT = 11;
       Error_I24_GEN_FAILURE = 12;
       Error_I24_DISK_CHANGE = 13;
       Error_I24_WRONG_DISK = 15;
       Error_I24_UNCERTAIN_MEDIA = 16;
       Error_I24_CHAR_CALL_INTERRUPTED = 17;
       Error_I24_NO_MONITOR_SUPPORT = 18;
       Error_I24_INVALID_PARAMETER = 19;
       Error_I24_DEVICE_IN_USE = 20;
       Error_I24_QUIET_INIT_FAIL = 21;
       ALLOWED_FAIL = $0001;
       ALLOWED_ABORT = $0002;
       ALLOWED_RETRY = $0004;
       ALLOWED_IGNORE = $0008;
       ALLOWED_ACKNOWLEDGE = $0010;
       ALLOWED_DISPATCH = $8000;
       ALLOWED_REGDUMP = $0020;
       ALLOWED_DETACHED = ALLOWED_DISPATCH;
       ALLOWED_RESERVED = not (ALLOWED_FAIL or ALLOWED_ABORT or ALLOWED_RETRY or ALLOWED_IGNORE or ALLOWED_ACKNOWLEDGE);
       I24_OPERATION = $01;
       I24_AREA = $06;
       I24_CLASS = $80;
       ERRCLASS_OUTRES = 1;
       ERRCLASS_TEMPSIT = 2;
       ERRCLASS_AUTH = 3;
       ERRCLASS_INTRN = 4;
       ERRCLASS_HRDFAIL = 5;
       ERRCLASS_SYSFAIL = 6;
       ERRCLASS_APPERR = 7;
       ERRCLASS_NOTFND = 8;
       ERRCLASS_BADFMT = 9;
       ERRCLASS_LOCKED = 10;
       ERRCLASS_MEDIA = 11;
       ERRCLASS_ALREADY = 12;
       ERRCLASS_UNK = 13;
       ERRCLASS_CANT = 14;
       ERRCLASS_TIME = 15;
       ERRACT_RETRY = 1;
       ERRACT_DLYRET = 2;
       ERRACT_USER = 3;
       ERRACT_ABORT = 4;
       ERRACT_PANIC = 5;
       ERRACT_IGNORE = 6;
       ERRACT_INTRET = 7;
       ERRLOC_UNK = 1;
       ERRLOC_DISK = 2;
       ERRLOC_NET = 3;
       ERRLOC_SERDEV = 4;
       ERRLOC_MEM = 5;
       TC_NORMAL = 0;
       TC_HARDERR = 1;
       TC_GP_TRAP = 2;
       TC_SIGNAL = 3;
       TC_XCPT = 4;
       Error_INVALID_PROCID = 303;
       Error_INVALID_PDELTA = 304;
       Error_NOT_DESCENDANT = 305;
       Error_NOT_SESSION_MANAGER = 306;
       Error_INVALID_PCLASS = 307;
       Error_INVALID_SCOPE = 308;
       Error_INVALID_THREADID = 309;
       Error_DOSSUB_SHRINK = 310;
       Error_DOSSUB_NOMEM = 311;
       Error_DOSSUB_OVERLAP = 312;
       Error_DOSSUB_BADSIZE = 313;
       Error_DOSSUB_BADFLAG = 314;
       Error_DOSSUB_BADSELECTOR = 315;
       Error_MR_MSG_TOO_LONG = 316;
       MGS_MR_MSG_TOO_LONG = 316;
       Error_MR_MID_NOT_FOUND = 317;
       Error_MR_UN_ACC_MSGF = 318;
       Error_MR_INV_MSGF_FORMAT = 319;
       Error_MR_INV_IVCOUNT = 320;
       Error_MR_UN_PERFORM = 321;
       Error_TS_WAKEUP = 322;
       Error_TS_SEMHANDLE = 323;
       Error_TS_NOTIMER = 324;
       Error_TS_HANDLE = 326;
       Error_TS_DATETIME = 327;
       Error_SYS_INTERNAL = 328;
       Error_QUE_CURRENT_NAME = 329;
       Error_QUE_PROC_NOT_OWNED = 330;
       Error_QUE_PROC_OWNED = 331;
       Error_QUE_DUPLICATE = 332;
       Error_QUE_ELEMENT_NOT_EXIST = 333;
       Error_QUE_NO_MEMORY = 334;
       Error_QUE_INVALID_NAME = 335;
       Error_QUE_INVALID_PRIORITY = 336;
       Error_QUE_INVALID_HANDLE = 337;
       Error_QUE_LINK_NOT_FOUND = 338;
       Error_QUE_MEMORY_Error = 339;
       Error_QUE_PREV_AT_END = 340;
       Error_QUE_PROC_NO_ACCESS = 341;
       Error_QUE_EMPTY = 342;
       Error_QUE_NAME_NOT_EXIST = 343;
       Error_QUE_NOT_INITIALIZED = 344;
       Error_QUE_UNABLE_TO_ACCESS = 345;
       Error_QUE_UNABLE_TO_ADD = 346;
       Error_QUE_UNABLE_TO_INIT = 347;
       Error_VIO_INVALID_MASK = 349;
       Error_VIO_PTR = 350;
       Error_VIO_APTR = 351;
       Error_VIO_RPTR = 352;
       Error_VIO_CPTR = 353;
       Error_VIO_LPTR = 354;
       Error_VIO_MODE = 355;
       Error_VIO_WIDTH = 356;
       Error_VIO_ATTR = 357;
       Error_VIO_ROW = 358;
       Error_VIO_COL = 359;
       Error_VIO_TOPROW = 360;
       Error_VIO_BOTROW = 361;
       Error_VIO_RIGHTCOL = 362;
       Error_VIO_LEFTCOL = 363;
       Error_SCS_CALL = 364;
       Error_SCS_VALUE = 365;
       Error_VIO_WAIT_FLAG = 366;
       Error_VIO_UNLOCK = 367;
       Error_SGS_NOT_SESSION_MGR = 368;
       Error_SMG_INVALID_SGID = 369;
       Error_SMG_INVALID_SESSION_ID = Error_SMG_INVALID_SGID;
       Error_SMG_NOSG = 370;
       Error_SMG_NO_SESSIONS = 370;
       Error_SMG_GRP_NOT_FOUND = 371;
       Error_SMG_SESSION_NOT_FOUND = Error_SMG_GRP_NOT_FOUND;
       Error_SMG_SET_TITLE = 372;
       Error_KBD_PARAMETER = 373;
       Error_KBD_NO_DEVICE = 374;
       Error_KBD_INVALID_IOWAIT = 375;
       Error_KBD_INVALID_LENGTH = 376;
       Error_KBD_INVALID_ECHO_MASK = 377;
       Error_KBD_INVALID_INPUT_MASK = 378;
       Error_MON_INVALID_PARMS = 379;
       Error_MON_INVALID_DEVNAME = 380;
       Error_MON_INVALID_HANDLE = 381;
       Error_MON_BUFFER_TOO_SMALL = 382;
       Error_MON_BUFFER_EMPTY = 383;
       Error_MON_DATA_TOO_LARGE = 384;
       Error_MOUSE_NO_DEVICE = 385;
       Error_MOUSE_INV_HANDLE = 386;
       Error_MOUSE_INV_PARMS = 387;
       Error_MOUSE_CANT_RESET = 388;
       Error_MOUSE_DISPLAY_PARMS = 389;
       Error_MOUSE_INV_MODULE = 390;
       Error_MOUSE_INV_ENTRY_PT = 391;
       Error_MOUSE_INV_MASK = 392;
       NO_Error_MOUSE_NO_DATA = 393;
       NO_Error_MOUSE_PTR_DRAWN = 394;
       Error_INVALID_FREQUENCY = 395;
       Error_NLS_NO_COUNTRY_FILE = 396;
       Error_NLS_OPEN_FAILED = 397;
       Error_NLS_NO_CTRY_CODE = 398;
       Error_NO_COUNTRY_OR_CODEPAGE = 398;
       Error_NLS_TABLE_TRUNCATED = 399;
       Error_NLS_BAD_TYPE = 400;
       Error_NLS_TYPE_NOT_FOUND = 401;
       Error_VIO_SMG_ONLY = 402;
       Error_VIO_INVALID_ASCIIZ = 403;
       Error_VIO_DEREGISTER = 404;
       Error_VIO_NO_POPUP = 405;
       Error_VIO_EXISTING_POPUP = 406;
       Error_KBD_SMG_ONLY = 407;
       Error_KBD_INVALID_ASCIIZ = 408;
       Error_KBD_INVALID_MASK = 409;
       Error_KBD_REGISTER = 410;
       Error_KBD_DEREGISTER = 411;
       Error_MOUSE_SMG_ONLY = 412;
       Error_MOUSE_INVALID_ASCIIZ = 413;
       Error_MOUSE_INVALID_MASK = 414;
       Error_MOUSE_REGISTER = 415;
       Error_MOUSE_DEREGISTER = 416;
       Error_SMG_BAD_ACTION = 417;
       Error_SMG_INVALID_CALL = 418;
       Error_SCS_SG_NOTFOUND = 419;
       Error_SCS_NOT_SHELL = 420;
       Error_VIO_INVALID_PARMS = 421;
       Error_VIO_FUNCTION_OWNED = 422;
       Error_VIO_RETURN = 423;
       Error_SCS_INVALID_FUNCTION = 424;
       Error_SCS_NOT_SESSION_MGR = 425;
       Error_VIO_REGISTER = 426;
       Error_VIO_NO_MODE_THREAD = 427;
       Error_VIO_NO_SAVE_RESTORE_THD = 428;
       Error_VIO_IN_BG = 429;
       Error_VIO_ILLEGAL_DURING_POPUP = 430;
       Error_SMG_NOT_BASESHELL = 431;
       Error_SMG_BAD_STATUSREQ = 432;
       Error_QUE_INVALID_WAIT = 433;
       Error_VIO_LOCK = 434;
       Error_MOUSE_INVALID_IOWAIT = 435;
       Error_VIO_INVALID_HANDLE = 436;
       Error_VIO_ILLEGAL_DURING_LOCK = 437;
       Error_VIO_INVALID_LENGTH = 438;
       Error_KBD_INVALID_HANDLE = 439;
       Error_KBD_NO_MORE_HANDLE = 440;
       Error_KBD_CANNOT_CREATE_KCB = 441;
       Error_KBD_CODEPAGE_LOAD_INCOMPL = 442;
       Error_KBD_INVALID_CODEPAGE_ID = 443;
       Error_KBD_NO_CODEPAGE_SUPPORT = 444;
       Error_KBD_FOCUS_REQUIRED = 445;
       Error_KBD_FOCUS_ALREADY_ACTIVE = 446;
       Error_KBD_KEYBOARD_BUSY = 447;
       Error_KBD_INVALID_CODEPAGE = 448;
       Error_KBD_UNABLE_TO_FOCUS = 449;
       Error_SMG_SESSION_NON_SELECT = 450;
       Error_SMG_SESSION_NOT_FOREGRND = 451;
       Error_SMG_SESSION_NOT_PARENT = 452;
       Error_SMG_INVALID_START_MODE = 453;
       Error_SMG_INVALID_RELATED_OPT = 454;
       Error_SMG_INVALID_BOND_OPTION = 455;
       Error_SMG_INVALID_SELECT_OPT = 456;
       Error_SMG_START_IN_BACKGROUND = 457;
       Error_SMG_INVALID_STOP_OPTION = 458;
       Error_SMG_BAD_RESERVE = 459;
       Error_SMG_PROCESS_NOT_PARENT = 460;
       Error_SMG_INVALID_DATA_LENGTH = 461;
       Error_SMG_NOT_BOUND = 462;
       Error_SMG_RETRY_SUB_ALLOC = 463;
       Error_KBD_DETACHED = 464;
       Error_VIO_DETACHED = 465;
       Error_MOU_DETACHED = 466;
       Error_VIO_FONT = 467;
       Error_VIO_USER_FONT = 468;
       Error_VIO_BAD_CP = 469;
       Error_VIO_NO_CP = 470;
       Error_VIO_NA_CP = 471;
       Error_INVALID_CODE_PAGE = 472;
       Error_CPLIST_TOO_SMALL = 473;
       Error_CP_NOT_MOVED = 474;
       Error_MODE_SWITCH_INIT = 475;
       Error_CODE_PAGE_NOT_FOUND = 476;
       Error_UNEXPECTED_SLOT_RETURNED = 477;
       Error_SMG_INVALID_TRACE_OPTION = 478;
       Error_VIO_INTERNAL_RESOURCE = 479;
       Error_VIO_SHELL_INIT = 480;
       Error_SMG_NO_HARD_ErrorS = 481;
       Error_CP_SWITCH_INCOMPLETE = 482;
       Error_VIO_TRANSPARENT_POPUP = 483;
       Error_CRITSEC_OVERFLOW = 484;
       Error_CRITSEC_UNDERFLOW = 485;
       Error_VIO_BAD_RESERVE = 486;
       Error_INVALID_ADDRESS = 487;
       Error_ZERO_SELECTORS_REQUESTED = 488;
       Error_NOT_ENOUGH_SELECTORS_AVA = 489;
       Error_INVALID_SELECTOR = 490;
       Error_SMG_INVALID_PROGRAM_TYPE = 491;
       Error_SMG_INVALID_PGM_CONTROL = 492;
       Error_SMG_INVALID_INHERIT_OPT = 493;
       Error_VIO_EXTENDED_SG = 494;
       Error_VIO_NOT_PRES_MGR_SG = 495;
       Error_VIO_SHIELD_OWNED = 496;
       Error_VIO_NO_MORE_HANDLES = 497;
       Error_VIO_SEE_Error_LOG = 498;
       Error_VIO_ASSOCIATED_DC = 499;
       Error_KBD_NO_CONSOLE = 500;
       Error_MOUSE_NO_CONSOLE = 501;
       Error_MOUSE_INVALID_HANDLE = 502;
       Error_SMG_INVALID_DEBUG_PARMS = 503;
       Error_KBD_EXTENDED_SG = 504;
       Error_MOU_EXTENDED_SG = 505;
       Error_SMG_INVALID_ICON_FILE = 506;
       Error_TRC_PID_NON_EXISTENT = 507;
       Error_TRC_COUNT_ACTIVE = 508;
       Error_TRC_SUSPENDED_BY_COUNT = 509;
       Error_TRC_COUNT_INACTIVE = 510;
       Error_TRC_COUNT_REACHED = 511;
       Error_NO_MC_TRACE = 512;
       Error_MC_TRACE = 513;
       Error_TRC_COUNT_ZERO = 514;
       Error_SMG_TOO_MANY_DDS = 515;
       Error_SMG_INVALID_NOTIFICATION = 516;
       Error_LF_INVALID_FUNCTION = 517;
       Error_LF_NOT_AVAIL = 518;
       Error_LF_SUSPENDED = 519;
       Error_LF_BUF_TOO_SMALL = 520;
       Error_LF_BUFFER_CORRUPTED = 521;
       Error_LF_BUFFER_FULL = 521;
       Error_LF_INVALID_DAEMON = 522;
       Error_LF_INVALID_RECORD = 522;
       Error_LF_INVALID_TEMPL = 523;
       Error_LF_INVALID_SERVICE = 523;
       Error_LF_GENERAL_FAILURE = 524;
       Error_LF_INVALID_ID = 525;
       Error_LF_INVALID_HANDLE = 526;
       Error_LF_NO_ID_AVAIL = 527;
       Error_LF_TEMPLATE_AREA_FULL = 528;
       Error_LF_ID_IN_USE = 529;
       Error_MOU_NOT_INITIALIZED = 530;
       Error_MOUINITREAL_DONE = 531;
       Error_DOSSUB_CORRUPTED = 532;
       Error_MOUSE_CALLER_NOT_SUBSYS = 533;
       Error_ARITHMETIC_OVERFLOW = 534;
       Error_TMR_NO_DEVICE = 535;
       Error_TMR_INVALID_TIME = 536;
       Error_PVW_INVALID_ENTITY = 537;
       Error_PVW_INVALID_ENTITY_TYPE = 538;
       Error_PVW_INVALID_SPEC = 539;
       Error_PVW_INVALID_RANGE_TYPE = 540;
       Error_PVW_INVALID_COUNTER_BLK = 541;
       Error_PVW_INVALID_TEXT_BLK = 542;
       Error_PRF_NOT_INITIALIZED = 543;
       Error_PRF_ALREADY_INITIALIZED = 544;
       Error_PRF_NOT_STARTED = 545;
       Error_PRF_ALREADY_STARTED = 546;
       Error_PRF_TIMER_OUT_OF_RANGE = 547;
       Error_PRF_TIMER_RESET = 548;
       Error_VDD_LOCK_USEAGE_DENIED = 639;
       Error_TIMEOUT = 640;
       Error_VDM_DOWN = 641;
       Error_VDM_LIMIT = 642;
       Error_VDD_NOT_FOUND = 643;
       Error_INVALID_CALLER = 644;
       Error_PID_MISMATCH = 645;
       Error_INVALID_VDD_HANDLE = 646;
       Error_VLPT_NO_SPOOLER = 647;
       Error_VCOM_DEVICE_BUSY = 648;
       Error_VLPT_DEVICE_BUSY = 649;
       Error_NESTING_TOO_DEEP = 650;
       Error_VDD_MISSING = 651;
       Error_BIDI_INVALID_LENGTH = 671;
       Error_BIDI_INVALID_INCREMENT = 672;
       Error_BIDI_INVALID_COMBINATION = 673;
       Error_BIDI_INVALID_RESERVED = 674;
       Error_BIDI_INVALID_EFFECT = 675;
       Error_BIDI_INVALID_CSDREC = 676;
       Error_BIDI_INVALID_CSDSTATE = 677;
       Error_BIDI_INVALID_LEVEL = 678;
       Error_BIDI_INVALID_TYPE_SUPPORT = 679;
       Error_BIDI_INVALID_ORIENTATION = 680;
       Error_BIDI_INVALID_NUM_SHAPE = 681;
       Error_BIDI_INVALID_CSD = 682;
       Error_BIDI_NO_SUPPORT = 683;
       NO_Error_BIDI_RW_INCOMPLETE = 684;
       Error_IMP_INVALID_PARM = 691;
       Error_IMP_INVALID_LENGTH = 692;
       MSG_HPFS_DISK_Error_WARN = 693;
       Error_MON_BAD_BUFFER = 730;
       Error_MODULE_CORRUPTED = 731;
       Error_SM_OUTOF_SWAPFILE = 1477;
       Error_LF_TIMEOUT = 2055;
       Error_LF_SUSPEND_SUCCESS = 2057;
       Error_LF_RESUME_SUCCESS = 2058;
       Error_LF_REDIRECT_SUCCESS = 2059;
       Error_LF_REDIRECT_FAILURE = 2060;
       Error_SWAPPER_NOT_ACTIVE = 32768;
       Error_INVALID_SWAPID = 32769;
       Error_IOERR_SWAP_FILE = 32770;
       Error_SWAP_TABLE_FULL = 32771;
       Error_SWAP_FILE_FULL = 32772;
       Error_CANT_INIT_SWAPPER = 32773;
       Error_SWAPPER_ALREADY_INIT = 32774;
       Error_PMM_INSUFFICIENT_MEMORY = 32775;
       Error_PMM_INVALID_FLAGS = 32776;
       Error_PMM_INVALID_ADDRESS = 32777;
       Error_PMM_LOCK_FAILED = 32778;
       Error_PMM_UNLOCK_FAILED = 32779;
       Error_PMM_MOVE_INCOMPLETE = 32780;
       Error_UCOM_DRIVE_RENAMED = 32781;
       Error_UCOM_FILENAME_TRUNCATED = 32782;
       Error_UCOM_BUFFER_LENGTH = 32783;
       Error_MON_CHAIN_HANDLE = 32784;
       Error_MON_NOT_REGISTERED = 32785;
       Error_SMG_ALREADY_TOP = 32786;
       Error_PMM_ARENA_MODIFIED = 32787;
       Error_SMG_PRINTER_OPEN = 32788;
       Error_PMM_SET_FLAGS_FAILED = 32789;
       Error_INVALID_DOS_DD = 32790;
       Error_BLOCKED = 32791;
       Error_NOBLOCK = 32792;
       Error_INSTANCE_SHARED = 32793;
       Error_NO_OBJECT = 32794;
       Error_PARTIAL_ATTACH = 32795;
       Error_INCACHE = 32796;
       Error_SWAP_IO_PROBLEMS = 32797;
       Error_CROSSES_OBJECT_BOUNDARY = 32798;
       Error_LONGLOCK = 32799;
       Error_SHORTLOCK = 32800;
       Error_UVIRTLOCK = 32801;
       Error_ALIASLOCK = 32802;
       Error_ALIAS = 32803;
       Error_NO_MORE_HANDLES = 32804;
       Error_SCAN_TERMINATED = 32805;
       Error_TERMINATOR_NOT_FOUND = 32806;
       Error_NOT_DIRECT_CHILD = 32807;
       Error_DELAY_FREE = 32808;
       Error_GUARDPAGE = 32809;
       Error_SWAPError = 32900;
       Error_LDRError = 32901;
       Error_NOMEMORY = 32902;
       Error_NOACCESS = 32903;
       Error_NO_DLL_TERM = 32904;
       Error_CPSIO_CODE_PAGE_INVALID = 65026;
       Error_CPSIO_NO_SPOOLER = 65027;
       Error_CPSIO_FONT_ID_INVALID = 65028;
       Error_CPSIO_INTERNAL_Error = 65033;
       Error_CPSIO_INVALID_PTR_NAME = 65034;
       Error_CPSIO_NOT_ACTIVE = 65037;
       Error_CPSIO_PID_FULL = 65039;
       Error_CPSIO_PID_NOT_FOUND = 65040;
       Error_CPSIO_READ_CTL_SEQ = 65043;
       Error_CPSIO_READ_FNT_DEF = 65045;
       Error_CPSIO_WRITE_Error = 65047;
       Error_CPSIO_WRITE_FULL_Error = 65048;
       Error_CPSIO_WRITE_HANDLE_BAD = 65049;
       Error_CPSIO_SWIT_LOAD = 65074;
       Error_CPSIO_INV_COMMAND = 65077;
       Error_CPSIO_NO_FONT_SWIT = 65078;
       Error_ENTRY_IS_CALLGATE = 65079;

{ Constants from bsememf.h header file (memory management) }

    const
       PAG_READ         = $00000001;
       PAG_WRITE        = $00000002;
       PAG_EXECUTE      = $00000004;
       PAG_GUARD        = $00000008;
       PAG_COMMIT       = $00000010;
       PAG_DECOMMIT     = $00000020;
       OBJ_TILE         = $00000040;
       OBJ_PROTECTED    = $00000080;
       OBJ_GETTABLE     = $00000100;
       OBJ_GIVEABLE     = $00000200;
       PAG_DEFAULT      = $00000400;
       PAG_SHARED       = $00002000;
       PAG_FREE         = $00004000;
       PAG_BASE         = $00010000;

       fPERM = (PAG_EXECUTE or PAG_READ or PAG_WRITE);
       fSHARE = (OBJ_GETTABLE or OBJ_GIVEABLE);
       fALLOC = (OBJ_TILE or PAG_COMMIT or fPERM);
       fALLOCSHR = (OBJ_TILE or PAG_COMMIT or fSHARE or fPERM);
       fGETNMSHR = (fPERM);
       fGETSHR = (fPERM);
       fGIVESHR = (fPERM);
       fSET = (PAG_COMMIT+PAG_DECOMMIT+PAG_DEFAULT+fPERM);

       DOSSUB_INIT          = $01;
       DOSSUB_GROW          = $02;
       DOSSUB_SPARSE_OBJ    = $04;
       DOSSUB_SERIALIZE     = $08;


  implementation

end.
{
  $Log: os2def.pas,v $
  Revision 1.1.2.4  2002/11/04 21:24:16  hajny
    * PointL definition correction

  Revision 1.1.2.3  2001/01/03 20:07:08  hajny
    * some more compatibility additions (HEv, HMtx, ...)

  Revision 1.1.2.2  2000/09/24 19:55:54  hajny
    * Fixed type specification added for compatibility reasons

  Revision 1.1.2.1  2000/09/03 18:22:05  hajny
    + bsedev, bseerr, bsememf and bseord merged into OS2Def

  Revision 1.1  2000/07/13 06:31:06  michael
  + Initial import

  Revision 1.10  2000/01/09 20:48:04  hajny
    * FPK changed to FPC

  Revision 1.9  2000/01/07 16:41:48  daniel
    * copyright 2000

  Revision 1.8  2000/01/07 16:32:32  daniel
    * copyright 2000 added

  Revision 1.7  1999/08/10 14:20:54  hajny
    * compatibility updates

  Revision 1.6  1999/08/05 07:37:27  hajny
    * 'solution' for a compiler problem

}
