{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2001 by the Free Pascal development team

    This include file contains the declarations for variants
    support in FPC

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}
const
   varempty = 0;
   varnull = 1;
   varsmallint = 2;
   varinteger = 3;
   varsingle = 4;
   vardouble = 5;
   varcurrency = 6;
   vardate = 7;
   varolestr = 8;
   vardispatch = 9;
   varerror = 10;
   varboolean = 11;
   varvariant = 12;
   varunknown = 13;
   vardecimal = 14;
   varshortint = 16;
   varbyte = 17;
   varword = 18;
   varlongword = 19;
   varint64 = 20;
   varqword = 21;

   varstrarg = $48;
   varstring = $100;
   varany = $101;
   vartypemask = $fff;
   vararray = $2000;
   varbyref = $4000;

   varword64 = varqword;

type
   tvartype = word;

   pvararrayboundarray = ^tvararrayboundarray;
   pvararraycoorarray = ^tvararraycoorarray;
   pvararraybound = ^tvararraybound;
   pvararray = ^tvararray;

   tvararraybound = packed record
     elementcount,lowbound  : SizeInt;
   end;

   tvararrayboundarray = array[0..0] of tvararraybound;
   tvararraycoorarray = array[0..0] of SizeInt;

   tvararray = packed record
      dimcount,flags : word;
      elementsize : ptrint;
      lockcount : longint;
      data : pointer;
      bounds : tvararrayboundarray;
   end;


   tvarop = (opadd,opsubtract,opmultiply,opdivide,opintdivide,opmodulus,
             opshiftleft,opshiftright,opand,opor,opxor,opcompare,opnegate,
             opnot,opcmpeq,opcmpne,opcmplt,opcmple,opcmpgt,opcmpge,oppower);

   tvardata = packed record
      vtype : tvartype;
      case integer of
         0:(res1 : word;
            case integer of
               0:
                 (res2,res3 : word;
                  case word of
                     varsmallint : (vsmallint : smallint);
                     varinteger : (vinteger : longint);
                     varsingle : (vsingle : single);
                     vardouble : (vdouble : double);
                     varcurrency : (vcurrency : currency);
                     vardate : (vdate : tdatetime);
                     varolestr : (volestr : pwidechar);
                     vardispatch : (vdispatch : pointer);
                     varerror : (verror : hresult);
                     varboolean : (vboolean : wordbool);
                     varunknown : (vunknown : pointer);
                     // vardecimal : ( : );
                     varshortint : (vshortint : shortint);
                     varbyte : (vbyte : byte);
                     varword : (vword : word);
                     varlongword : (vlongword : dword);
                     varint64 : (vint64 : int64);
                     varqword : (vqword : qword);
                     varword64 : (vword64 : qword);
                     varstring : (vstring : pointer);
                     varany :  (vany : pointer);
                     vararray : (varray : pvararray);
                     varbyref : (vpointer : pointer);
                 );
               1:
                 (vlongs : array[0..2] of longint);
           );
         1:(vwords : array[0..6] of word);
         2:(vbytes : array[0..13] of byte);
      end;
   pvardata = ^tvardata;

   pcalldesc = ^tcalldesc;
   tcalldesc = packed record
      calltype,argcount,namedargcount : byte;
      argtypes : array[0..255] of byte;
   end;

   pdispdesc = ^tdispdesc;
   tdispdesc = packed record
      dispid : longint;
      restype : byte;
      calldesc : tcalldesc;
   end;

   tvariantmanager = record
      vartoint : function(const v : variant) : longint;
      vartoint64 : function(const v : variant) : int64;
      vartoword64 : function(const v : variant) : qword;
      vartobool : function(const v : variant) : boolean;
      vartoreal : function(const v : variant) : extended;
      vartotdatetime : function(const v : variant) : tdatetime;
      vartocurr : function(const v : variant) : currency;
      vartopstr : procedure(var s ;const v : variant);
      vartolstr : procedure(var s : ansistring;const v : variant);
      vartowstr : procedure(var s : widestring;const v : variant);
      vartointf : procedure(var intf : iinterface;const v : variant);
      vartodisp : procedure(var disp : idispatch;const v : variant);
      vartodynarray : procedure(var dynarr : pointer;const v : variant;
         typeinfo : pointer);

      varfrombool : procedure(var dest : variant;const source : Boolean);
      varfromint : procedure(var dest : variant;const source,Range : longint);
      varfromint64 : procedure(var dest : variant;const source : int64);
      varfromword64 : procedure(var dest : variant;const source : qword);
      varfromreal : procedure(var dest : variant;const source : extended);
      varfromtdatetime : procedure(var dest : Variant;const source : TDateTime);
      varfromcurr : procedure(var dest : Variant;const source : Currency);
      varfrompstr: procedure(var dest : variant; const source : ShortString);
      varfromlstr: procedure(var dest : variant; const source : ansistring);
      varfromwstr: procedure(var dest : variant; const source : WideString);
      varfromintf: procedure(var dest : variant;const source : iinterface);
      varfromdisp: procedure(var dest : variant;const source : idispatch);
      varfromdynarray: procedure(var dest : variant;const source : pointer; typeinfo: pointer);
      olevarfrompstr: procedure(var dest : olevariant; const source : shortstring);
      olevarfromlstr: procedure(var dest : olevariant; const source : ansistring);
      olevarfromvar: procedure(var dest : olevariant; const source : variant);
      olevarfromint: procedure(var dest : olevariant; const source : longint;const range : shortint);

      { operators }
      varop : procedure(var left : variant;const right : variant;opcode : tvarop);
      cmpop : function(const left,right : variant;const opcode : tvarop) : boolean;
      varneg : procedure(var v : variant);
      varnot : procedure(var v : variant);

      { misc }
      varinit : procedure(var v : variant);
      varclear : procedure(var v : variant);
      varaddref : procedure(var v : variant);
      varcopy : procedure(var dest : variant;const source : variant);
      varcast : procedure(var dest : variant;const source : variant;vartype : longint);
      varcastole : procedure(var dest : variant; const source : variant;vartype : longint);

      dispinvoke: procedure(dest : pvardata;const source : tvardata;
        calldesc : pcalldesc;params : pointer);cdecl;

      vararrayredim : procedure(var a : variant;highbound : SizeInt);
      vararrayget : function(const a : variant;indexcount : SizeInt;indices : PSizeInt) : variant;cdecl;
      vararrayput: procedure(var a : variant; const value : variant;
        indexcount : SizeInt;indices : PSizeInt);cdecl;
      writevariant : function(var t : text;const v : variant;width : longint) : Pointer;
      write0Variant : function(var t : text;const v : Variant) : Pointer;
   end;
   pvariantmanager = ^tvariantmanager;

procedure GetVariantManager(var VarMgr: TVariantManager);
procedure SetVariantManager(const VarMgr: TVariantManager);
function IsVariantManagerSet: Boolean;

const
  VarClearProc :  procedure(var v : TVarData) = nil;
  VarAddRefProc : procedure(var v : TVarData) = nil;
  VarCopyProc :   procedure(var d : TVarData;const s : TVarData) = nil;
  VarToLStrProc : procedure(var d : AnsiString;const s : TVarData) = nil;
  VarToWStrProc : procedure(var d : WideString;const s : TVarData) = nil;

var
   VarDispProc : pointer;
   DispCallByIDProc : pointer;
   Null,Unassigned : Variant;

{**********************************************************************
                       to Variant assignments
 **********************************************************************}

{ Integer }
operator :=(const source : byte) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : shortint) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : word) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : smallint) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : dword) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : longint) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : qword) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : int64) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Boolean }
operator :=(const source : boolean) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : wordbool) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : longbool) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Chars }
operator :=(const source : char) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : widechar) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Strings }
operator :=(const source : shortstring) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : ansistring) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : widestring) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Floats }
{$ifdef SUPPORT_SINGLE}
operator :=(const source : single) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_SINGLE}
{$ifdef SUPPORT_DOUBLE}
operator :=(const source : double) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_DOUBLE}
{$ifdef SUPPORT_EXTENDED}
operator :=(const source : extended) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_EXTENDED}
{$ifdef SUPPORT_COMP}
operator :=(const source : comp) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_COMP}

{ Misc. }
operator :=(const source : currency) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : tdatetime) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : terror) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}

{**********************************************************************
                       from Variant assignments
 **********************************************************************}

{ Integer }
operator :=(const source : variant) dest : byte;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : shortint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : word;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : smallint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : dword;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : longint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : qword;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : int64;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Boolean }
operator :=(const source : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : wordbool;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : longbool;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Chars }
operator :=(const source : variant) dest : char;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : widechar;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Strings }
operator :=(const source : variant) dest : shortstring;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : ansistring;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : widestring;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Floats }
{$ifdef SUPPORT_SINGLE}
operator :=(const source : variant) dest : single;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_SINGLE}
{$ifdef SUPPORT_DOUBLE}
operator :=(const source : variant) dest : double;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_DOUBLE}
{$ifdef SUPPORT_EXTENDED}
operator :=(const source : variant) dest : extended;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_EXTENDED}
{$ifdef SUPPORT_COMP}
operator :=(const source : variant) dest : comp;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_COMP}

operator :=(const source : olevariant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Misc. }
operator :=(const source : variant) dest : currency;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : tdatetime;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : variant) dest : terror;{$ifdef SYSTEMINLINE}inline;{$endif}

{**********************************************************************
                         Operators
 **********************************************************************}

operator or(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator and(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator xor(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator not(const op : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator shl(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator shr(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator +(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator -(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator *(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator /(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator **(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator div(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator mod(const op1,op2 : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator -(const op : variant) dest : variant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator =(const op1,op2 : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator <(const op1,op2 : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator >(const op1,op2 : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator >=(const op1,op2 : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator <=(const op1,op2 : variant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}

{ variant helpers }
procedure VarArrayRedim(var A: Variant; HighBound: SizeInt);
procedure VarCast(var dest : variant;const source : variant;vartype : longint);

{**********************************************************************
                        from OLEVariant assignments
 **********************************************************************}

{ Integer }
operator :=(const source : olevariant) dest : byte;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : shortint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : word;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : smallint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : dword;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : longint;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : qword;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : int64;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Boolean }
operator :=(const source : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : wordbool;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : longbool;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Chars }
operator :=(const source : olevariant) dest : char;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : widechar;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Strings }
operator :=(const source : olevariant) dest : shortstring;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : ansistring;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : widestring;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Floats }
{$ifdef SUPPORT_SINGLE}
operator :=(const source : olevariant) dest : single;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_SINGLE}
{$ifdef SUPPORT_DOUBLE}
operator :=(const source : olevariant) dest : double;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_DOUBLE}
{$ifdef SUPPORT_EXTENDED}
operator :=(const source : olevariant) dest : extended;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_EXTENDED}
{$ifdef SUPPORT_COMP}
operator :=(const source : olevariant) dest : comp;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_COMP}

{ Misc. }
operator :=(const source : olevariant) dest : currency;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : tdatetime;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : olevariant) dest : terror;{$ifdef SYSTEMINLINE}inline;{$endif}

{**********************************************************************
                         to OLEVariant assignments
 **********************************************************************}

{ Integer }
operator :=(const source : byte) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : shortint) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : word) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : smallint) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : dword) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : longint) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : qword) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : int64) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Boolean }
operator :=(const source : boolean) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : wordbool) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : longbool) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Chars }
operator :=(const source : char) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : widechar) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Strings }
operator :=(const source : shortstring) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : ansistring) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : widestring) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{ Floats }
{$ifdef SUPPORT_SINGLE}
operator :=(const source : single) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_SINGLE}
{$ifdef SUPPORT_DOUBLE}
operator :=(const source : double) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_DOUBLE}
{$ifdef SUPPORT_EXTENDED}
operator :=(const source : extended) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_EXTENDED}
{$ifdef SUPPORT_COMP}
operator :=(const source : comp) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
{$endif SUPPORT_COMP}

{ Misc. }
operator :=(const source : currency) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : tdatetime) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator :=(const source : terror) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}

{**********************************************************************
                             OLEVariant Operators
 **********************************************************************}
(*
operator or(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator and(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator xor(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator not(const op : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator shl(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator shr(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator +(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator -(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator *(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator /(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator **(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator div(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator mod(const op1,op2 : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator -(const op : olevariant) dest : olevariant;{$ifdef SYSTEMINLINE}inline;{$endif}
operator =(const op1,op2 : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator <(const op1,op2 : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator >(const op1,op2 : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator >=(const op1,op2 : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
operator <=(const op1,op2 : olevariant) dest : boolean;{$ifdef SYSTEMINLINE}inline;{$endif}
*)
