{
     File:       OSServices/CSIdentityQuery.h
 
     Contains:   Identity Query APIs
 
     Version:    OSServices-352~2
 
     Copyright:   2006-2008 by Apple Computer, Inc., all rights reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://www.freepascal.org/bugs.html
 
}
{      Pascal Translation:  Jonas Maebe, <jonas@freepascal.org>, October 2009 }
{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

unit CSIdentityQuery;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
{$ifc defined(iphonesim)}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{ will require compiler define when/if other Apple devices with ARM cpus ship }
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,MacOSXPosix,CSIdentity,CSIdentityAuthority,CFBase,CFArray,CFData,CFError,CFRunLoop,CFUUID;
{$endc} {not MACOSALLINCLUDE}


{$ifc TARGET_OS_MAC}

{$ALIGN MAC68K}


{
 *  CSIdentityQueryGetTypeID()
 *  
 *  Summary:
 *    Retrieve the CFTypeID of the CSIdentityQuery class
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryGetTypeID: CFTypeID; external name '_CSIdentityQueryGetTypeID';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryFlags
 *  
 *  Summary:
 *    Execution options for an identity query
 *  
 *  Discussion:
 *    A bit mask for setting execution options on a query
 }
const
{
   * After the intial query phase is complete, monitor the result set
   * for live updates
   }
	kCSIdentityQueryGenerateUpdateEvents = $0001;

  {
   * Include all matching identities in the result set, including
   * hidden "system" users and groups (root, www, etc.)
   }
	kCSIdentityQueryIncludeHiddenIdentities = $0002;

type
	CSIdentityQueryFlags = CFOptionFlags;

{
 *  CSIdentityQueryStringComparisonMethod
 *  
 *  Summary:
 *    Options for querying the database by name
 *  
 *  Discussion:
 *    When searching for identities by name, this value specifies the
 *    string comparison function
 }
const
{
   * The identity name must equal the search string
   }
	kCSIdentityQueryStringEquals = 1;

  {
   * The identity name must begin with the search string
   }
	kCSIdentityQueryStringBeginsWith = 2;

type
	CSIdentityQueryStringComparisonMethod = CFIndex;
{
 *  CSIdentityQueryCreate()
 *  
 *  Summary:
 *    Creates an identity query object for all identities in the
 *    specified authority
 *  
 *  Discussion:
 *    The results of this query include all of the identities in the
 *    specified authority's database.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *    
 *    identityClass:
 *      The class of identity to find
 *    
 *    authority:
 *      The identity authority to query
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreate( allocator: CFAllocatorRef; identityClass: CSIdentityClass; authority: CSIdentityAuthorityRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreate';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCreateForName()
 *  
 *  Summary:
 *    Creates an identity query object based on a name
 *  
 *  Discussion:
 *    The query finds identities by name. It searches the full names,
 *    posix names and aliases for matches.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *    
 *    name:
 *      The name criteria for the query.
 *    
 *    comparisonMethod:
 *      The comparision function (equal or begins with)
 *    
 *    identityClass:
 *      The class of identity to find
 *    
 *    authority:
 *      The identity authority to query
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreateForName( allocator: CFAllocatorRef; name: CFStringRef; comparisonMethod: CSIdentityQueryStringComparisonMethod; identityClass: CSIdentityClass; authority: CSIdentityAuthorityRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreateForName';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCreateForUUID()
 *  
 *  Summary:
 *    Creates an identity query object based on a UUID
 *  
 *  Discussion:
 *    Finds an identity by its UUID
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *    
 *    uuid:
 *      The UUID of the identity to find
 *    
 *    authority:
 *      The identity authority to query
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreateForUUID( allocator: CFAllocatorRef; uuid: CFUUIDRef; authority: CSIdentityAuthorityRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreateForUUID';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCreateForPosixID()
 *  
 *  Summary:
 *    Creates an identity query object based on a POSIX ID
 *  
 *  Discussion:
 *    Finds an identity by its UID or GID
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *    
 *    posixID:
 *      The UID or GID of the identity to find
 *    
 *    identityClass:
 *      The class of identity to find
 *    
 *    authority:
 *      The identity authority to query
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreateForPosixID( allocator: CFAllocatorRef; posixID: id_t; identityClass: CSIdentityClass; authority: CSIdentityAuthorityRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreateForPosixID';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCreateForPersistentReference()
 *  
 *  Summary:
 *    Creates an identity query object based on an identity reference
 *    data object
 *  
 *  Discussion:
 *    Finds an identity by reference data obtained from
 *    CSIdentityCreateReferenceData
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *    
 *    referenceData:
 *      The reference data that fully describes an identity
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreateForPersistentReference( allocator: CFAllocatorRef; referenceData: CFDataRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreateForPersistentReference';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCreateForCurrentUser()
 *  
 *  Summary:
 *    Creates a query for the current session user's identity
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    allocator:
 *      The allocator to use for this instance
 *  
 *  Result:
 *    A new CSIdentityQuery object
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCreateForCurrentUser( allocator: CFAllocatorRef ): CSIdentityQueryRef; external name '_CSIdentityQueryCreateForCurrentUser';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryCopyResults()
 *  
 *  Summary:
 *    Retrieve the results of executing an identity query
 *  
 *  Discussion:
 *    Returns an immutable array of CSIdentityRefs, reflecting the
 *    current results of the query's execution.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    query:
 *      The query object to access
 *  
 *  Result:
 *    An array of zero or more CSIdentityRefs
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryCopyResults( query: CSIdentityQueryRef ): CFArrayRef; external name '_CSIdentityQueryCopyResults';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryExecute()
 *  
 *  Summary:
 *    Execute an identity query synchronously
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    query:
 *      The query object to execute
 *    
 *    flags:
 *      Execution options
 *    
 *    error:
 *      Optional pointer to a CFError object which must be released by
 *      the caller if CSIdentityQueryExecute returns false
 *  
 *  Result:
 *    Returns true if the query executed successfully, false if an
 *    error occurred.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryExecute( query: CSIdentityQueryRef; flags: CSIdentityQueryFlags; error: CFErrorRefPtr { can be NULL } ): Boolean; external name '_CSIdentityQueryExecute';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryEvent
 *  
 *  Summary:
 *    Results from executing an asynchronous query
 *  
 *  Discussion:
 *    Events generated during asynchronous query execution
 }
const
{
   * Event generated when the initial lookup of identities has
   * finished. Live update events will follow if caller requests the
   * kCSIdentityQueryGenerateUpdateEvents option.
   }
	kCSIdentityQueryEventSearchPhaseFinished = 1;

  {
   * Event generated when identities are added to the query results
   }
	kCSIdentityQueryEventResultsAdded = 2;

  {
   * Event generated when identities already in the query results have
   * been modified
   }
	kCSIdentityQueryEventResultsChanged = 3;

  {
   * Event generated when identities are removed from the query results
   }
	kCSIdentityQueryEventResultsRemoved = 4;

  {
   * Used to report an error. Query execution stops (permanently) if
   * this event is sent.
   }
	kCSIdentityQueryEventErrorOccurred = 5;

type
	CSIdentityQueryEvent = CFIndex;

{
 *  CSIdentityQueryReceiveEventCallback
 *  
 *  Summary:
 *    The client event callback function for receiving asynchronous
 *    query events
 *  
 *  Parameters:
 *    
 *    query:
 *      The identity query object that has completed an event
 *    
 *    event:
 *      The event the identity query object has completed
 *    
 *    identities:
 *      a CFArray containing identities resulting from the query
 *    
 *    error:
 *      A CFError object if there was an error from the query
 *    
 *    info:
 *      Any other information you want passed to the callback function
 }
type
	CSIdentityQueryReceiveEventCallback = procedure( query: CSIdentityQueryRef; event: CSIdentityQueryEvent; identities: CFArrayRef; error: CFErrorRef; info: UnivPtr );

{
 *  CSIdentityQueryClientContext
 *  
 *  Summary:
 *    Client structure specifying callbacks and private context data
 }
type
	CSIdentityQueryClientContext = record
		version: CFIndex;
		info: UnivPtr;
		retainInfo: CFAllocatorRetainCallBack;
		releaseInfo: CFAllocatorReleaseCallBack;
		copyInfoDescription: CFAllocatorCopyDescriptionCallBack;
		receiveEvent: CSIdentityQueryReceiveEventCallback;
	end;
{
 *  CSIdentityQueryExecuteAsynchronously()
 *  
 *  Summary:
 *    Execute an identity query asynchronously
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    query:
 *      The query object to execute
 *    
 *    flags:
 *      Execution options
 *    
 *    clientContext:
 *      The client context and callbacks to be used during execution
 *    
 *    runLoop:
 *      The run loop on which to schedule callbacks
 *    
 *    runLoopMode:
 *      The run loop mode in which callbacks may be scheduled
 *  
 *  Result:
 *    Returns true if query execution started, false if the query has
 *    already been executed.
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
function CSIdentityQueryExecuteAsynchronously( query: CSIdentityQueryRef; flags: CSIdentityQueryFlags; const (*var*) clientContext: CSIdentityQueryClientContext; runLoop: CFRunLoopRef; runLoopMode: CFStringRef ): Boolean; external name '_CSIdentityQueryExecuteAsynchronously';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{
 *  CSIdentityQueryStop()
 *  
 *  Summary:
 *    Invalidate an identity query client
 *  
 *  Discussion:
 *    Invalidate a query client so that its callback will never be
 *    called in the future. Clients should call CSIdentityQueryStop
 *    when an query will no longer be used, prior to releasing the
 *    final query reference.
 *  
 *  Mac OS X threading:
 *    Thread safe since version 10.5
 *  
 *  Parameters:
 *    
 *    query:
 *      The query to access
 *  
 *  Availability:
 *    Mac OS X:         in version 10.5 and later in CoreServices.framework
 *    CarbonLib:        not available
 *    Non-Carbon CFM:   not available
 }
procedure CSIdentityQueryStop( query: CSIdentityQueryRef ); external name '_CSIdentityQueryStop';
(* AVAILABLE_MAC_OS_X_VERSION_10_5_AND_LATER *)


{$endc} {TARGET_OS_MAC}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
