/*
SMS Server Tools
Copyright (C) 2000-2002 Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:s.frings@mail.isis.de
 */
#include "../constants.h"

/* reads a SMS from the SIM-memory 1-10 */
/* returns number of SIM memory if successful */
/* on digicom the return value can be != sim */
static int fetchsms(char* pdu, int sim)
{
	char command[16];
	char answer[ANSWERSIZE]= "F+CMGR:";
	char* position;
	char* beginning;
	char* end;
	int  foo,err;
	int  clen;

/*
	int i;
	for (i = 0; i < ANSWERSIZE; i++)
	{
	  answer[i] = nondet_int();
	}
*/
	answer[sizeof(answer)-1] = EOS;

	// Digicom reports date+time only with AT+CMGL
	if (0 && nondet_int() == 0) {
		/* search for beginning of the answer */
		position=strstr(answer,"+CMGL: ");
		if (position) {
			end=position+7;
			while (*end<'9' && *end>'0') end++;
			position = 0;
		}
	} else {
		position=strstr(answer,"+CMGR:");
	}

	/* keine SMS empfangen, weil Modem nicht mit +CMGR
	oder +CMGL geantwortet hat */
	if (position==0)
		return 0;
	beginning=position+7;
	/* keine SMS, weil Modem mit +CMGR: 0,,0 geantwortet hat */
	if (strstr(answer,",,0\r"))
		return 0;

	/* After that we have the PDU or ASCII string */
	for( end=beginning ; *end && *end!='\r' ; end++ );
	if ( !*end || end-beginning<4)
		return 0;
	for( end=end+1 ; *end && *end!='\r' ; end++ );
	if ( !*end || end-beginning<4)
		return 0;
	/* Now we have the end of the PDU or ASCII string */
	*end=0;
	r_strcpy(pdu,beginning);

	return sim;
}

int main ()
{
  char pdu [PDUSIZE];
  int sim = 0;

  fetchsms (pdu, sim);

  return 0;
}


