/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */


package net.sf.freecol.common.model;


import net.sf.freecol.common.util.Xml;

import org.w3c.dom.Node;


public final class TileType
{

    public  String    id;
    public  String    name;
    public  int       basicMoveCost;
    public  int       defenceBonus;
    public  TileType  whenForested;


    public void readFromXmlElement( Node tileTypeXml ) {

        id = Xml.attribute( tileTypeXml, "name" );
        name = Xml.attribute( tileTypeXml, "name" );
        basicMoveCost = Xml.intAttribute(tileTypeXml, "basic-move-cost");
        defenceBonus = Xml.intAttribute(tileTypeXml, "defence-bonus");

        /* there may be zero or one children of a "tile-type" element.  a child
         * element (if present) defines the forested version of the tile
         */
        Xml.Method method = new Xml.Method() {
            public void invokeOn( Node xml ) {

                whenForested = new TileType();
                whenForested.readFromXmlElement( xml );
            }
        };

        Xml.forEachChild( tileTypeXml, method );
    }

}
