/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "midioutputthread.h"

MidiOutputThread::MidiOutputThread()
 : QThread()
{
    midiOutput=new MidiOutput();
    //midiOutput->startQueue();
    play=false;
}


MidiOutputThread::~MidiOutputThread()
{
}


/*!
    \fn MidiOutputThread::run()
 */
void MidiOutputThread::run()
{
    midiOutput->startQueue();
    while(TRUE){
        if(play)
            midiOutput->doLoop();
        else
            msleep(100);
    }
}







/*!
    \fn MidiOutputThread::getMidiOutput()
 */
MidiOutput* MidiOutputThread::getMidiOutput()
{
    return midiOutput;
}


/*!
    \fn MidiOutputThread::stopQueue()
 */
void MidiOutputThread::stopQueue()
{
    if(play){
        midiOutput->stopQueue();
        play=FALSE;
    }
}


/*!
    \fn MidiOutputThread::continueQueue()
 */
void MidiOutputThread::continueQueue()
{
    if(!play){
        midiOutput->continueQueue();
        play=TRUE;
    }
}
