/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "passthrough.h"

PassThrough::PassThrough(int n,QObject *parent, const char *name)
 : CustomEffect(parent, name)
{
    nbPorts=n;
    inputs=new float*[nbPorts];
    outputs=new float*[nbPorts];
    beginInputs=new float*[nbPorts];
    beginOutputs=new float*[nbPorts];
    for (int i=0;i<nbPorts;i++){
        inputs[i]=0;
        outputs[i]=0;
        beginOutputs[i]=0;
        beginInputs[i]=0;
    }
    bufferLength=0;
}


PassThrough::~PassThrough()
{
    zaparr(inputs);
    zaparr(outputs);
    zaparr(beginInputs);
    zaparr(beginOutputs);
}


void PassThrough::advancePosition(long length)
{
    for (int i=0;i<nbPorts;i++){
        outputs[i]=&(outputs[i][length]);
        inputs[i]=&(inputs[i][length]);
    }
}

void PassThrough::init(long length)
{
    bufferLength=length;
}

void PassThrough::process(long length)
{
    for (int i=0;i<nbPorts;i++){
        memcpy(outputs[i],inputs[i],sizeof(float)*length);
    }
}

void PassThrough::setPosition(long position)
{
    for (int i=0;i<nbPorts;i++){
        outputs[i]=&(beginOutputs[i][position]);
        inputs[i]=&(beginInputs[i][position]);
    }
}



/*!
    \fn PassThrough::setOutput_P(int n)
 */
void PassThrough::setOutput_P(int n, float* p)
{
    outputs[n]=p;
    beginOutputs[n]=p;
}


/*!
    \fn PassThrough::setInput_P(int n)
 */
void PassThrough::setInput_P(int n, float* p)
{
    inputs[n]=p;
    beginInputs[n]=p;
}

QString PassThrough::getName(){
    return "PassThrough";
}
