/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "samplevalueview.h"

SampleValueView::SampleValueView(SoundManager* sm,QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
    soundManager=sm;
    position=0;
    hide();
    colorClear.setRgb(200,200,200);
    colorDark.setRgb(100,100,100);
    font.setPixelSize(14);
    font.setBold(TRUE);
    font.setWeight(99);
    font.setFamily("Arial");
    setY(100);
    QFontMetrics fm(font);
    setSize(250,fm.height()+5);
}


SampleValueView::~SampleValueView()
{
}

void SampleValueView::drawShape( QPainter &p ){
    setY(canvas()->height()/2);
    p.setFont(font);
    QFontMetrics font_metrics(font);
    RasterOp oldROP=p.rasterOp();
    p.setPen(QPen(colorDark,2));
    p.setRasterOp(CopyROP);
    double val0=double(soundManager->getLeftChannel()[position-2]);
    double val1=double(soundManager->getLeftChannel()[position-1]);
    double val2=double(soundManager->getLeftChannel()[position]);
    double val3=double(soundManager->getLeftChannel()[position+1]);
    double val4=double(soundManager->getLeftChannel()[position+2]);
    QColor color0,color1, color2, color3,color4;
    color0.setRgb(int((val0+1.0)*127.0),int((val0+1.0)*127.0),int((val0+1.0)*127.0));
    color1.setRgb(int((val1+1.0)*127.0),int((val1+1.0)*127.0),int((val1+1.0)*127.0));
    color2.setRgb(int((val2+1.0)*127.0),int((val2+1.0)*127.0),int((val2+1.0)*127.0));
    color3.setRgb(int((val3+1.0)*127.0),int((val3+1.0)*127.0),int((val3+1.0)*127.0));
    color4.setRgb(int((val4+1.0)*127.0),int((val4+1.0)*127.0),int((val4+1.0)*127.0));


    QRect rect0(rect().x(),rect().y(),rect().width()/5,rect().height());
    QRect rect1(rect().x()+rect().width()/5,rect().y(),rect().width()/5,rect().height());
    QRect rect2(rect().x()+2*rect().width()/5,rect().y(),rect().width()/5,rect().height());
    QRect rect3(rect().x()+3*rect().width()/5,rect().y(),rect().width()/5,rect().height());
    QRect rect4(rect().x()+4*rect().width()/5,rect().y(),rect().width()/5,rect().height());

    QString text0(QString::number(val0,'f',2));
    QString text1(QString::number(val1,'f',2));
    QString text2(QString::number(val2,'f',2));
    QString text3(QString::number(val3,'f',2));
    QString text4(QString::number(val4,'f',2));

    p.setBrush(QBrush(color0,SolidPattern));
    p.drawRect(rect0);

    p.setBrush(QBrush(color1,SolidPattern));
    p.drawRect(rect1);

    p.setPen(QPen(red,2));
    if(((val1<0) != (val3<0))||
        (((val1<0)==(val2<0)) && ((val2<0)!=(val3<0)))
        ){
        p.setPen(QPen(black,2));
        p.setBrush(QBrush(red,SolidPattern));
    }else{
        p.setBrush(QBrush(color2,SolidPattern));
    }
    p.drawRect(rect2);

    p.setBrush(QBrush(color3,SolidPattern));
    p.setPen(QPen(colorDark,2));
    p.drawRect(rect3);

    p.setBrush(QBrush(color4,SolidPattern));
    p.drawRect(rect4);



    val0<0?p.setPen(white):p.setPen(black);
    p.drawText(rect0,AlignCenter ,text0);
    val1<0?p.setPen(white):p.setPen(black);
    p.drawText(rect1,AlignCenter ,text1);
    val2<0?p.setPen(white):p.setPen(black);
    p.drawText(rect2,AlignCenter ,text2);
    val3<0?p.setPen(white):p.setPen(black);
    p.drawText(rect3,AlignCenter ,text3);
    val4<0?p.setPen(white):p.setPen(black);
    p.drawText(rect4,AlignCenter ,text4);

    p.setRasterOp(oldROP);
}


/*!
    \fn SampleValueView::setPosition(long pos)
 */
void SampleValueView::setPosition(long pos)
{
    position=pos;
    canvas()->setChanged(rect());
    update();
}
