/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SCOPEVIEW_H
#define SCOPEVIEW_H

#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>
#include "playpositionchanged.h"
#include "soundmanager.h"

/**
@author Predrag Viceic

\class ScopeView

\brief implements the realtime scope widget with the  hifi chain look
*/
class ScopeView : public QFrame
{
Q_OBJECT
public:
    ScopeView(QWidget *parent = 0, const char *name = 0);
    ~ScopeView();
    void customEvent(QCustomEvent*);
    void setSoundManager(SoundManager*);
    QSize sizeHint () const;


public slots:
    void paintEvent(QPaintEvent*);
    void showEvent(QShowEvent*);

private:
    int frames;
    long position;
    long lastRenderedPosition;
    int horiz_steps;
    int vert_steps;
    float* max_energies;


protected:
    SoundManager* soundManager;
    void resizeEvent(QResizeEvent* ev);
    bool playing;
};

#endif
