/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef VERTICALSELECTIONRECTANGLE_H
#define VERTICALSELECTIONRECTANGLE_H

#include <selectionrectangle.h>
#include <qpainter.h>
#include "soundmanager.h"

/**
@author Predrag Viceic
*/
class VerticalSelectionRectangle : public SelectionRectangle
{
public:
    VerticalSelectionRectangle(QCanvas* canvas);
    VerticalSelectionRectangle(SoundManager* sm, int band_pos,int x, int y, int width, int height,QCanvas*,bool);
    ~VerticalSelectionRectangle();
    void setStartBandPos(int);
    void setEndBandPos(int);
    int getStartBandPos();
    int getEndBandPos();
    void drawShape( QPainter & );
    void setInverted(bool);
    bool getInverted();

protected:
    int start_band_pos;
    int end_band_pos;
    bool inverted;
    SoundManager* soundManager;
};

#endif
