/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ladspaeffects.h"

LADSPAEffects::LADSPAEffects(QObject *parent, const char *name)
 : QObject(parent, name)
{
    QPtrList<LADSPAEffect> availableLadspaEffects;
    currentEffect=0;
}


LADSPAEffects::~LADSPAEffects()
{
}

void LADSPAEffects::loadEffects(QString path){
    std::cout<<"Start loading LADSPA plugins...\n";
    QDir ladspa_dir(path);
    QStringList list=ladspa_dir.entryList(QDir::Files);

    for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) {
        QString file=*it;
        std::cout<<"-----------file: "<<file<<"\n";
        void *handle = NULL;
        handle = dlopen(path+"/"+file, RTLD_LAZY);
        LADSPA_Descriptor_Function mainFn = NULL;
        mainFn = (LADSPA_Descriptor_Function)dlsym(handle, "ladspa_descriptor");
        if (mainFn) {
            int index = 0;
            const LADSPA_Descriptor *data=NULL;

            data = mainFn(index);
            while(data) {
                LADSPAEffect* tempeff=new LADSPAEffect(data);
                if(tempeff->isEffectSuitable()){
                    availableLadspaEffects.append(tempeff);
                    std::cout<<tempeff->getName()<<" loaded\n";
                }else{
                    std::cout<<tempeff->getName()<<" rejected\n";
                    delete tempeff;
                }

                // Get next plugin
                index++;
		data = mainFn(index);

            }
       }
    }
    std::cout<<"...End.\n";
}


/*!
    \fn LADSPAEffects::getEffects()
 */
QPtrList <LADSPAEffect>* LADSPAEffects::getEffects()
{
    return &availableLadspaEffects;
}


/*!
    \fn LADSPAEffects::getEffect(int)
 */
LADSPAEffect* LADSPAEffects::getEffect(uint uniqueId)
{
    for (QPtrList<LADSPAEffect>::Iterator it = getEffects()->begin();
            it!=getEffects()->end();++it){
        if((*it)->getUniqueID()==uniqueId) return (*it);
    }
    return NULL;
}


/*!
    \fn LADSPAEffects::setNbFrames(long)
 */
void LADSPAEffects::setNbFrames(long nbf)
{
    for (QPtrList<LADSPAEffect>::Iterator it = getEffects()->begin();
            it!=getEffects()->end();++it){
        (*it)->setNbFrames(nbf);
    }
}



/*!
    \fn LADSPAEffects::getCurrent()
 */
LADSPAEffect* LADSPAEffects::getCurrent()
{
    return currentEffect;
}


/*!
    \fn LADSPAEffects::setCurrent(LADSPAEffect* eff)
 */
void LADSPAEffects::setCurrent(LADSPAEffect* eff)
{
    currentEffect=eff;
}
