/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LOCKEDBEATRECT_H
#define LOCKEDBEATRECT_H

#include <qcanvas.h>
#include "defs.h"
#include "pics/icons.h"
#include "beatline.h"
#include "samplenumberdisplay.h"
#include "soundmanager.h"
#include "blinkable.h"
#include "pitchshifter.h"

/**
@author Predrag Viceic
*/
class LockedBeatRect : public QCanvasRectangle, public Blinkable
{
public:
    LockedBeatRect(QCanvas* canvas,BeatLine* start,BeatLine* end,SoundManager* sm);
    ~LockedBeatRect();
    
    QPointArray areaPoints() const;
    int rtti() const;
    void setColor(int i);
    QRect* getHandle();
    void setSelected(bool tf);
    bool isSelected();
    long getStartSample();
    long getEndSample();
    int getNb();
    void setNb(int n);
    bool operator<(LockedBeatRect brect);
    bool operator==(LockedBeatRect brect);
    void updateGeom();
    void removeSampleNumberDisplay(SampleNumberDisplay* snd);
    void addSampleNumberDisplay(SampleNumberDisplay* snd);
    void updateSampleDisplays();
    void mousePressEvent(QMouseEvent* ev);
    void setCurrentSND(SampleNumberDisplay* snd);
    QRect getSampleNumberDisplaysRect();
    int getSNDCount();
    void renumberSampleNumberDisplays();
    void copySceneStatus(SampleNumberDisplay* snd);
    void assignSceneToCurrent(int sc);
    void setSceneStatus(int sn, bool status);
    void switchScene(int sc);
    QPtrList <SampleNumberDisplay> getSampleNumberDisplays();
    void updateSceneStatus();
    bool canRemove();
    void executeBlink(int step);
    BeatLine* getEndBL();
    BeatLine* getStartBL();
    QRect* getPitchshiftHandle();
	

protected:
    BeatLine* endBL;
    BeatLine* startBL;
    QColor bgColor;
    QRect* handle;
    QRect* pitchshiftHandle;
    bool selected;
    int number;
    QPtrList <SampleNumberDisplay> sampleNumberDisplays;
    QPtrList <PitchShifter> pitchShifters;
    void drawShape ( QPainter & p );


	

    SoundManager* soundManager;
    bool drawRedRect;
    
};

#endif
