/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rangeindicatorwidget.h"

RangeIndicatorWidget::RangeIndicatorWidget(QWidget *parent, const char *name)
    : QLabel(parent, name,Qt::WNoAutoErase)
{
    rangeMinVal=0;
    rangeMaxVal=100;
    minVal=10;
    maxVal=20;
    moving=MOVING_NONE;
    minimumRange=1;

}


RangeIndicatorWidget::~RangeIndicatorWidget()
{

}




/*!
    \fn RangeIndicatorWidget::setRangeMaxValue(int r_max)
 */
void RangeIndicatorWidget::setRangeMaxValue(int r_max)
{
    rangeMaxVal=r_max;
    update();
}


/*!
    \fn RangeIndicatorWidget::setMaxValue(int max)
 */
void RangeIndicatorWidget::setMaxValue(int max)
{
    int tempMaxVal=max<=rangeMaxVal?max:rangeMaxVal;
    if(tempMaxVal-minimumRange>=minVal){
        maxVal=tempMaxVal;
        emit(maxChanged(maxVal));
    }
    update();
}


/*!
    \fn RangeIndicatorWidget::setMinValue(int min)
 */
void RangeIndicatorWidget::setMinValue(int min)
{
    int tempMinVal=min>=rangeMinVal?min:rangeMinVal;
    if(tempMinVal+minimumRange<=maxVal){
        minVal=tempMinVal;
        emit(minChanged(tempMinVal));
    }
    update();
}


/*!
    \fn RangeIndicatorWidget::setRangeMinValue(int r_min)
 */
void RangeIndicatorWidget::setRangeMinValue(int r_min)
{
    rangeMinVal=r_min;
    update();
}

void RangeIndicatorWidget::paintEvent ( QPaintEvent * /*pe*/){
    QBrush brush1=QBrush(isEnabled()?red:darkGray);
    QBrush brush2=QBrush(isEnabled()?yellow:gray);
    static QPixmap pixmap;
    if(pixmap.size()!=rect().size()) pixmap.resize(rect().size());
    QPainter p(&pixmap);
    p.fillRect(rect(),brush1);
    p.drawRect(rect());
    int start=rect().height()-(rect().height()*(minVal-rangeMinVal))/(rangeMaxVal-rangeMinVal);
    int end=rect().height()-(rect().height()*(maxVal-rangeMinVal))/(rangeMaxVal-rangeMinVal);
    QRect smallrect(rect().x()+2,end,rect().width()-4,-(end-start));
    p.fillRect(smallrect,brush2);
    p.drawRect(smallrect);
    bitBlt(this,0,0,&pixmap);
}

void RangeIndicatorWidget::mousePressEvent ( QMouseEvent * e ){
    int start=rect().height()-(rect().height()*(minVal-rangeMinVal))/(rangeMaxVal-rangeMinVal);
    int end=rect().height()-(rect().height()*(maxVal-rangeMinVal))/(rangeMaxVal-rangeMinVal);
    if (abs(e->pos().y()-start)<=abs(e->pos().y()-end)){
        moving=MOVING_START;
        setMinValue(((rect().height()-e->pos().y())*rangeMaxVal)/rect().height());
    }else{
        moving=MOVING_END;
        setMaxValue(((rect().height()-e->pos().y())*rangeMaxVal)/rect().height());
    }
    update();

}

void RangeIndicatorWidget::mouseReleaseEvent ( QMouseEvent * /*e*/ ){
    moving=MOVING_NONE;
}

void RangeIndicatorWidget::mouseMoveEvent ( QMouseEvent * e ){
    if(rect().height()>0){
        if(moving==MOVING_START){
            setMinValue(((rect().height()-e->pos().y())*rangeMaxVal)/rect().height());
        }else if(moving==MOVING_END){
            setMaxValue(((rect().height()-e->pos().y())*rangeMaxVal)/rect().height());
        }
    }
    update();
}




/*!
    \fn RangeIndicatorWidget::setMinimumRange(int)
 */
void RangeIndicatorWidget::setMinimumRange(int minRange)
{
    minimumRange=minRange;
}


/*!
    \fn RangeIndicatorWidget::minValue()
 */
int RangeIndicatorWidget::minValue()
{
    return minVal;
}


/*!
    \fn RangeIndicatorWidget::maxValue()
 */
int RangeIndicatorWidget::maxValue()
{
    return maxVal;
}
