#!/usr/bin/env perl

use strict;
my %patches;

# Parse a TEXTURE1 file and generate a list of patches

sub parse_texture_file {

        while (<>) {
                if (/^\*/) { 
                        my ($name) = /^\*\s+(\w+)/;
                        $name = uc $name;
                        $patches{$name} = 1;
                }
        }

        print "; autogenerated patch list\n\n";

        foreach (sort keys %patches) { print "$_\n"; }
}

# Generate a full list of textures from the files in the
# patches/ directory

sub list_all_textures {
        print "; autogenerated patch list\n\n";

        foreach my $file (glob("patches/*.gif")) {
                if ($file =~ /\/(.*)\.gif/) {
                        print "$1\n";
                }
        }
}

if (scalar @ARGV == 0) {
        parse_texture_file();
} elsif ($ARGV[0] == "-a") {
        list_all_textures();
} else {
        print "Usage: extract-pnames.pl [-a]\n";
}

