//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryConditionExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef _BOUNDARYCONDITION_EXPRESSION_HPP_
#define _BOUNDARYCONDITION_EXPRESSION_HPP_

#include <Expression.hpp>
#include <Variable.hpp>

#include <BoundaryExpression.hpp>
/*!
  \class BoundaryConditionExpression

  This class defines the base class of BoundaryCondition expressions

  \author Stephane Del Pino
 */
class BoundaryCondition;
class BoundaryConditionExpression
  : public Expression
{
protected:
  ReferenceCounting<BoundaryCondition> __boundaryCondition;

  ReferenceCounting<BoundaryExpression> __boundary;

  ReferenceCounting<FunctionVariable> __unknown;

public:
  enum BoundaryConditionType {
    dirichlet,
    neumann,
    fourrier // known as robin too.
  };

  ReferenceCounting<FunctionVariable> unknown() const
  {
    return __unknown;
  }

private:
  BoundaryConditionExpression::BoundaryConditionType __boundaryConditionType;

public:
  ReferenceCounting<BoundaryCondition> boundaryCondition();

  const BoundaryConditionExpression::BoundaryConditionType& boundaryConditionType() const
  {
    return __boundaryConditionType;
  }

  BoundaryConditionExpression(const BoundaryConditionExpression& e);

  BoundaryConditionExpression(ReferenceCounting<BoundaryExpression> boundary,
			      ReferenceCounting<FunctionVariable> unknown,
			      const BoundaryConditionExpression::BoundaryConditionType& t);

  virtual ~BoundaryConditionExpression();
};

/*!
  \class BoundaryConditionExpressionDirichlet

  This class defines the class of dirichlet BoundaryCondition expressions.

  \author Stephane Del Pino
 */
class BoundaryConditionExpressionDirichlet
  : public BoundaryConditionExpression
{
private:
  ReferenceCounting<FunctionExpression> __g;

  std::ostream& put(std::ostream& os) const;

public:
  void execute();

  BoundaryConditionExpressionDirichlet(ReferenceCounting<FunctionVariable> unknown,
				       ReferenceCounting<FunctionExpression> g,
				       ReferenceCounting<BoundaryExpression> boundary);

  BoundaryConditionExpressionDirichlet(const BoundaryConditionExpressionDirichlet& d);

  ~BoundaryConditionExpressionDirichlet();
};

/*!
  \class BoundaryConditionExpressionNeumann

  This class defines the class of neumann BoundaryCondition expressions.

  \author Stephane Del Pino
 */
class BoundaryConditionExpressionNeumann
  : public BoundaryConditionExpression
{
private:
  ReferenceCounting<FunctionExpression> __g;

  std::ostream& put(std::ostream& os) const;

public:
  void execute();

  BoundaryConditionExpressionNeumann(ReferenceCounting<FunctionVariable> unknown,
				     ReferenceCounting<FunctionExpression> g,
				     ReferenceCounting<BoundaryExpression> boundary);

  BoundaryConditionExpressionNeumann(const BoundaryConditionExpressionNeumann& n);

  ~BoundaryConditionExpressionNeumann();
};


/*!
  \class BoundaryConditionExpressionFourrier

  This class defines the class of fourrier BoundaryCondition expressions.

  \author Stephane Del Pino
 */
class BoundaryCondition;
class BoundaryConditionExpressionFourrier
  : public BoundaryConditionExpression
{
private:
  ReferenceCounting<FunctionExpression> __alpha;
  ReferenceCounting<FunctionExpression> __g;

  std::ostream& put(std::ostream& os) const;

public:
  void execute();

  BoundaryConditionExpressionFourrier(ReferenceCounting<FunctionVariable> unknown,
				      ReferenceCounting<FunctionExpression> alpha,
				      ReferenceCounting<FunctionExpression> g,
				      ReferenceCounting<BoundaryExpression> boundary);

  BoundaryConditionExpressionFourrier(const BoundaryConditionExpressionFourrier& f);

  ~BoundaryConditionExpressionFourrier();
};

#endif // _BOUNDARYCONDITION_EXPRESSION_HPP_

