//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Information.cpp,v 1.2 2004/03/27 16:16:07 delpinux Exp $

#include <Information.hpp>

#include <MeshExpression.hpp>
#include <UnknownListExpression.hpp>
#include <Scene.hpp>

ReferenceCounting<MeshExpression> Information::getMesh()
{
  assert(!__mesh.empty());
  return __mesh.top();
}

void Information::setMesh(ReferenceCounting<MeshExpression> mesh)
{
  __mesh.push(mesh);
}

void Information::unsetMesh()
{
  __mesh.pop();
}

const bool Information::usesMesh() const
{
  return (!__mesh.empty());
}

ReferenceCounting<Scene> Information::getScene()
{
  return __scene;
}

void Information::setScene(ReferenceCounting<Scene> scene)
{
  __scene = scene;
}

const bool Information::usesScene() const
{
  return (__scene != 0);
}

void Information::unsetScene()
{
  __scene = 0;
}

ReferenceCounting<UnknownListExpression> Information::getUnknownList()
{
  return __unknownListExpression;
}

void Information::setUnknownList(ReferenceCounting<UnknownListExpression> u)
{
  __unknownListExpression = u;
}

const bool Information::usesUnknownList() const
{
  return (__unknownListExpression != 0);
}


void Information::unsetUnknownList()
{
  __unknownListExpression = 0;
}

Information::Information()
  : __scene(0),
    __unknownListExpression(0)
{
  ;
}

Information::Information(const Information& I)
  : __mesh(I.__mesh),
    __scene(I.__scene),
    __unknownListExpression(I.__unknownListExpression)
{
  ;
}

Information::~Information()
{
  ;
}

