//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MeshSimplifier.hpp,v 1.3 2004/04/29 16:04:13 dobj Exp $

#ifndef MESHSIMPLIFIER_HPP
#define MESHSIMPLIFIER_HPP

#include <MeshGenerator.hpp>
#include <set>
#include <list>
class MeshSimplifier
  : public MeshGenerator
{
private:

  template <typename ElementType>
  struct EdgeDelete {
    Edge::Pair  edel;
    ElementType* Tdel;
    bool exist;
  }; 

  Edge::Pair __order(const Edge::Pair& ed);

  template <typename MeshType>
  void __proceed(const MeshType& m);
  

  struct Internals
  {
    
    struct ltv
  {
    bool operator() (const Edge::Pair& e1, const Edge::Pair& e2) const
  {
    if (e1.first == e2.first) {
	return (e1.second < e2.second);
    } else {
	return (e1.first < e2.first);
    }
  }
  };
    
    struct eq
    {
	bool operator() (const Edge::Pair& e1, const Edge::Pair& e2) const
    {
      return ((e1.first == e2.first) and (e1.second == e2.second));
    }
    };  
    
    
    
  };

  template <typename ElementType>
  bool MeshSimplifier::__ElementExist(Vertex*& commonPoint,
				      Vertex*& otherPoint,
				      const Edge::Pair& en,
				      ElementType* j,
				      std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements);
  template <typename ElementType>
  void __grepDelete(Vertex*& commonPoint,
		    Vertex*& otherPoint,
		    const Edge::Pair& en,
		    Edge::Pair& edelete,
		    ElementType* j);

  template <typename ElementType>
  bool MeshSimplifier::__CheckElement(Vertex*& commonPoint,
				      Vertex*& otherPoint,
				      const typename std::set<ElementType*>::iterator& j,
				      std::set<ElementType*>& intermediateCells);

  template <typename ElementType>
  bool MeshSimplifier::__CheckEdge(const Edge& eT,
				   typename std::set<ElementType*>::iterator& jbegin,
				   const std::set<ElementType*> eTbegin);

  template <typename ElementType>
  bool MeshSimplifier::__CheckNotBegin(typename std::set<ElementType*>::iterator jT,
				       const std::set<ElementType*>& eTbegin);

  template <typename ElementType>
  void MeshSimplifier::__CaseDelete2Element(size_t & frontSize,
					    Vertex*& commonPoint,
					    Vertex*& otherPoint,
					    const typename std::set<ElementType*>::iterator& jT,
					    Edge::Pair& eadd,
					    Edge::Pair& edelete,
					    const std::set<ElementType*>& eTbegin,
					    std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
					    std::list<Edge::Pair>& edgesList,
					    std::set<ElementType*>& intermediateCells );
  
  template <typename ElementType>
    bool MeshSimplifier::__NotIsEdge(const TinyVector<3,Vertex*>& Cav,
						 Edge& en);
  
  template <typename ElementType>
    bool MeshSimplifier::__NotIsEdgeDelete(const Vertex* commonPoint,
							 const Vertex* otherPoint,
							 Edge& en);
  template <typename ElementType>
    bool MeshSimplifier::__NotHaveTriangle(const TinyVector<3,Vertex*>& Cav,
						   ElementType* T);
  
  template <typename ElementType>
    void MeshSimplifier::__ConstructConnectivity(size_t& frontSize,
						    typename std::set<ElementType*>::iterator currentElt,
						    const std::set<ElementType*>& eTbegin,
						    Vertex*& commonPoint,
						    Vertex*& otherPoint,
						    Edge::Pair& eadd,
						    Edge::Pair& edelete,
						    std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
						    std::list<Edge::Pair>& edgesList,
						    std::set<ElementType*>& intermediateCells,
								 std::set<ElementType*>& eTend);
  
  template <typename ElementType>
    void MeshSimplifier::__DeleteCavity(const TinyVector<3,Vertex*>& Cav,
						    size_t& frontSize,
						typename std::set<ElementType*>::iterator currentElt,
						const std::set<ElementType*>& eTbegin,
						Vertex*& commonPoint,
					      Vertex*& otherPoint,
						Edge::Pair& eadd,
						Edge::Pair& edelete,
						std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
						std::list<Edge::Pair>& edgesList,
						std::set<ElementType*>& intermediateCells,
						    std::set<ElementType*>& eTend);
  
  template <typename ElementType>
  bool MeshSimplifier::__testLink(size_t& frontSize,
						typename std::set<ElementType*>::iterator currentElt,
						const std::set<ElementType*>& eTbegin,
						Vertex*& commonPoint,
						Vertex*& otherPoint,
						Edge::Pair& edelete,
						std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
						std::list<Edge::Pair>& edgesList,
						std::set<ElementType*>& intermediateCells);
  template <typename ElementType>
  void MeshSimplifier::__deletePutedge(size_t& frontSize,
		       typename std::set<ElementType*>::iterator j,
		       const std::set<ElementType*>& eTbegin,
		       Vertex*& commonPoint,
		       Vertex*& otherPoint,
		       Edge::Pair& edelete,
		       std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
		       std::list<Edge::Pair>& edgesList,
		       std::set<ElementType*>& intermediateCells);
  


  template <typename ElementType>
  void MeshSimplifier::__FindAddTriangle(Vertex *commonPoint,
					 Vertex *otherPoint,
					 const std::set<ElementType*>&  eTbegin,
					 ElementType* currentElt, 
					 Edge::Pair& ed1,
					 Edge::Pair& eadd1,
					 std::set<ElementType*>& eAdd,
					 std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements);
  template <typename ElementType>
  void MeshSimplifier::__TriangleExist(size_t& frontSize,
				       Vertex *commonPoint,
				       Vertex *otherPoint,
				       Edge::Pair eadd,
				       Edge::Pair edelete,
				       ElementType* currentElt,
				       const std::set<ElementType*>& eTbegin,
				       std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
				       std::list<Edge::Pair>& edgesList,
				       std::set<ElementType*>& intermediateCells) ;

  template <typename ElementType>
  void MeshSimplifier::__OrientEdge(Edge::Pair& eadd,
				    typename std::set<ElementType*> eT);
  template <typename ElementType>
  bool MeshSimplifier::__findReplaceEdge(bool& isDelete,
					 size_t& frontSize,
					 typename std::set<ElementType*>::iterator j,
					 const std::set<ElementType*>& eT,
					 Vertex*& commonPoint,
					 Vertex*& otherPoint,
					 const Edge::Pair& en,
					 std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
					 std::list<Edge::Pair>& edgesList,
					 std::set<ElementType*>& intermediateCells,
					 std::vector<EdgeDelete<ElementType> >& vEdgeDelete);
  
  template <typename ElementType>
  void MeshSimplifier::__findCommonOther(Vertex*& commonPoint,
					 Vertex*& otherPoint,
					 const Edge::Pair& e,
					 ElementType& T);
  
  template <typename ElementType>
  void MeshSimplifier::__DeleteTriangle(size_t nTr,
					size_t& frontSize,
					ElementType& T,
					Vertex*& otherPoint,
					Vertex*& commonPoint,
					const Edge::Pair& e,
					std::set<ElementType*> eAdd,
					std::map<Edge::Pair, std::set<ElementType*>, MeshSimplifier::Internals::ltv >& edgeElements,
					std::list<Edge::Pair>& edgesList);
public:
  
  /** 
   * Constructor
   * 
   * @param originalMesh the mesh to simplify
   * 
   */
  MeshSimplifier(ReferenceCounting<Mesh> originalMesh);

  /**
   * Copy constructor
   * 
   */
  MeshSimplifier(const MeshSimplifier& m);

  /** 
   * Destructor
   * 
   * 
   * @return 
   */
  ~MeshSimplifier()
  {
    ;
  }
};

#endif // MESHSIMPLIFIER_HPP
