//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Pascal Have

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

//  $Id: connected_triangle.hpp,v 1.2 2003/11/20 09:31:55 dobj Exp $

#ifndef CONNECTED_TRIANGLE_HPP
#define CONNECTED_TRIANGLE_HPP

#include <assert.h>
#include <Triangle.hpp>

class ConnectedTriangle; // prdclaration

typedef Vertex*  PointIndex;
typedef ConnectedTriangle * TriangleIndex;

class ConnectedTriangle : public Triangle {
private:
  TriangleIndex neighs[3];

  inline void initNeighs() {
    neighs[0] = NULL;
    neighs[1] = NULL;
    neighs[2] = NULL;
  }

public:
  int tag;
  ConnectedTriangle() { initNeighs(); tag=0; }

  ConnectedTriangle(const PointIndex & s1,const PointIndex & s2,const PointIndex & s3) : Triangle(*s1,*s2,*s3) { 
    initNeighs(); 
    tag=0; 
  }

  ConnectedTriangle(const PointIndex & s1,const PointIndex & s2,const PointIndex & s3,
		    const TriangleIndex & v1,const TriangleIndex & v2,const TriangleIndex & v3) : Triangle(*s1,*s2,*s3) {
    neighs[0] = v1;
    neighs[1] = v2;
    neighs[2] = v3;
    tag = 0;
  }

  ConnectedTriangle(const ConnectedTriangle & t) : Triangle(t) {
    neighs[0] = t.neighs[0];
    neighs[1] = t.neighs[1];
    neighs[2] = t.neighs[2];
    tag = t.tag;
  }
  
  /*! Pas de dsallocation car sinon perte du trgle point */
  ~ConnectedTriangle() { }

  //base
  Vertex**  base()  {
      return __vertices;
  }

  const TriangleIndex & neigh(const unsigned k) const { assert(k < 3); return neighs[k]; }
  TriangleIndex & neigh(const unsigned k) { assert(k < 3); return neighs[k]; }

  //! Modification globale des sommets.
  void setVertices(const PointIndex &s1,const PointIndex &s2,const PointIndex &s3) {
    assert(s1 != s2 & s2 != s3 & s3 !=s1); // A remettre pour un bon debug de insert_point.    
    __vertices[0]=s1; __vertices[1]=s2; __vertices[2]=s3; 
  }
  
  //! Modification globale des voisins.
  void setNeighs(const TriangleIndex &v1,const TriangleIndex &v2,const TriangleIndex &v3) {
    neighs[0]=v1; neighs[1]=v2; neighs[2]=v3;
  }
  
  //! determine le numero associe au sommet P
  unsigned localizeVertex(const PointIndex & P)  {
    unsigned local = 0;
    while(base()[local] != P) {
      ++local;
      assert(local < 3);
    }
    return local;
  }

  //! determine le numero associe au voisin N
  unsigned localizeNeigh(const ConnectedTriangle * const N) const {
    unsigned local = 0;
    while(neighs[local] != N) {
      ++local; 
      assert(local < 3); 
    }
    return local;
  }
};

#endif /* CONNECTED_TRIANGLE_HPP */
