//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FFThread.cpp,v 1.7 2005/01/02 15:17:13 delpinux Exp $

#include <FFThread.hpp>

#include <StreamCenter.hpp>
#include <ThreadStaticCenter.hpp>
#include <Timer.hpp>

#include <ReferenceCounting.hpp>

#include <FFLexer.hpp>
#include <ParametersInitialization.hpp>

#include <RealExpression.hpp>

#include <Expression.hpp>
#include <Instruction.hpp>

#include <ErrorHandler.hpp>

#include <vector>
#include <fstream>

// The lexer pointer.
Lexer* fflexer;

// The parser function.
int ffparse();

std::vector<ReferenceCounting<Instruction> > iSet;
VariableList variableList;

void FFThread::launch()
{
  try {
    this->run();
  }
  catch(ErrorHandler e) {
    e.writeErrorMessage();    
  }
  catch(...) {
    fferr(0) << "error: Unknown exception caught!\n";
    fferr(0) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
  }
}

void FFThread::end()
{
  this->join();
}

void FFThread::run()
{
  ThreadStaticCenter threadStaticCenter;

  Timer totalTime;
  totalTime.start();

  ParametersInitialization();

  ffout(1) << "Parsing the file ...";
  {
    fflexer = new FFLexer(__in);
    ffparse();
    delete fflexer;
  }
  ffout(1) << " done\n";

  ffout(1) << "Treating data\n";
  for (std::vector<ReferenceCounting<Instruction> >::iterator i = iSet.begin();
       i != iSet.end(); ++i) {
    (*(*i)).execute();
  }
  ffout(1) << "done\n";

  iSet.clear();
  variableList.clear();

  totalTime.stop();
  ffout(1) << "Thread execution time: " << totalTime << '\n';
}

FFThread::FFThread(std::istream& in)
  : __in(in)
{
  ;
}

FFThread::~FFThread()
{
  this->join();
}
