//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: StreamCenter.hpp,v 1.1.1.1 2003/02/17 16:32:50 delpinux Exp $

#ifndef  _STREAMCENTER_HPP_
#define  _STREAMCENTER_HPP_

#include <iostream>
#include <StaticBase.hpp>

class StreamCenter
  : public StaticBase<StreamCenter>
{
private:
  friend class StaticCenter;

  int __debugLevel;

  //! used as a black hole to write unwanted output.
  std::ostream __nullStream;

  //! Mainly used to write output in a file.
  std::ostream* __log;

  //! standard output
  std::ostream* __out;

  //! error output
  std::ostream* __err;

  //! forbides the copy constructor.
  StreamCenter(const StreamCenter& SC);

public:

  inline std::ostream& log(int i)
  {
    if (i<=__debugLevel)
      return *__log;
    else
      return __nullStream;
  }

  inline std::ostream& out(int i)
  {
    if (i<=__debugLevel)
      return *__out;
    else
      return __nullStream;
  }

  inline std::ostream& err(int i)
  {
    if (i<=__debugLevel)
      return *__err;
    else
      return __nullStream;
  }

  const int getDebugLevel() const
  {
    return __debugLevel;
  }

  void setDebugLevel(int i)
  {
    __debugLevel = i;
  }

  StreamCenter();

  ~StreamCenter()
  {
    delete __log;
  }

}; /**< auto instanciation */

//! these functions are used as short cuts (ie: aliases).
inline std::ostream& fflog(int i)
{
  return StreamCenter::instance().log(i);
}

inline std::ostream& ffout(int i)
{
  return StreamCenter::instance().out(i);
}

inline std::ostream& fferr(int i)
{
  return StreamCenter::instance().err(i);
}
#endif //_STREAMCENTER_HPP_

