//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Stringify.hpp,v 1.2 2004/11/28 18:15:20 delpinux Exp $

#ifndef STRINGIFY_HPP
#define STRINGIFY_HPP

#include <string>
#include <sstream>

/**
 * @file   Stringify.hpp
 * @author Pascal Have
 * @date   Sun Nov 28 18:59:11 2004
 * 
 * @brief  converts writable objects to std::string
 * 
 */

/** 
 * stringify function
 * 
 * @param t an object that supports operator<<
 * 
 * @return a string
 */
template<typename T> 
std::string stringify(const T & t)
{
  std::ostringstream oss;
  oss << t << std::ends;
  return oss.str();
}

#endif // STRINGIFY_HPP
