/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.RetroWeaver;
import com.rc.retroweaver.RetroWeaverClassLoader;
import com.rc.retroweaver.RetroWeaverException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;

public class WeaveRunner {
    private RetroWeaver retroWeaver;
    private RetroWeaverClassLoader classLoader;
    private static final String nl = System.getProperty("line.separator");

    public WeaveRunner(String classPath) {
        int target;
        String version = System.getProperty("java.version");
        switch (version.charAt(2)) {
            case '2': {
                target = 46;
                break;
            }
            case '3': {
                target = 47;
                break;
            }
            case '4': {
                target = 48;
                break;
            }
            case '5': {
                target = 49;
                break;
            }
            default: {
                throw new RetroWeaverException("Unsupported JVM version: " + version);
            }
        }
        this.retroWeaver = new RetroWeaver(target);
        this.retroWeaver.setLazy(true);
        this.classLoader = new RetroWeaverClassLoader();
        this.classLoader.setClassPath(classPath);
        this.classLoader.setWeaver(this.retroWeaver);
    }

    public void run(String className, String[] args) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = this.classLoader.loadClass(className);
        Method m = clazz.getMethod("main", args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException ite) {
            throw new RetroWeaverException(ite);
        }
    }

    public void executeJar(String jarFileName, String[] args) throws ClassNotFoundException, NoSuchMethodException {
        this.classLoader.addJarClassPathElement(jarFileName);
        String className = null;
        try {
            URL u = new URL("jar:file:" + jarFileName + "!/");
            JarURLConnection uc = (JarURLConnection)u.openConnection();
            Attributes attr = uc.getMainAttributes();
            if (attr != null) {
                className = attr.getValue(Attributes.Name.MAIN_CLASS);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (className == null) {
            System.err.println("No " + Attributes.Name.MAIN_CLASS + " specified in jar file " + jarFileName);
        } else {
            this.run(className, args);
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException {
        String classPath = null;
        String mainClass = null;
        String jarFileName = null;
        int argIndex = 0;
        while (argIndex < args.length) {
            String command;
            if ((command = args[argIndex++]).equals("-cp") || command.equals("-classpath")) {
                classPath = args[argIndex++];
                continue;
            }
            if (command.equals("-jar")) {
                jarFileName = args[argIndex++];
                break;
            }
            mainClass = command;
            break;
        }
        if (jarFileName == null) {
            String errorMsg = null;
            if (classPath == null) {
                errorMsg = "Missing class path";
            }
            if (mainClass == null) {
                errorMsg = "Missing main class or jar option";
            }
            if (errorMsg != null) {
                System.out.println(errorMsg);
                System.out.println();
                WeaveRunner.usage();
                return;
            }
        }
        String[] realArgs = new String[args.length - argIndex];
        System.arraycopy(args, argIndex, realArgs, 0, args.length - argIndex);
        WeaveRunner runner = new WeaveRunner(classPath);
        if (jarFileName != null) {
            runner.executeJar(jarFileName, realArgs);
        } else {
            runner.run(mainClass, realArgs);
        }
    }

    private static void usage() {
        String msg = "Usage: WeaveRunner [-options] class [args...]" + nl + "\t\t(to execute a class)" + nl + "\tor WeaveRunner [-options] -jar jarfile [args...]" + nl + "\t\t(to execute a jar file)" + nl + nl + "where options include:" + nl + "\t-cp <class search path of directories and zip/jar files>" + nl + "\t-classpath <class search path of directories and zip/jar files>" + nl + "\t\tA " + File.pathSeparatorChar + " separated list of directories, JAR archives," + nl + "\t\tand ZIP archives to search for class files." + nl;
        System.out.println(msg);
    }
}

