/*  FreeJ
 *  (c) Copyright 2001 Denis Roio aka jaromil <jaromil@dyne.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 * this file includes a malloc wrapper, it acts very verbose when debug
 * mode allow it
 */

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <sched.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <jutils.h>
#include <config.h>

#define MAX_DEBUG 2

#define FUNC 2 /* se il debug level e' questo
		  ci sono le funzioni chiamate */
#define WARN 1 /* ... blkbblbl */

static int verbosity;
static char msg[255];
static char *osd_msg;

void set_debug(int lev) {
  lev = lev<0 ? 0 : lev;
  lev = lev>MAX_DEBUG ? MAX_DEBUG : lev;
  verbosity = lev;
}

int get_debug() {
  return(verbosity);
}

void set_osd(char *st) {
  osd_msg = st;
  osd_msg[0] = '\0';
}

void show_osd() {
  strncpy(osd_msg,msg,49);
  osd_msg[50] = '\0';
}

void show_osd(char *format, ...) {
  va_list arg;
  va_start(arg, format);
  
  vsnprintf(osd_msg,49, format, arg);
  osd_msg[50] = '\0';
  va_end(arg);
}

void notice(char *format, ...) {
  va_list arg;
  va_start(arg, format);

  vsnprintf(msg, 254, format, arg);
  fprintf(stderr,"[*] %s\n",msg);

  va_end(arg);
}

void func(char *format, ...) {
  if(verbosity>=FUNC) {
    va_list arg;
    va_start(arg, format);
    
    vsnprintf(msg, 254, format, arg);
    fprintf(stderr,"[F] %s\n",msg);

    va_end(arg);
  }
}

void error(char *format, ...) {
  va_list arg;
  va_start(arg, format);
  
  vsnprintf(msg, 254, format, arg);
  fprintf(stderr,"[!] %s\n",msg);

  va_end(arg);
}

void act(char *format, ...) {
  va_list arg;
  va_start(arg, format);
  
  vsnprintf(msg, 254, format, arg);
  fprintf(stderr," .  %s\n",msg);
  
  va_end(arg);
}

void warning(char *format, ...) {
  if(verbosity>=WARN) {
    va_list arg;
    va_start(arg, format);
    
    vsnprintf(msg, 254, format, arg);
    fprintf(stderr,"[W] %s\n",msg);
  
    va_end(arg);
  }
}

void *jalloc(void *point,size_t size) {
  if(point!=NULL)
    if(verbosity>0) warning("requested malloc on a non-NULL pointer");
  
  point = malloc(size);

  if(point==NULL) {
    error("cannot allocate %u bytes of memory",size);
    return(NULL);
  } else if(verbosity>=FUNC) {
    fprintf(stderr,"[M] allocated memory at %p sized %u bytes\n",point,(unsigned int)size);
  }
  return(point);
}

bool jfree(void *point) {

  if(point==NULL) {
    warning("requested free on a NULL pointer");
    return(false);
  }
  
  if(verbosity>=FUNC)
    fprintf(stderr,"[M] freeing memory at address %p\n",point);

  free(point);
  point = NULL;
  return(true);
}

/*
 * fastrand - fast fake random number generator
 * by Fukuchi Kentarou
 * Warning: The low-order bits of numbers generated by fastrand()
 *          are bad as random numbers. For example, fastrand()%4
 *          generates 1,2,3,0,1,2,3,0...
 *          You should use high-order bits.
 *
 */

static Uint32 randval;

Uint32 fastrand()
{
	return (randval=randval*1103515245+12345);
}

void fastsrand(Uint32 seed)
{
	randval = seed;
}

double dtime() {
  /* will this work one day?
     unsigned long long int x;
     act("asm gettime");
     __asm__ volatile (".byte 0x0f, 0x31" : "=A" (x));
     return ((double)x);
  */
  struct timeval mytv;
  gettimeofday(&mytv,NULL);
  return((double)mytv.tv_sec+1.0e-6*(double)mytv.tv_usec);
}

/* sets the process to "policy" policy,  if max=1 then set at max priority,
   else use min priority */

bool set_rtpriority(bool max) {
  struct sched_param schp;
  // set the process to realtime privs

  memset(&schp, 0, sizeof(schp));
  
  if(max) 
    schp.sched_priority = sched_get_priority_max(SCHED_RR);
  else
    schp.sched_priority = sched_get_priority_min(SCHED_RR);
  
  if (sched_setscheduler(0, SCHED_RR, &schp) != 0)
    return false;
  else
    return true;
}

void jsleep(int sec, long nsec) {
  timespec timelap;
  timelap.tv_sec = sec;
  timelap.tv_nsec = nsec;
  nanosleep(&timelap,NULL);
}
