/*
---------------------------------------------------------------------------
 $Id: auth.h,v 1.4 2003/08/11 15:18:22 jfboud Exp $
---------------------------------------------------------------------------
Copyright (c) 2001-2003 Hexago Inc. All rights reserved.

     The contents of this file are subject to the Hexago
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License.

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Hexago .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

typedef unsigned int tCapability;

/*
   Capability bytes

   16      8      1
   |-------|------|
               `--' - TUNNEL TYPE 1-4
           `--' AUTH METHOD 5-8
   `------' RESERVED 9-16
*/

#define TUNNEL_V6V4	0x0001
#define AUTH_DIGEST_MD5	0x0040
#define AUTH_PLAIN	0x0020
#define AUTH_ANONYMOUS	0x0010
#define AUTH_ANY	0x00F0
#define TUNNEL_ANY	0x000F

int         Authenticate(int Socket, char * Method, char *User, char *Passwd, char *host);
tCapability SetCapability(char *Token, char *Value);
tCapability ExtractCapability(char *String);
int AuthANONYMOUS(int Socket);
int AuthPLAIN(int socket, char *User, char *Passwd);
int AuthDIGEST_MD5(int Socket, char *User, char *Passwd, char *Host);

struct sChallenge {
   char *realm,
        *nonce,
        *qop,
        *algorithm,
        *charset,
        *rspauth;
};

typedef struct sChallenge tChallenge;
