
/*
---------------------------------------------------------------------------
 Configuration file handling.
 $Id: config.c,v 1.4 2003/08/11 15:18:22 jfboud Exp $
---------------------------------------------------------------------------
Copyright (c) 2001-2003 Hexago Inc. All rights reserved.

     The contents of this file are subject to the Hexago
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License.

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Hexago .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "config.h"

/* Verify dns server for dns delegation */
int VerifyDnsServer(char* server)
{
	char buffer[16];
	
	if(inet_pton(AF_INET, server, buffer)==0 && inet_pton(AF_INET6, server, buffer)==0)
		return 1; 

	return 0;
}



/* Add option to configuration struct */
int
AddOption(char *Option, char *Value, tConf *Conf)
{
  if (strcmp(Option, "tsp_dir") == 0) {
    Conf->tsp_dir = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "tsp_version") == 0) {
    Conf->tsp_version = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "server") == 0) {
    Conf->server = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "client_v4") == 0) {
    Conf->client_v4 = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "userid") == 0) {
    Conf->userid = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "passwd") == 0) {
    Conf->passwd = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "auth_method") == 0) {
    Conf->auth_method = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "host_type") == 0) {
    Conf->host_type = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "template") == 0) {
    Conf->template = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "protocol") == 0) {
    Conf->protocol = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "if_tunnel") == 0) {
    Conf->if_tunnel = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "if_source") == 0) {
    Conf->if_source = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "dns_server") == 0) {
    if(VerifyDnsServer(strdup(Value))) {
    	Conf->dns_server = strdup(Value);
	return 0;
    }
    printf("The DNS server must be FDQN address, not a numeric IP address.\n");
    return 1;
  }
  if (strcmp(Option, "routing_info") == 0) {
    Conf->routing_info = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "if_prefix") == 0) {
    Conf->if_prefix = strdup(Value);
    return 0;
  }
  if (strcmp(Option, "prefixlen") == 0) {
    Conf->prefixlen = atoi(Value);
    return 0;
  }
  if (strcmp(Option, "retry_delay") == 0) {
     Conf->retry = atoi(Value);
     return 0;
  }
  return 1;
}

int
ReadConfigFile(char *File, tConf *Conf)
{
  FILE *fp;
  int Line = 0, err = 0;
  char *Option, *Value, Buffer[1024], Buffer2[1024], LineBuf[1024];

  if ((fp = fopen(File, "r")) == NULL) {
     perror(File);
     return 1;
  }

  while (fgets(Buffer, sizeof(Buffer), fp)) {
    Line++;
    if (*Buffer == '#' || *Buffer == '\r' || *Buffer == '\n')
      continue;

    if (strlen(Buffer) && (Buffer[strlen(Buffer)-1] == '\n' || Buffer[strlen(Buffer)-1] == '\r'))
      Buffer[strlen(Buffer)-1] = '\0';

    if (strlen(Buffer) && (Buffer[strlen(Buffer)-1] == '\n' || Buffer[strlen(Buffer)-1] == '\r'))
      Buffer[strlen(Buffer)-1] = '\0';
     
    if((Option = strtok(Buffer, "=")) != NULL)  {
       if ((Value = strtok(NULL, "=")) == NULL) Value = "";
       if (memcmp(Value, "<<", 2)==0) {
         memset(Buffer2, 0, sizeof(Buffer));
         while (fgets(LineBuf, sizeof(LineBuf), fp)) {
            if (*LineBuf == '.') break;
            /* Check for string overflow */
            if (strlen(Buffer2) + strlen(LineBuf) + 1 > sizeof(Buffer2))
               err++;
            else
               strcat(Buffer2, LineBuf);
         }
         Value = Buffer2;
       }
       if (AddOption(Option, Value, Conf)==0)
         continue;
    }

    printf("Error in configuration file Line %i\n", Line);
    err++;
  }

  if (!feof(fp)) {
    err++;
  }

  fclose(fp);

  if (err) {
    return(1);
  }

  return(0);
}
