/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Event;
import java.awt.TextArea;
import java.util.Vector;
import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.exception.InvalidEventOutException;
import vrml.external.exception.InvalidNodeException;
import vrml.external.exception.InvalidVrmlException;
import vrml.external.field.EventInMFNode;
import vrml.external.field.EventInSFTime;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutObserver;
import vrml.external.field.EventOutSFBool;
import vrml.external.field.EventOutSFTime;

public class TicTacToeEAI
extends Applet
implements EventOutObserver {
    TextArea textArea = null;
    Browser browser = null;
    EventInMFNode rootAddChildren = null;
    EventInMFNode rootRemoveChildren = null;
    EventOutSFTime[] touchTimes = new EventOutSFTime[9];
    EventInSFTime checkDelayIn = null;
    EventOutSFBool checkDelayOut = null;
    EventInSFTime nextDelayIn = null;
    EventOutSFBool nextDelayOut = null;
    boolean error = false;
    Vector addedNodes = new Vector();
    boolean[] isFilled;
    boolean userTurn = true;
    boolean userCanClick = true;
    int white;
    int black;
    static final int[] moves;
    static boolean[] won;
    static final int DONE = 511;
    static final int OK = 0;
    static final int WIN = 1;
    static final int LOSE = 2;
    static final int STALEMATE = 3;
    boolean userFirst = true;

    static {
        int[] nArray = new int[9];
        nArray[0] = 4;
        nArray[2] = 2;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 1;
        nArray[6] = 3;
        nArray[7] = 5;
        nArray[8] = 7;
        moves = nArray;
        won = new boolean[512];
        TicTacToeEAI.isWon(7);
        TicTacToeEAI.isWon(56);
        TicTacToeEAI.isWon(448);
        TicTacToeEAI.isWon(73);
        TicTacToeEAI.isWon(146);
        TicTacToeEAI.isWon(292);
        TicTacToeEAI.isWon(273);
        TicTacToeEAI.isWon(84);
    }

    public boolean action(Event event, Object object) {
        if (this.error) {
            System.err.println("Had an error during initialization");
            return true;
        }
        Node[] nodeArray = new Node[this.addedNodes.size()];
        int n = 0;
        while (n < this.addedNodes.size()) {
            nodeArray[n] = (Node)this.addedNodes.elementAt(n);
            ++n;
        }
        this.rootRemoveChildren.setValue(nodeArray);
        this.addedNodes = new Vector();
        this.black = 0;
        this.white = 0;
        this.userFirst ^= true;
        this.userTurn = this.userFirst;
        this.nextDelayIn.setValue(this.currentTime());
        return true;
    }

    int bestMove(int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = 0;
        while (n6 < 9) {
            block9: {
                n4 = moves[n6];
                if ((n & 1 << n4) == 0 && (n2 & 1 << n4) == 0) {
                    n3 = n | 1 << n4;
                    if (won[n3]) {
                        return n4;
                    }
                    int n7 = 0;
                    while (n7 < 9) {
                        int n8;
                        if ((n3 & 1 << n7) != 0 || (n2 & 1 << n7) != 0 || !won[n8 = n2 | 1 << n7]) {
                            ++n7;
                            continue;
                        }
                        break block9;
                    }
                    if (n5 == -1) {
                        n5 = n4;
                    }
                }
            }
            ++n6;
        }
        if (n5 != -1) {
            return n5;
        }
        n4 = 0;
        while (n4 < 9) {
            n3 = moves[n4];
            if ((n & 1 << n3) == 0 && (n2 & 1 << n3) == 0) {
                return n3;
            }
            ++n4;
        }
        return -1;
    }

    public void callback(EventOut eventOut, double d, Object object) {
        EventOutSFBool eventOutSFBool;
        String string = (String)object;
        if (string.startsWith("touched")) {
            try {
                int n = Integer.parseInt(string.substring(7));
                this.userClicked(n - 1, d);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equals("checkForWin")) {
            EventOutSFBool eventOutSFBool2 = (EventOutSFBool)eventOut;
            if (!eventOutSFBool2.getValue()) {
                switch (this.status()) {
                    case 1: {
                        this.showMessage("You Lose!");
                        break;
                    }
                    case 2: {
                        this.showMessage("You Win!");
                        break;
                    }
                    case 3: {
                        this.showMessage("Stalemate!");
                        break;
                    }
                    default: {
                        this.nextDelayIn.setValue(this.currentTime());
                        break;
                    }
                }
            }
        } else if (string.equals("nextTurn") && !(eventOutSFBool = (EventOutSFBool)eventOut).getValue()) {
            if (this.userTurn) {
                this.userCanClick = true;
            } else if (this.black == 0) {
                this.computerClicked((int)(Math.random() * 9.0), d);
            } else {
                this.computerClicked(this.myMove(), d);
            }
        }
    }

    private void computerClicked(int n, double d) {
        try {
            Node[] nodeArray = this.browser.createVrmlFromString(this.moveVrml(n, false));
            this.rootAddChildren.setValue(nodeArray);
            this.addedNodes.addElement(nodeArray[0]);
        }
        catch (InvalidVrmlException invalidVrmlException) {}
        this.checkDelayIn.setValue(this.currentTime());
        this.userTurn = true;
    }

    private double currentTime() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public void init() {
        this.add(new Button("New Game"));
        this.textArea = new TextArea(12, 40);
        this.textArea.setEditable(false);
        this.add(this.textArea);
        try {
            this.browser = Browser.getBrowser((Applet)this);
            Node node = this.browser.getNode("root");
            this.rootAddChildren = (EventInMFNode)node.getEventIn("addChildren");
            this.rootRemoveChildren = (EventInMFNode)node.getEventIn("removeChildren");
            int n = 0;
            while (n < 9) {
                node = this.browser.getNode("touch" + (n + 1));
                this.touchTimes[n] = (EventOutSFTime)node.getEventOut("touchTime");
                this.touchTimes[n].advise((EventOutObserver)this, (Object)("touched" + (n + 1)));
                ++n;
            }
            node = this.browser.getNode("checkDelay");
            this.checkDelayIn = (EventInSFTime)node.getEventIn("set_startTime");
            this.checkDelayOut = (EventOutSFBool)node.getEventOut("isActive");
            this.checkDelayOut.advise((EventOutObserver)this, (Object)"checkForWin");
            node = this.browser.getNode("nextDelay");
            this.nextDelayIn = (EventInSFTime)node.getEventIn("set_startTime");
            this.nextDelayOut = (EventOutSFBool)node.getEventOut("isActive");
            this.nextDelayOut.advise((EventOutObserver)this, (Object)"nextTurn");
        }
        catch (InvalidNodeException invalidNodeException) {
            invalidNodeException.printStackTrace();
            this.textArea.appendText(invalidNodeException.getMessage());
            this.error = true;
        }
        catch (InvalidEventOutException invalidEventOutException) {
            invalidEventOutException.printStackTrace();
            this.textArea.appendText(invalidEventOutException.getMessage());
            this.error = true;
        }
        this.textArea.appendText("Welcome to VRML2.0 Tic-Tac-Toe Game.\n");
        this.textArea.appendText("Good Luck!\n");
    }

    static void isWon(int n) {
        int n2 = 0;
        while (n2 < 511) {
            if ((n2 & n) == n) {
                TicTacToeEAI.won[n2] = true;
            }
            ++n2;
        }
    }

    private String moveVrml(int n, boolean bl) {
        String string = "Transform { translation ";
        if (n == 0) {
            string = String.valueOf(string) + " -1 1 .25 ";
        } else if (n == 1) {
            string = String.valueOf(string) + " -1 0 .25 ";
        } else if (n == 2) {
            string = String.valueOf(string) + " -1 -1 .25 ";
        } else if (n == 3) {
            string = String.valueOf(string) + " 0 1 .25 ";
        } else if (n == 4) {
            string = String.valueOf(string) + " 0 0 .25 ";
        } else if (n == 5) {
            string = String.valueOf(string) + " 0 -1 .25 ";
        } else if (n == 6) {
            string = String.valueOf(string) + " 1 1 .25 ";
        } else if (n == 7) {
            string = String.valueOf(string) + " 1 0 .25 ";
        } else if (n == 8) {
            string = String.valueOf(string) + " 1 -1 .25 ";
        } else {
            return "";
        }
        string = bl && this.userFirst || !bl && !this.userFirst ? String.valueOf(string) + " children [ Shape { geometry Sphere { radius .25 } appearance Appearance { material Material { diffuseColor 1 0 0 }}}]}" : String.valueOf(string) + " rotation 1 0 0 1.57 children [ Shape { geometry Cone { bottomRadius .25 height .5 } appearance Appearance { material Material { diffuseColor 0 1 0 }}}]}";
        return string;
    }

    int myMove() {
        if ((this.black | this.white) == 511) {
            return -1;
        }
        int n = this.bestMove(this.white, this.black);
        this.white |= 1 << n;
        return n;
    }

    private void showMessage(String string) {
        this.textArea.appendText(String.valueOf(string) + "\n");
        try {
            Node[] nodeArray = this.browser.createVrmlFromString("Transform { translation 0 0 2.3 children [ Shape { geometry Text { string \"" + string + "\" fontStyle FontStyle { justify [ \"MIDDLE\" \"MIDDLE\" ] size 1 } maxExtent 3 } appearance Appearance { material Material { diffuseColor 1 1 1 } } } ] }");
            this.rootAddChildren.setValue(nodeArray);
            this.addedNodes.addElement(nodeArray[0]);
        }
        catch (InvalidVrmlException invalidVrmlException) {}
    }

    int status() {
        if (won[this.white]) {
            return 1;
        }
        if (won[this.black]) {
            return 2;
        }
        if ((this.black | this.white) == 511) {
            return 3;
        }
        return 0;
    }

    private void userClicked(int n, double d) {
        if (!this.userCanClick) {
            return;
        }
        if (this.yourMove(n)) {
            try {
                Node[] nodeArray = this.browser.createVrmlFromString(this.moveVrml(n, true));
                this.rootAddChildren.setValue(nodeArray);
                this.addedNodes.addElement(nodeArray[0]);
            }
            catch (InvalidVrmlException invalidVrmlException) {}
            this.userCanClick = false;
            this.userTurn = false;
            this.checkDelayIn.setValue(this.currentTime());
        }
    }

    boolean yourMove(int n) {
        if (n < 0 || n > 8) {
            return false;
        }
        if (((this.black | this.white) & 1 << n) != 0) {
            return false;
        }
        this.black |= 1 << n;
        return true;
    }
}

