(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2592,         93]*)
(*NotebookOutlinePosition[      3232,        116]*)
(*  CellTagsIndexPosition[      3188,        112]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(n = {nx, ny, nz}\)], "Input"],

Cell[BoxData[
    \({nx, ny, nz}\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cross[Cross[n, {1, 0, 0}], n]\)], "Input"],

Cell[BoxData[
    \({ny\^2 + nz\^2, \(-nx\)\ ny, \(-nx\)\ nz}\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cross[Cross[n, {0, 1, 0}], n]\)], "Input"],

Cell[BoxData[
    \({\(-nx\)\ ny, nx\^2 + nz\^2, \(-ny\)\ nz}\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cross[Cross[n, {0, 0, 1}], n]\)], "Input"],

Cell[BoxData[
    \({\(-nx\)\ nz, \(-ny\)\ nz, nx\^2 + ny\^2}\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{884, 788},
WindowMargins->{{58, Automatic}, {Automatic, 15}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 49, 1, 27, "Input"],
Cell[1791, 54, 98, 3, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1926, 62, 62, 1, 27, "Input"],
Cell[1991, 65, 127, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2155, 73, 62, 1, 27, "Input"],
Cell[2220, 76, 127, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2384, 84, 62, 1, 27, "Input"],
Cell[2449, 87, 127, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

