(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3154,        118]*)
(*NotebookOutlinePosition[      3794,        141]*)
(*  CellTagsIndexPosition[      3750,        137]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(n = {nx, ny, nz}\)], "Input"],

Cell[BoxData[
    \({nx, ny, nz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m\  = \ {nx, 0, nz}\)], "Input"],

Cell[BoxData[
    \({nx, 0, nz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p = {px, py, pz}\)], "Input"],

Cell[BoxData[
    \({px, py, pz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pp = {ppx, ppy, ppz}\)], "Input"],

Cell[BoxData[
    \({ppx, ppy, ppz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((p + k\ n - pp)\) . m\)], "Input"],

Cell[BoxData[
    \(nx\ \((k\ nx - ppx + px)\) + nz\ \((k\ nz - ppz + pz)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Solve[\((p + k\ n - pp)\) . m\  \[Equal] \ 0, {k}]]\)], "Input"],

Cell[BoxData[
    \({{k \[Rule] \(nx\ ppx + nz\ ppz - nx\ px - nz\ pz\)\/\(nx\^2 + \
nz\^2\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[\((p + k\ n)\)\  /. \ 
        k \[Rule] \(nx\ ppx + nz\ ppz - nx\ px - nz\ pz\)\/\(nx\^2 + nz\^2\)]\
\)], "Input"],

Cell[BoxData[
    \({px + \(nx\ \((nx\ \((ppx - px)\) + nz\ \((ppz - pz)\))\)\)\/\(nx\^2 + \
nz\^2\), py + \(ny\ \((nx\ \((ppx - px)\) + nz\ \((ppz - pz)\))\)\)\/\(nx\^2 \
+ nz\^2\), \(nz\ \((nx\ \((ppx - px)\) + nz\ \((ppz - pz)\))\)\)\/\(nx\^2 + \
nz\^2\) + pz}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{884, 788},
WindowMargins->{{58, Automatic}, {Automatic, 15}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 49, 1, 27, "Input"],
Cell[1791, 54, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1874, 60, 52, 1, 27, "Input"],
Cell[1929, 63, 45, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2011, 69, 49, 1, 27, "Input"],
Cell[2063, 72, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2146, 78, 53, 1, 27, "Input"],
Cell[2202, 81, 49, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2288, 87, 56, 1, 27, "Input"],
Cell[2347, 90, 89, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2473, 96, 93, 1, 27, "Input"],
Cell[2569, 99, 108, 2, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2714, 106, 144, 3, 41, "Input"],
Cell[2861, 111, 277, 4, 43, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

