# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2013 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.


"""Tests for the FriendsApp App"""

from __future__ import absolute_import

from testtools.matchers import Equals, NotEquals
from autopilot.matchers import Eventually

from friends_app.tests import FriendsAppTestCase


class TestTimelineView(FriendsAppTestCase):
    """Tests the main friends-app features"""

    """ This is needed to wait for the application to start.
        In the testfarm, the application may take some time to show up."""
    def setUp(self):
        super(TestTimelineView, self).setUp()
        self.assertThat(self.timeline_view.get_main_view().visible, Eventually(Equals(True)))

    def tearDown(self):
        super(TestTimelineView, self).tearDown()

    def test_mainView_visible(self):
        self.assertThat(self.timeline_view.get_main_view().visible, Eventually(Equals(True)))

    """
    def test_stream_model_count(self):
        streammodel = self.timeline_view.get_stream_model()
        self.assertThat(streammodel.count, Eventually(NotEquals(0)))
    """

    def test_toolbar(self):
        """Make sure the ToolBar functions."""
        toolbar = self.timeline_view.get_toolbar()
        self.assertThat(toolbar.state, Equals(''))
        self.reveal_toolbar()
        self.assertThat(toolbar.state, Equals('spread'))
